/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import com.beemans.common.R;
import com.beemans.common.app.CommonConfig;
import com.beemans.common.ext.CommonResourceExtKt;
import com.beemans.common.utils.AppStoreUtilsKt;
import com.beemans.common.utils.ToastUtils;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.RomUtils;
import com.blankj.utilcode.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0010\u0010 \u001a\u00020\u00162\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a<\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160'\u001a2\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160'\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"'\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"GOOGLE_PLAY_APP_STORE_PACKAGE_NAME", "", "MARKET_PKG_NAME_360", "MARKET_PKG_NAME_ALI", "MARKET_PKG_NAME_BD", "MARKET_PKG_NAME_HW", "MARKET_PKG_NAME_MI", "MARKET_PKG_NAME_OPPO", "MARKET_PKG_NAME_VIVO", "MARKET_PKG_NAME_YYB", "TAG", "marketPkgNameMap", "", "getMarketPkgNameMap", "()Ljava/util/Map;", "marketPkgNameMap$delegate", "Lkotlin/Lazy;", "getAppStoreIntent", "Landroid/content/Intent;", "pkgName", "marketPkgName", "isIncludeGoogle", "", "getAvailableIntentSize", "", "intent", "getLeecoAppStoreIntent", "packageName", "getMarketPkgNameByChannel", "channel", "getSamsungAppStoreIntent", "isAppSystem", "isExistHwMarket", "isExistMarketByChannel", "jumpToAppStore", "", "context", "Landroid/content/Context;", "onFailed", "Lkotlin/Function0;", "jumpToHwAppStore", "common_release"})
public final class AppStoreUtilsKt {
    @NotNull
    private static final String TAG = "AppStoreUtils";
    @NotNull
    private static final String GOOGLE_PLAY_APP_STORE_PACKAGE_NAME = "com.android.vending";
    @NotNull
    private static final String MARKET_PKG_NAME_HW = "com.huawei.appmarket";
    @NotNull
    private static final String MARKET_PKG_NAME_VIVO = "com.bbk.appstore";
    @NotNull
    private static final String MARKET_PKG_NAME_OPPO = "com.oppo.market";
    @NotNull
    private static final String MARKET_PKG_NAME_MI = "com.xiaomi.market";
    @NotNull
    private static final String MARKET_PKG_NAME_YYB = "com.tencent.android.qqdownloader";
    @NotNull
    private static final String MARKET_PKG_NAME_360 = "com.qihoo.appstore";
    @NotNull
    private static final String MARKET_PKG_NAME_BD = "com.baidu.appsearch";
    @NotNull
    private static final String MARKET_PKG_NAME_ALI = "com.wandoujia.phoenix2";
    @NotNull
    private static final Lazy marketPkgNameMap$delegate = LazyKt.lazy((Function0)marketPkgNameMap.2.INSTANCE);

    private static final Map<String, String> getMarketPkgNameMap() {
        Lazy lazy = marketPkgNameMap$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public static final Intent getAppStoreIntent(@NotNull String pkgName, @NotNull String marketPkgName, boolean isIncludeGoogle) {
        Object[] objectArray;
        Intent leecoAppStoreIntent;
        Intent samsungAppStoreIntent;
        Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
        Intrinsics.checkNotNullParameter((Object)marketPkgName, (String)"marketPkgName");
        if (RomUtils.isSamsung() && (samsungAppStoreIntent = AppStoreUtilsKt.getSamsungAppStoreIntent(pkgName)) != null) {
            return samsungAppStoreIntent;
        }
        if (RomUtils.isLeeco() && (leecoAppStoreIntent = AppStoreUtilsKt.getLeecoAppStoreIntent(pkgName)) != null) {
            return leecoAppStoreIntent;
        }
        String newPackageName = StringsKt.isBlank((CharSequence)pkgName) ? CommonConfig.INSTANCE.getPackageName() : pkgName;
        Uri uri = Uri.parse((String)("market://details?id=" + newPackageName));
        Object[] $this$getAppStoreIntent_u24lambda_u2d0 = objectArray = new Intent("android.intent.action.VIEW", uri);
        boolean bl = false;
        $this$getAppStoreIntent_u24lambda_u2d0.addFlags(0x10000000);
        Object[] intent = objectArray;
        List list = Utils.getApp().getPackageManager().queryIntentActivities((Intent)intent, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getApp().packageManager\n\u2026nager.MATCH_DEFAULT_ONLY)");
        List resolveInfoList = list;
        if (resolveInfoList.size() == 0) {
            $this$getAppStoreIntent_u24lambda_u2d0 = new Object[]{"No app store!"};
            LogUtils.eTag((String)TAG, (Object[])$this$getAppStoreIntent_u24lambda_u2d0);
            return null;
        }
        List phoneMarketPkgNameList = new ArrayList();
        String appSystemMarketPkgName = null;
        String appSystemMarketPkgNameByChannel = null;
        Iterable $this$forEach$iv = resolveInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolveInfo resolveInfo = (ResolveInfo)element$iv;
            boolean bl2 = false;
            String packageName2 = resolveInfo.activityInfo.packageName;
            Intrinsics.checkNotNullExpressionValue((Object)packageName2, (String)"packageName");
            phoneMarketPkgNameList.add(packageName2);
            if (!AppStoreUtilsKt.isAppSystem(packageName2) || !isIncludeGoogle && Intrinsics.areEqual((Object)packageName2, (Object)GOOGLE_PLAY_APP_STORE_PACKAGE_NAME)) continue;
            appSystemMarketPkgName = packageName2;
            if (!AppStoreUtilsKt.getMarketPkgNameMap().containsValue(packageName2)) continue;
            appSystemMarketPkgNameByChannel = packageName2;
        }
        if (appSystemMarketPkgNameByChannel != null) {
            appSystemMarketPkgName = appSystemMarketPkgNameByChannel;
        }
        if (!StringsKt.isBlank((CharSequence)marketPkgName) && phoneMarketPkgNameList.contains(marketPkgName)) {
            intent.setPackage(marketPkgName);
        } else if (isIncludeGoogle && phoneMarketPkgNameList.contains(GOOGLE_PLAY_APP_STORE_PACKAGE_NAME)) {
            intent.setPackage(GOOGLE_PLAY_APP_STORE_PACKAGE_NAME);
        } else {
            String string2 = appSystemMarketPkgName;
            boolean bl3 = string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false;
            if (bl3) {
                intent.setPackage(appSystemMarketPkgName);
            }
        }
        return intent;
    }

    public static /* synthetic */ Intent getAppStoreIntent$default(String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = CommonConfig.INSTANCE.getPackageName();
        }
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return AppStoreUtilsKt.getAppStoreIntent(string2, string3, bl);
    }

    public static final void jumpToAppStore(@NotNull Context context, @NotNull String pkgName, @NotNull String marketPkgName, boolean isIncludeGoogle, @NotNull Function0<Boolean> onFailed) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
        Intrinsics.checkNotNullParameter((Object)marketPkgName, (String)"marketPkgName");
        Intrinsics.checkNotNullParameter(onFailed, (String)"onFailed");
        Intent intent = AppStoreUtilsKt.getAppStoreIntent(pkgName, marketPkgName, isIncludeGoogle);
        if ((intent == null || !ActivityUtils.startActivity((Intent)intent)) && ((Boolean)onFailed.invoke()).booleanValue()) {
            ToastUtils.INSTANCE.showShort(CommonResourceExtKt.toString2(R.string.common_unable_open_app_market, context, new Object[0]));
        }
    }

    public static /* synthetic */ void jumpToAppStore$default(Context context, String string2, String string3, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function0 = jumpToAppStore.1.INSTANCE;
        }
        AppStoreUtilsKt.jumpToAppStore(context, string2, string3, bl, (Function0<Boolean>)function0);
    }

    public static final void jumpToHwAppStore(@NotNull Context context, @NotNull String pkgName, boolean isIncludeGoogle, @NotNull Function0<Boolean> onFailed) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
        Intrinsics.checkNotNullParameter(onFailed, (String)"onFailed");
        AppStoreUtilsKt.jumpToAppStore(context, pkgName, AppStoreUtilsKt.getMarketPkgNameByChannel("huawei"), isIncludeGoogle, onFailed);
    }

    public static /* synthetic */ void jumpToHwAppStore$default(Context context, String string2, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            function0 = jumpToHwAppStore.1.INSTANCE;
        }
        AppStoreUtilsKt.jumpToHwAppStore(context, string2, bl, (Function0<Boolean>)function0);
    }

    public static final boolean isExistHwMarket(@NotNull String pkgName) {
        Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
        return AppStoreUtilsKt.isExistMarketByChannel("huawei", pkgName);
    }

    public static /* synthetic */ boolean isExistHwMarket$default(String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = CommonConfig.INSTANCE.getPackageName();
        }
        return AppStoreUtilsKt.isExistHwMarket(string2);
    }

    public static final boolean isExistMarketByChannel(@NotNull String channel, @NotNull String pkgName) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
        Uri uri = Uri.parse((String)("market://details?id=" + pkgName));
        Intent $this$isExistMarketByChannel_u24lambda_u2d2 = intent = new Intent("android.intent.action.VIEW", uri);
        boolean bl = false;
        $this$isExistMarketByChannel_u24lambda_u2d2.addFlags(0x10000000);
        Intent intent2 = intent;
        List list = Utils.getApp().getPackageManager().queryIntentActivities(intent2, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getApp().packageManager\n\u2026nager.MATCH_DEFAULT_ONLY)");
        List resolveInfoList = list;
        if (resolveInfoList.size() == 0) {
            return false;
        }
        if (StringsKt.isBlank((CharSequence)channel)) {
            return true;
        }
        Iterable $this$forEach$iv = resolveInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolveInfo resolveInfo = (ResolveInfo)element$iv;
            boolean bl2 = false;
            String packageName2 = resolveInfo.activityInfo.packageName;
            if (!Intrinsics.areEqual((Object)packageName2, (Object)AppStoreUtilsKt.getMarketPkgNameByChannel(channel))) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean isExistMarketByChannel$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = CommonConfig.INSTANCE.getPackageName();
        }
        return AppStoreUtilsKt.isExistMarketByChannel(string2, string3);
    }

    @NotNull
    public static final String getMarketPkgNameByChannel(@NotNull String channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        String string2 = AppStoreUtilsKt.getMarketPkgNameMap().get(channel);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final int getAvailableIntentSize(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size();
    }

    public static final boolean isAppSystem(@NotNull String marketPkgName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)marketPkgName, (String)"marketPkgName");
        if (StringsKt.isBlank((CharSequence)marketPkgName)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                PackageManager pm = Utils.getApp().getPackageManager();
                ApplicationInfo applicationInfo = pm.getApplicationInfo(marketPkgName, 0);
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(marketPkgName, 0)");
                ApplicationInfo ai = applicationInfo;
                bl2 = (ai.flags & 1) != 0;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private static final Intent getSamsungAppStoreIntent(String packageName2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setClassName("com.sec.android.app.samsungapps", "com.sec.android.app.samsungapps.Main");
        intent.setData(Uri.parse((String)("http://www.samsungapps.com/appquery/appDetail.as?appId=" + packageName2)));
        intent.addFlags(0x10000000);
        return AppStoreUtilsKt.getAvailableIntentSize(intent) > 0 ? intent : null;
    }

    private static final Intent getLeecoAppStoreIntent(String packageName2) {
        Intent intent;
        Intent $this$getLeecoAppStoreIntent_u24lambda_u2d4 = intent = new Intent();
        boolean bl = false;
        $this$getLeecoAppStoreIntent_u24lambda_u2d4.setClassName("com.letv.app.appstore", "com.letv.app.appstore.appmodule.details.DetailsActivity");
        $this$getLeecoAppStoreIntent_u24lambda_u2d4.setAction("com.letv.app.appstore.appdetailactivity");
        $this$getLeecoAppStoreIntent_u24lambda_u2d4.putExtra("packageName", packageName2);
        $this$getLeecoAppStoreIntent_u24lambda_u2d4.addFlags(0x10000000);
        Intent intent2 = intent;
        return AppStoreUtilsKt.getAvailableIntentSize(intent2) > 0 ? intent2 : null;
    }
}

