/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.utils;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.core.view.GestureDetectorCompat;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0002=>B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0002J\u0012\u0010'\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J,\u0010*\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010)2\b\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u0018\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u00103\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0010\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0016H\u0016J,\u00106\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010)2\b\u0010,\u001a\u0004\u0018\u00010)2\u0006\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020.H\u0016J\u0012\u00109\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010:\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0018\u0010;\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010<\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/beemans/common/utils/ItemSlideHelper;", "Landroidx/recyclerview/widget/RecyclerView$OnItemTouchListener;", "Landroid/view/GestureDetector$OnGestureListener;", "context", "Landroid/content/Context;", "callback", "Lcom/beemans/common/utils/ItemSlideHelper$Callback;", "(Landroid/content/Context;Lcom/beemans/common/utils/ItemSlideHelper$Callback;)V", "activePointerId", "", "expandAndCollapseAnim", "Landroid/animation/Animator;", "gestureDetector", "Landroidx/core/view/GestureDetectorCompat;", "getGestureDetector", "()Landroidx/core/view/GestureDetectorCompat;", "gestureDetector$delegate", "Lkotlin/Lazy;", "horizontalRange", "getHorizontalRange", "()I", "isCollapsed", "", "()Z", "isDragging", "isExpanded", "lastX", "lastY", "maxVelocity", "minVelocity", "targetView", "Landroid/view/View;", "touchSlop", "horizontalDrag", "", "delta", "inView", "x", "y", "onDown", "e", "Landroid/view/MotionEvent;", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onInterceptTouchEvent", "rv", "Landroidx/recyclerview/widget/RecyclerView;", "onLongPress", "onRequestDisallowInterceptTouchEvent", "disallowIntercept", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onTouchEvent", "smoothHorizontalExpandOrCollapse", "Callback", "Companion", "common_release"})
public final class ItemSlideHelper
implements RecyclerView.OnItemTouchListener,
GestureDetector.OnGestureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Callback callback;
    @Nullable
    private View targetView;
    private int activePointerId;
    private final int touchSlop;
    private final int maxVelocity;
    private final int minVelocity;
    private int lastX;
    private int lastY;
    private boolean isDragging;
    @Nullable
    private Animator expandAndCollapseAnim;
    @NotNull
    private final Lazy gestureDetector$delegate;
    public static final int DEFAULT_DURATION = 200;

    public ItemSlideHelper(@NotNull Context context, @NotNull Callback callback) {
        ViewConfiguration viewConfiguration;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callback = callback;
        this.gestureDetector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureDetectorCompat>(context, this){
            final /* synthetic */ Context $context;
            final /* synthetic */ ItemSlideHelper this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GestureDetectorCompat invoke() {
                return new GestureDetectorCompat(this.$context, (GestureDetector.OnGestureListener)this.this$0);
            }
        }));
        ViewConfiguration $this$_init__u24lambda_u2d0 = viewConfiguration = ViewConfiguration.get((Context)context);
        boolean bl = false;
        this.touchSlop = $this$_init__u24lambda_u2d0.getScaledTouchSlop();
        this.maxVelocity = $this$_init__u24lambda_u2d0.getScaledMaximumFlingVelocity();
        this.minVelocity = $this$_init__u24lambda_u2d0.getScaledMinimumFlingVelocity();
    }

    private final GestureDetectorCompat getGestureDetector() {
        Lazy lazy = this.gestureDetector$delegate;
        return (GestureDetectorCompat)lazy.getValue();
    }

    private final int getHorizontalRange() {
        RecyclerView.ViewHolder viewHolder = this.callback.getChildViewHolder(this.targetView);
        return this.callback.getHorizontalRange(viewHolder);
    }

    private final boolean isExpanded() {
        View view = this.targetView;
        return (view != null ? view.getScrollX() == this.getHorizontalRange() : false) && this.getHorizontalRange() > 0;
    }

    private final boolean isCollapsed() {
        View view = this.targetView;
        return (view != null ? view.getScrollX() : 0) <= 0;
    }

    public boolean onInterceptTouchEvent(@NotNull RecyclerView rv, @NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)rv, (String)"rv");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (rv.getScrollState() != 0) {
            if (this.targetView != null) {
                this.smoothHorizontalExpandOrCollapse(100.0f);
                this.targetView = null;
            }
            return false;
        }
        Animator animator = this.expandAndCollapseAnim;
        boolean bl = animator != null ? animator.isRunning() : false;
        if (bl) {
            return true;
        }
        boolean needIntercept = false;
        int x = (int)e.getX();
        int y = (int)e.getY();
        switch (e.getAction()) {
            case 0: {
                this.activePointerId = e.getPointerId(0);
                this.lastX = (int)e.getX();
                this.lastY = (int)e.getY();
                if (this.targetView != null) {
                    return !this.inView(x, y);
                }
                this.targetView = this.callback.findTargetView(x, y);
                break;
            }
            case 2: {
                int deltaX = x - this.lastX;
                int deltaY = y - this.lastY;
                if (Math.abs(deltaY) > Math.abs(deltaX)) {
                    return false;
                }
                ItemSlideHelper $this$onInterceptTouchEvent_u24lambda_u2d1 = this;
                boolean bl2 = false;
                needIntercept = $this$onInterceptTouchEvent_u24lambda_u2d1.isDragging = $this$onInterceptTouchEvent_u24lambda_u2d1.targetView != null && Math.abs(deltaX) >= $this$onInterceptTouchEvent_u24lambda_u2d1.touchSlop;
                break;
            }
            case 1: 
            case 3: {
                if (this.isExpanded()) {
                    if (!this.inView(x, y)) {
                        needIntercept = true;
                    }
                    this.smoothHorizontalExpandOrCollapse(100.0f);
                }
                this.targetView = null;
            }
        }
        rv.getParent().requestDisallowInterceptTouchEvent(true);
        return needIntercept;
    }

    public void onTouchEvent(@NotNull RecyclerView rv, @NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)rv, (String)"rv");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Animator animator = this.expandAndCollapseAnim;
        boolean bl = animator != null ? animator.isRunning() : false;
        if (bl || this.targetView == null) {
            return;
        }
        if (this.getGestureDetector().onTouchEvent(e)) {
            this.isDragging = false;
            return;
        }
        int x = (int)e.getX();
        switch (e.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                int deltaX = (int)((float)this.lastX - e.getX());
                if (this.isDragging) {
                    this.horizontalDrag(deltaX);
                }
                this.lastX = x;
                break;
            }
            case 1: 
            case 3: {
                if (!this.isDragging) break;
                if (!this.smoothHorizontalExpandOrCollapse(0.0f) && this.isCollapsed()) {
                    this.targetView = null;
                }
                this.isDragging = false;
            }
        }
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public boolean onDown(@Nullable MotionEvent e) {
        return false;
    }

    public void onShowPress(@Nullable MotionEvent e) {
    }

    public boolean onSingleTapUp(@Nullable MotionEvent e) {
        return false;
    }

    public boolean onScroll(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    public void onLongPress(@Nullable MotionEvent e) {
    }

    public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
        if (Math.abs(velocityX) > (float)this.minVelocity && Math.abs(velocityX) < (float)this.maxVelocity && !this.smoothHorizontalExpandOrCollapse(velocityX)) {
            if (this.isCollapsed()) {
                this.targetView = null;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ObjectAnimatorBinding"})
    private final boolean smoothHorizontalExpandOrCollapse(float velocityX) {
        void $this$smoothHorizontalExpandOrCollapse_u24lambda_u2d2;
        if (this.targetView == null) {
            return false;
        }
        View view = this.targetView;
        Intrinsics.checkNotNull((Object)view);
        int scrollX = view.getScrollX();
        int scrollRange = this.getHorizontalRange();
        if (this.expandAndCollapseAnim != null) {
            return false;
        }
        int to = 0;
        int duration = 0;
        duration = 200;
        if (velocityX == 0.0f) {
            if (scrollX > scrollRange / 2) {
                to = scrollRange;
            }
        } else {
            to = velocityX > 0.0f ? 0 : scrollRange;
            duration = (int)((1.0f - Math.abs(velocityX) / (float)this.maxVelocity) * (float)200);
        }
        if (to == scrollX) {
            return false;
        }
        Object object = new int[]{to};
        Object object2 = object = (Object)ObjectAnimator.ofInt((Object)this.targetView, (String)"scrollX", (int[])object);
        ItemSlideHelper itemSlideHelper = this;
        boolean bl = false;
        $this$smoothHorizontalExpandOrCollapse_u24lambda_u2d2.setDuration((long)duration);
        $this$smoothHorizontalExpandOrCollapse_u24lambda_u2d2.addListener(new Animator.AnimatorListener(this){
            final /* synthetic */ ItemSlideHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationStart(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                ItemSlideHelper.access$setExpandAndCollapseAnim$p(this.this$0, null);
                if (ItemSlideHelper.access$isCollapsed(this.this$0)) {
                    ItemSlideHelper.access$setTargetView$p(this.this$0, null);
                }
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                ItemSlideHelper.access$setExpandAndCollapseAnim$p(this.this$0, null);
            }

            public void onAnimationRepeat(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            }
        });
        $this$smoothHorizontalExpandOrCollapse_u24lambda_u2d2.start();
        itemSlideHelper.expandAndCollapseAnim = (Animator)object;
        return true;
    }

    private final boolean inView(int x, int y) {
        View view = this.targetView;
        if (view != null) {
            View $this$inView_u24lambda_u2d3 = view;
            boolean bl = false;
            int scrollX = $this$inView_u24lambda_u2d3.getScrollX();
            int left = $this$inView_u24lambda_u2d3.getWidth() - scrollX;
            int top = $this$inView_u24lambda_u2d3.getTop();
            int right = left + this.getHorizontalRange();
            int bottom = $this$inView_u24lambda_u2d3.getBottom();
            Rect rect2 = new Rect(left, top, right, bottom);
            return rect2.contains(x, y);
        }
        return false;
    }

    private final void horizontalDrag(int delta) {
        block3: {
            View view;
            View view2 = this.targetView;
            if (view2 == null) break block3;
            View $this$horizontalDrag_u24lambda_u2d4 = view = view2;
            boolean bl = false;
            int scrollX = $this$horizontalDrag_u24lambda_u2d4.getScrollX();
            int scrollY = $this$horizontalDrag_u24lambda_u2d4.getScrollY();
            if (scrollX + delta <= 0) {
                $this$horizontalDrag_u24lambda_u2d4.scrollTo(0, scrollY);
                return;
            }
            int horRange = this.getHorizontalRange();
            if (Math.abs(scrollX += delta) < horRange) {
                $this$horizontalDrag_u24lambda_u2d4.scrollTo(scrollX, scrollY);
            } else {
                $this$horizontalDrag_u24lambda_u2d4.scrollTo(horRange, scrollY);
            }
        }
    }

    public static final /* synthetic */ void access$setExpandAndCollapseAnim$p(ItemSlideHelper $this, Animator animator) {
        $this.expandAndCollapseAnim = animator;
    }

    public static final /* synthetic */ boolean access$isCollapsed(ItemSlideHelper $this) {
        return $this.isCollapsed();
    }

    public static final /* synthetic */ void access$setTargetView$p(ItemSlideHelper $this, View view) {
        $this.targetView = view;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/beemans/common/utils/ItemSlideHelper$Companion;", "", "()V", "DEFAULT_DURATION", "", "common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H&J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\r"}, d2={"Lcom/beemans/common/utils/ItemSlideHelper$Callback;", "", "findTargetView", "Landroid/view/View;", "x", "", "y", "getChildViewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "childView", "getHorizontalRange", "", "holder", "common_release"})
    public static interface Callback {
        public int getHorizontalRange(@Nullable RecyclerView.ViewHolder var1);

        @NotNull
        public RecyclerView.ViewHolder getChildViewHolder(@Nullable View var1);

        @Nullable
        public View findTargetView(float var1, float var2);
    }
}

