/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.utils.permissions;

import com.beemans.common.utils.permissions.AndroidVersion;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lcom/beemans/common/utils/permissions/PermissionChecker;", "", "()V", "optimizeDeprecatedPermission", "", "requestPermissions", "", "", "common_release"})
public final class PermissionChecker {
    @NotNull
    public static final PermissionChecker INSTANCE = new PermissionChecker();

    private PermissionChecker() {
    }

    public final void optimizeDeprecatedPermission(@NotNull List<String> requestPermissions) {
        Intrinsics.checkNotNullParameter(requestPermissions, (String)"requestPermissions");
        if (!AndroidVersion.INSTANCE.isAndroid12() && requestPermissions.contains("android.permission.BLUETOOTH_SCAN") && !requestPermissions.contains("android.permission.ACCESS_FINE_LOCATION")) {
            requestPermissions.add("android.permission.ACCESS_FINE_LOCATION");
        }
        if (requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (!(!requestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") && !requestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE"))) {
                boolean bl = false;
                String string2 = "If you have applied for MANAGE_EXTERNAL_STORAGE permissions, do not apply for the READ_EXTERNAL_STORAGE and WRITE_EXTERNAL_STORAGE permissions";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!AndroidVersion.INSTANCE.isAndroid11()) {
                requestPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
                requestPermissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.INSTANCE.isAndroid8() && requestPermissions.contains("android.permission.READ_PHONE_NUMBERS") && !requestPermissions.contains("android.permission.READ_PHONE_STATE")) {
            requestPermissions.add("android.permission.READ_PHONE_STATE");
        }
        if (!AndroidVersion.INSTANCE.isAndroid10() && requestPermissions.contains("android.permission.ACTIVITY_RECOGNITION") && !requestPermissions.contains("android.permission.BODY_SENSORS")) {
            requestPermissions.add("android.permission.BODY_SENSORS");
        }
    }
}

