/*
 * Decompiled with CFR 0.152.
 */
package com.beemans.common.utils.permissions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import androidx.appcompat.app.AlertDialog;
import com.beemans.common.R;
import com.beemans.common.ext.CommonResourceExtKt;
import com.beemans.common.utils.permissions.PermissionDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0003J<\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a8\u0006\u000e"}, d2={"Lcom/beemans/common/utils/permissions/PermissionDialog;", "", "()V", "getPermissionHint", "", "context", "Landroid/content/Context;", "permissions", "", "showPermissionDialog", "", "onNegativeAction", "Lkotlin/Function0;", "onPositiveAction", "common_release"})
public final class PermissionDialog {
    @NotNull
    public static final PermissionDialog INSTANCE = new PermissionDialog();

    private PermissionDialog() {
    }

    public final void showPermissionDialog(@NotNull Context context, @NotNull List<String> permissions, @NotNull Function0<Unit> onNegativeAction, @NotNull Function0<Unit> onPositiveAction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter(onNegativeAction, (String)"onNegativeAction");
        Intrinsics.checkNotNullParameter(onPositiveAction, (String)"onPositiveAction");
        new AlertDialog.Builder(context).setCancelable(false).setTitle(R.string.common_permission_alert).setMessage((CharSequence)this.getPermissionHint(context, permissions)).setPositiveButton(R.string.common_permission_goto, (arg_0, arg_1) -> PermissionDialog.showPermissionDialog$lambda-0(onPositiveAction, arg_0, arg_1)).setNegativeButton(R.string.common_permission_cancel, (arg_0, arg_1) -> PermissionDialog.showPermissionDialog$lambda-1(onNegativeAction, arg_0, arg_1)).show();
    }

    public static /* synthetic */ void showPermissionDialog$default(PermissionDialog permissionDialog, Context context, List list, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = showPermissionDialog.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function02 = showPermissionDialog.2.INSTANCE;
        }
        permissionDialog.showPermissionDialog(context, list, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    @SuppressLint(value={"ResourceType"})
    private final String getPermissionHint(Context context, List<String> permissions) {
        List hints = new ArrayList();
        Iterator<String> iterator = permissions.iterator();
        while (iterator.hasNext()) {
            String permission;
            switch (permission = iterator.next()) {
                case "android.permission.WRITE_EXTERNAL_STORAGE": 
                case "android.permission.READ_EXTERNAL_STORAGE": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_storage, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.CAMERA": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_camera, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.RECORD_AUDIO": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_microphone, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.ACCESS_FINE_LOCATION": 
                case "android.permission.ACCESS_COARSE_LOCATION": 
                case "android.permission.ACCESS_BACKGROUND_LOCATION": {
                    String hint;
                    String string2 = hint = !permissions.contains("android.permission.ACCESS_FINE_LOCATION") && !permissions.contains("android.permission.ACCESS_COARSE_LOCATION") ? CommonResourceExtKt.toString2(R.string.common_permission_location_background, context, new Object[0]) : CommonResourceExtKt.toString2(R.string.common_permission_location, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.BLUETOOTH_ADVERTISE": 
                case "android.permission.BLUETOOTH_SCAN": 
                case "android.permission.BLUETOOTH_CONNECT": {
                    String hint;
                    if (Build.VERSION.SDK_INT < 31 || hints.contains(hint = CommonResourceExtKt.toString2(R.string.common_permission_bluetooth, context, new Object[0]))) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.CALL_PHONE": 
                case "android.permission.READ_PHONE_NUMBERS": 
                case "com.android.voicemail.permission.ADD_VOICEMAIL": 
                case "android.permission.USE_SIP": 
                case "android.permission.ANSWER_PHONE_CALLS": 
                case "android.permission.READ_PHONE_STATE": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_phone, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.READ_CONTACTS": 
                case "android.permission.GET_ACCOUNTS": 
                case "android.permission.WRITE_CONTACTS": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_contacts, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.WRITE_CALENDAR": 
                case "android.permission.READ_CALENDAR": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_calendar, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.PROCESS_OUTGOING_CALLS": 
                case "android.permission.WRITE_CALL_LOG": 
                case "android.permission.READ_CALL_LOG": {
                    String hint;
                    String string3 = hint = Build.VERSION.SDK_INT >= 29 ? CommonResourceExtKt.toString2(R.string.common_permission_call_log, context, new Object[0]) : CommonResourceExtKt.toString2(R.string.common_permission_phone, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.BODY_SENSORS": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_sensors, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.ACTIVITY_RECOGNITION": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_activity_recognition, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.READ_SMS": 
                case "android.permission.SEND_SMS": 
                case "android.permission.RECEIVE_SMS": 
                case "android.permission.RECEIVE_WAP_PUSH": 
                case "android.permission.RECEIVE_MMS": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_sms, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.MANAGE_EXTERNAL_STORAGE": {
                    String hint;
                    if (Build.VERSION.SDK_INT < 30) break;
                    Intrinsics.checkNotNullExpressionValue((Object)context.getString(R.string.common_permission_manage_storage), (String)"context.getString(R.stri\u2026ermission_manage_storage)");
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.REQUEST_INSTALL_PACKAGES": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_install, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.SYSTEM_ALERT_WINDOW": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_window, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.WRITE_SETTINGS": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_setting, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.NOTIFICATION_SERVICE": {
                    String hint = CommonResourceExtKt.toString2(R.string.common_permission_notification, context, new Object[0]);
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.PACKAGE_USAGE_STATS": {
                    String hint;
                    Intrinsics.checkNotNullExpressionValue((Object)context.getString(R.string.common_permission_task), (String)"context.getString(R.string.common_permission_task)");
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.SCHEDULE_EXACT_ALARM": {
                    String hint;
                    Intrinsics.checkNotNullExpressionValue((Object)context.getString(R.string.common_permission_alarm), (String)"context.getString(R.stri\u2026.common_permission_alarm)");
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.ACCESS_NOTIFICATION_POLICY": {
                    String hint;
                    Intrinsics.checkNotNullExpressionValue((Object)context.getString(R.string.common_permission_not_disturb), (String)"context.getString(R.stri\u2026n_permission_not_disturb)");
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                    break;
                }
                case "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS": {
                    String hint;
                    Intrinsics.checkNotNullExpressionValue((Object)context.getString(R.string.common_permission_ignore_battery), (String)"context.getString(R.stri\u2026ermission_ignore_battery)");
                    if (hints.contains(hint)) break;
                    hints.add(hint);
                }
            }
        }
        if (!((Collection)hints).isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String text : hints) {
                if (((CharSequence)builder).length() == 0) {
                    builder.append(text);
                    continue;
                }
                builder.append("\u3001").append(text);
            }
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)builder.toString(), (String)"builder.toString()");
            return CommonResourceExtKt.toString2(R.string.common_permission_fail_3, context, objectArray);
        }
        return CommonResourceExtKt.toString2(R.string.common_permission_fail_2, context, new Object[0]);
    }

    private static final void showPermissionDialog$lambda-0(Function0 $onPositiveAction, DialogInterface dialog, int n) {
        Intrinsics.checkNotNullParameter((Object)$onPositiveAction, (String)"$onPositiveAction");
        dialog.dismiss();
        $onPositiveAction.invoke();
    }

    private static final void showPermissionDialog$lambda-1(Function0 $onNegativeAction, DialogInterface dialog, int n) {
        Intrinsics.checkNotNullParameter((Object)$onNegativeAction, (String)"$onNegativeAction");
        dialog.dismiss();
        $onNegativeAction.invoke();
    }
}

