/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.cookie;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.tiamosu.fly.http.cookie.PersistentCookieStore;
import com.tiamosu.fly.http.cookie.SerializableHttpCookie;
import com.tiamosu.fly.http.utils.FlyHttpLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cookie;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u0014\u0010\u0018\u001a\u00020\u00142\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\fH\u0004J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010 H\u0004J\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0004J\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0019J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\fH\u0004J\u0016\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010'\u001a\u00020&R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007RO\u0010\n\u001a6\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\r0\u000bj\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\r`\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\t\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/tiamosu/fly/http/cookie/PersistentCookieStore;", "", "()V", "cookiePrefs", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "getCookiePrefs", "()Landroid/content/SharedPreferences;", "cookiePrefs$delegate", "Lkotlin/Lazy;", "cookies", "Ljava/util/HashMap;", "", "Ljava/util/concurrent/ConcurrentHashMap;", "Lokhttp3/Cookie;", "Lkotlin/collections/HashMap;", "getCookies", "()Ljava/util/HashMap;", "cookies$delegate", "add", "", "url", "Lokhttp3/HttpUrl;", "cookie", "addCookies", "", "byteArrayToHexString", "bytes", "", "decodeCookie", "cookieString", "encodeCookie", "Lcom/tiamosu/fly/http/cookie/SerializableHttpCookie;", "get", "getCookieToken", "hexStringToByteArray", "hexString", "remove", "", "removeAll", "Companion", "fly-http_release"})
public final class PersistentCookieStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy cookies$delegate = LazyKt.lazy((Function0)cookies.2.INSTANCE);
    @NotNull
    private final Lazy cookiePrefs$delegate = LazyKt.lazy((Function0)cookiePrefs.2.INSTANCE);
    @NotNull
    private static final String COOKIE_PREFS = "Cookies_Prefs";

    public PersistentCookieStore() {
        Map prefsMap = this.getCookiePrefs().getAll();
        Intrinsics.checkNotNullExpressionValue((Object)prefsMap, (String)"prefsMap");
        block0: for (Map.Entry entry : prefsMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String[] cookieNames = TextUtils.split((String)(value instanceof String ? (String)value : null), (String)",");
            Intrinsics.checkNotNullExpressionValue((Object)cookieNames, (String)"cookieNames");
            for (String name : cookieNames) {
                String encodedCookie;
                if (this.getCookiePrefs().getString(name, null) == null) continue block0;
                Cookie decodedCookie = this.decodeCookie(encodedCookie);
                if (decodedCookie == null) continue;
                if (!this.getCookies().containsKey(key)) {
                    Map map = this.getCookies();
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    map.put(key, new ConcurrentHashMap());
                }
                ConcurrentHashMap<String, Cookie> concurrentHashMap = this.getCookies().get(key);
                if (concurrentHashMap == null) continue;
                Map map = concurrentHashMap;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                map.put(name, decodedCookie);
            }
        }
    }

    private final HashMap<String, ConcurrentHashMap<String, Cookie>> getCookies() {
        Lazy lazy = this.cookies$delegate;
        return (HashMap)lazy.getValue();
    }

    private final SharedPreferences getCookiePrefs() {
        Lazy lazy = this.cookiePrefs$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    @NotNull
    protected final String getCookieToken(@NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return cookie.name() + "@" + cookie.domain();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull HttpUrl url, @NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        String name = this.getCookieToken(cookie);
        String host = url.host();
        if (!this.getCookies().containsKey(host)) {
            ((Map)this.getCookies()).put(host, new ConcurrentHashMap());
        }
        if (this.getCookies().containsKey(url.host())) {
            ConcurrentHashMap<String, Cookie> concurrentHashMap = this.getCookies().get(host);
            if (concurrentHashMap != null) {
                concurrentHashMap.remove(name);
            }
        }
        ConcurrentHashMap<String, Cookie> concurrentHashMap = this.getCookies().get(host);
        if (concurrentHashMap != null) {
            ((Map)concurrentHashMap).put(name, cookie);
        }
        if (cookie.persistent()) {
            String string;
            SharedPreferences.Editor prefsWriter;
            SharedPreferences.Editor editor = prefsWriter = this.getCookiePrefs().edit();
            String string2 = host;
            ConcurrentHashMap<String, Cookie> concurrentHashMap2 = this.getCookies().get(host);
            if (concurrentHashMap2 != null && (concurrentHashMap2 = concurrentHashMap2.keySet()) != null) {
                void it;
                ConcurrentHashMap<String, Cookie> concurrentHashMap3 = concurrentHashMap2;
                String string3 = string2;
                SharedPreferences.Editor editor2 = editor;
                boolean bl = false;
                String string4 = TextUtils.join((CharSequence)",", (Iterable)((Iterable)it));
                editor = editor2;
                string2 = string3;
                string = string4;
            } else {
                string = null;
            }
            editor.putString(string2, string);
            prefsWriter.putString(name, this.encodeCookie(new SerializableHttpCookie(cookie)));
            prefsWriter.apply();
        } else {
            SharedPreferences.Editor prefsWriter = this.getCookiePrefs().edit();
            prefsWriter.remove(url.host());
            prefsWriter.remove(name);
            prefsWriter.apply();
        }
    }

    public final void addCookies(@NotNull List<Cookie> cookies2) {
        Intrinsics.checkNotNullParameter(cookies2, (String)"cookies");
        for (Cookie cookie : cookies2) {
            String domain = cookie.domain();
            ConcurrentHashMap<String, Object> domainCookies = this.getCookies().get(domain);
            if (domainCookies != null) continue;
            domainCookies = new ConcurrentHashMap();
            ((Map)this.getCookies()).put(domain, domainCookies);
        }
    }

    @NotNull
    public final List<Cookie> get(@NotNull HttpUrl url) {
        ArrayList ret;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            ret = new ArrayList();
            if (!this.getCookies().containsKey(url.host())) break block1;
            ConcurrentHashMap<String, Cookie> concurrentHashMap = this.getCookies().get(url.host());
            if (concurrentHashMap != null && (concurrentHashMap = concurrentHashMap.values()) != null) {
                ConcurrentHashMap<String, Cookie> it = concurrentHashMap;
                boolean bl = false;
                ret.addAll(it);
            }
        }
        return ret;
    }

    public final boolean removeAll() {
        SharedPreferences.Editor prefsWriter = this.getCookiePrefs().edit();
        prefsWriter.clear();
        prefsWriter.apply();
        this.getCookies().clear();
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean remove(@NotNull HttpUrl url, @NotNull Cookie cookie) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        String name = this.getCookieToken(cookie);
        String host = url.host();
        if (!this.getCookies().containsKey(url.host())) return false;
        ConcurrentHashMap<String, Cookie> concurrentHashMap = this.getCookies().get(host);
        if (concurrentHashMap == null) return false;
        if (!concurrentHashMap.containsKey(name)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConcurrentHashMap<String, Cookie> concurrentHashMap2 = this.getCookies().get(host);
        if (concurrentHashMap2 != null) {
            concurrentHashMap2.remove(name);
        }
        SharedPreferences.Editor prefsWriter = this.getCookiePrefs().edit();
        if (this.getCookiePrefs().contains(name)) {
            prefsWriter.remove(name);
        }
        SharedPreferences.Editor editor = prefsWriter;
        String string2 = host;
        ConcurrentHashMap<String, Cookie> concurrentHashMap3 = this.getCookies().get(host);
        if (concurrentHashMap3 != null && (concurrentHashMap3 = concurrentHashMap3.keySet()) != null) {
            void it;
            ConcurrentHashMap<String, Cookie> concurrentHashMap4 = concurrentHashMap3;
            String string3 = string2;
            SharedPreferences.Editor editor2 = editor;
            boolean bl2 = false;
            String string4 = TextUtils.join((CharSequence)",", (Iterable)((Iterable)it));
            editor = editor2;
            string2 = string3;
            string = string4;
        } else {
            string = null;
        }
        editor.putString(string2, string);
        prefsWriter.apply();
        return true;
    }

    @Nullable
    public final List<Cookie> getCookies() {
        ArrayList ret = new ArrayList();
        for (String key : this.getCookies().keySet()) {
            ConcurrentHashMap<String, Cookie> concurrentHashMap = this.getCookies().get(key);
            if (concurrentHashMap == null || (concurrentHashMap = concurrentHashMap.values()) == null) continue;
            ConcurrentHashMap<String, Cookie> it = concurrentHashMap;
            boolean bl = false;
            ret.addAll(it);
        }
        return ret;
    }

    @Nullable
    protected final String encodeCookie(@Nullable SerializableHttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            FlyHttpLog.INSTANCE.dLog("IOException in encodeCookie" + e.getMessage());
            return null;
        }
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"os.toByteArray()");
        return this.byteArrayToHexString(byArray);
    }

    @Nullable
    protected final Cookie decodeCookie(@NotNull String cookieString) {
        Intrinsics.checkNotNullParameter((Object)cookieString, (String)"cookieString");
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            SerializableHttpCookie serializableHttpCookie = object instanceof SerializableHttpCookie ? (SerializableHttpCookie)object : null;
            cookie = serializableHttpCookie != null ? serializableHttpCookie.getCookie() : null;
        }
        catch (IOException e) {
            FlyHttpLog.INSTANCE.dLog("IOException in decodeCookie" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            FlyHttpLog.INSTANCE.dLog("ClassNotFoundException in decodeCookie" + e.getMessage());
        }
        return cookie;
    }

    @Nullable
    protected final String byteArrayToHexString(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                builder.append('0');
            }
            builder.append(Integer.toHexString(v));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        String string2 = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        return string3;
    }

    @NotNull
    protected final byte[] hexStringToByteArray(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tiamosu/fly/http/cookie/PersistentCookieStore$Companion;", "", "()V", "COOKIE_PREFS", "", "fly-http_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

