/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.https;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.blankj.utilcode.util.CloseUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0007J+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0007\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007JC\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0007\u00a2\u0006\u0002\u0010\u0013J)\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/tiamosu/fly/http/https/HttpsUtils;", "", "()V", "chooseTrustManager", "Ljavax/net/ssl/X509TrustManager;", "trustManagers", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)Ljavax/net/ssl/X509TrustManager;", "getSslSocketFactory", "Lcom/tiamosu/fly/http/https/HttpsUtils$SSLParams;", "bksFile", "Ljava/io/InputStream;", "password", "", "certificates", "(Ljava/io/InputStream;Ljava/lang/String;[Ljava/io/InputStream;)Lcom/tiamosu/fly/http/https/HttpsUtils$SSLParams;", "trustManager", "(Ljavax/net/ssl/X509TrustManager;Ljava/io/InputStream;Ljava/lang/String;[Ljava/io/InputStream;)Lcom/tiamosu/fly/http/https/HttpsUtils$SSLParams;", "([Ljava/io/InputStream;)Lcom/tiamosu/fly/http/https/HttpsUtils$SSLParams;", "prepareKeyManager", "Ljavax/net/ssl/KeyManager;", "(Ljava/io/InputStream;Ljava/lang/String;)[Ljavax/net/ssl/KeyManager;", "prepareTrustManager", "([Ljava/io/InputStream;)[Ljavax/net/ssl/TrustManager;", "DefaultHostnameVerifier", "MyTrustManager", "SSLParams", "UnSafeTrustManager", "fly-http_release"})
public final class HttpsUtils {
    @NotNull
    public static final HttpsUtils INSTANCE = new HttpsUtils();

    private HttpsUtils() {
    }

    @JvmStatic
    @NotNull
    public static final SSLParams getSslSocketFactory() {
        return HttpsUtils.getSslSocketFactory(null, null, null, null);
    }

    @JvmStatic
    @NotNull
    public static final SSLParams getSslSocketFactory(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        return HttpsUtils.getSslSocketFactory(trustManager, null, null, null);
    }

    @JvmStatic
    @NotNull
    public static final SSLParams getSslSocketFactory(@NotNull InputStream[] certificates) {
        Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
        return HttpsUtils.getSslSocketFactory(null, null, null, certificates);
    }

    @JvmStatic
    @NotNull
    public static final SSLParams getSslSocketFactory(@NotNull InputStream bksFile, @NotNull String password, @NotNull InputStream[] certificates) {
        Intrinsics.checkNotNullParameter((Object)bksFile, (String)"bksFile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
        return HttpsUtils.getSslSocketFactory(null, bksFile, password, certificates);
    }

    @JvmStatic
    @NotNull
    public static final SSLParams getSslSocketFactory(@NotNull X509TrustManager trustManager, @NotNull InputStream bksFile, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        Intrinsics.checkNotNullParameter((Object)bksFile, (String)"bksFile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return HttpsUtils.getSslSocketFactory(trustManager, bksFile, password);
    }

    @JvmStatic
    @NotNull
    public static final SSLParams getSslSocketFactory(@Nullable X509TrustManager trustManager, @Nullable InputStream bksFile, @Nullable String password, @Nullable InputStream[] certificates) {
        SSLParams sslParams = new SSLParams();
        TrustManager[] trustManagers = INSTANCE.prepareTrustManager(certificates);
        KeyManager[] keyManagers = INSTANCE.prepareKeyManager(bksFile, password);
        try {
            X509TrustManager x509TrustManager = trustManager;
            if (x509TrustManager == null) {
                x509TrustManager = trustManagers != null ? (X509TrustManager)new MyTrustManager(INSTANCE.chooseTrustManager(trustManagers)) : (X509TrustManager)new UnSafeTrustManager();
            }
            X509TrustManager manager = x509TrustManager;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{manager};
            sslContext.init(keyManagers, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
            sslParams.setSslSocketFactory(sSLSocketFactory);
            sslParams.setTrustManager(manager);
            return sslParams;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static /* synthetic */ SSLParams getSslSocketFactory$default(X509TrustManager x509TrustManager, InputStream inputStream, String string, InputStream[] inputStreamArray, int n, Object object) {
        if ((n & 1) != 0) {
            x509TrustManager = null;
        }
        if ((n & 2) != 0) {
            inputStream = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            inputStreamArray = null;
        }
        return HttpsUtils.getSslSocketFactory(x509TrustManager, inputStream, string, inputStreamArray);
    }

    private final TrustManager[] prepareTrustManager(InputStream[] certificates) {
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])certificates)) {
                int index = indexedValue.component1();
                InputStream certStream = (InputStream)indexedValue.component2();
                String certificateAlias = String.valueOf(index);
                Certificate cert = certificateFactory.generateCertificate(certStream);
                keyStore.setCertificateEntry(certificateAlias, cert);
                Closeable[] closeableArray = new Closeable[]{certStream};
                CloseUtils.closeIO((Closeable[])closeableArray);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private final KeyManager[] prepareKeyManager(InputStream bksFile, String password) {
        if (bksFile == null || password == null) {
            return null;
        }
        try {
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            clientKeyStore.load(bksFile, cArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] cArray2 = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            keyManagerFactory.init(clientKeyStore, cArray2);
            Closeable[] closeableArray = new Closeable[]{bksFile};
            CloseUtils.closeIO((Closeable[])closeableArray);
            return keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private final X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/tiamosu/fly/http/https/HttpsUtils$SSLParams;", "", "()V", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSslSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "setSslSocketFactory", "(Ljavax/net/ssl/SSLSocketFactory;)V", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "getTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "setTrustManager", "(Ljavax/net/ssl/X509TrustManager;)V", "fly-http_release"})
    public static final class SSLParams {
        public SSLSocketFactory sslSocketFactory;
        public X509TrustManager trustManager;

        @NotNull
        public final SSLSocketFactory getSslSocketFactory() {
            SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
            if (sSLSocketFactory != null) {
                return sSLSocketFactory;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sslSocketFactory");
            return null;
        }

        public final void setSslSocketFactory(@NotNull SSLSocketFactory sSLSocketFactory) {
            Intrinsics.checkNotNullParameter((Object)sSLSocketFactory, (String)"<set-?>");
            this.sslSocketFactory = sSLSocketFactory;
        }

        @NotNull
        public final X509TrustManager getTrustManager() {
            X509TrustManager x509TrustManager = this.trustManager;
            if (x509TrustManager != null) {
                return x509TrustManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustManager");
            return null;
        }

        public final void setTrustManager(@NotNull X509TrustManager x509TrustManager) {
            Intrinsics.checkNotNullParameter((Object)x509TrustManager, (String)"<set-?>");
            this.trustManager = x509TrustManager;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017\u00a2\u0006\u0002\u0010\nJ#\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/tiamosu/fly/http/https/HttpsUtils$UnSafeTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "()V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "fly-http_release"})
    private static final class UnSafeTrustManager
    implements X509TrustManager {
        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\fJ#\u0010\r\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/tiamosu/fly/http/https/HttpsUtils$MyTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "localTrustManager", "(Ljavax/net/ssl/X509TrustManager;)V", "defaultTrustManager", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "fly-http_release"})
    private static final class MyTrustManager
    implements X509TrustManager {
        @Nullable
        private final X509TrustManager localTrustManager;
        @Nullable
        private final X509TrustManager defaultTrustManager;

        public MyTrustManager(@Nullable X509TrustManager localTrustManager) throws NoSuchAlgorithmException, KeyStoreException {
            this.localTrustManager = localTrustManager;
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            TrustManager[] trustManagerArray = factory.getTrustManagers();
            Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"factory.trustManagers");
            this.defaultTrustManager = INSTANCE.chooseTrustManager(trustManagerArray);
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
            block2: {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                try {
                    X509TrustManager x509TrustManager = this.defaultTrustManager;
                    if (x509TrustManager == null) break block2;
                    x509TrustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException ce) {
                    X509TrustManager x509TrustManager = this.localTrustManager;
                    if (x509TrustManager == null) break block2;
                    x509TrustManager.checkServerTrusted(chain, authType);
                }
            }
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/tiamosu/fly/http/https/HttpsUtils$DefaultHostnameVerifier;", "Ljavax/net/ssl/HostnameVerifier;", "()V", "verifyHostNameArray", "", "", "[Ljava/lang/String;", "verify", "", "hostname", "session", "Ljavax/net/ssl/SSLSession;", "fly-http_release"})
    public static final class DefaultHostnameVerifier
    implements HostnameVerifier {
        @NotNull
        private final String[] verifyHostNameArray = new String[0];

        @Override
        public boolean verify(@NotNull String hostname, @NotNull SSLSession session) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            return TextUtils.isEmpty((CharSequence)hostname) ? false : !CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray = this.verifyHostNameArray, stringArray.length)).contains(hostname);
        }
    }
}

