/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.interceptors;

import android.text.TextUtils;
import com.tiamosu.fly.http.utils.FlyHttpLog;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0012"}, d2={"Lcom/tiamosu/fly/http/interceptors/CacheInterceptor;", "Lokhttp3/Interceptor;", "cacheControlValue", "", "(Ljava/lang/String;)V", "cacheControlValueOffline", "cacheControlValueOnline", "(Ljava/lang/String;Ljava/lang/String;)V", "getCacheControlValueOffline", "()Ljava/lang/String;", "setCacheControlValueOffline", "getCacheControlValueOnline", "setCacheControlValueOnline", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "fly-http_release"})
public class CacheInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String cacheControlValueOffline;
    @Nullable
    private String cacheControlValueOnline;
    protected static final int maxStale = 259200;
    protected static final int maxStaleOnline = 60;

    public CacheInterceptor(@Nullable String cacheControlValueOffline, @Nullable String cacheControlValueOnline) {
        this.cacheControlValueOffline = cacheControlValueOffline;
        this.cacheControlValueOnline = cacheControlValueOnline;
    }

    @Nullable
    protected final String getCacheControlValueOffline() {
        return this.cacheControlValueOffline;
    }

    protected final void setCacheControlValueOffline(@Nullable String string) {
        this.cacheControlValueOffline = string;
    }

    @Nullable
    protected final String getCacheControlValueOnline() {
        return this.cacheControlValueOnline;
    }

    protected final void setCacheControlValueOnline(@Nullable String string) {
        this.cacheControlValueOnline = string;
    }

    @JvmOverloads
    public CacheInterceptor(@Nullable String cacheControlValue) {
        String string = "max-age=%d";
        Object[] objectArray = new Object[]{259200};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        this(cacheControlValue, string2);
    }

    public /* synthetic */ CacheInterceptor(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = "max-age=%d";
            Object[] objectArray = new Object[]{60};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            string = string3;
        }
        this(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Response originalResponse = chain.proceed(chain.request());
        String cacheControl = Response.header$default((Response)originalResponse, (String)"Cache-Control", null, (int)2, null);
        FlyHttpLog.INSTANCE.eLog("60s load cache:" + cacheControl);
        if (!TextUtils.isEmpty((CharSequence)cacheControl)) {
            String string = cacheControl;
            Intrinsics.checkNotNull((Object)string);
            if (!(StringsKt.contains$default((CharSequence)string, (CharSequence)"no-store", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)cacheControl, (CharSequence)"no-cache", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)cacheControl, (CharSequence)"must-revalidate", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)cacheControl, (CharSequence)"max-age", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)cacheControl, (CharSequence)"max-stale", (boolean)false, (int)2, null))) {
                response = originalResponse;
                return response;
            }
        }
        response = originalResponse.newBuilder().removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", "public, max-age=259200").build();
        return response;
    }

    @JvmOverloads
    public CacheInterceptor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tiamosu/fly/http/interceptors/CacheInterceptor$Companion;", "", "()V", "maxStale", "", "maxStaleOnline", "fly-http_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

