/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.model;

import android.annotation.SuppressLint;
import android.os.Build;
import android.text.TextUtils;
import com.blankj.utilcode.util.DeviceUtils;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.Utils;
import com.tiamosu.fly.http.utils.FlyHttpUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000J\u001a\u0010\u0012\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005J \u0010\u0012\u001a\u00020\r2\u0018\u0010\u0013\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0005J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/tiamosu/fly/http/model/HttpHeaders;", "Ljava/io/Serializable;", "()V", "headersMap", "Ljava/util/LinkedHashMap;", "", "getHeadersMap", "()Ljava/util/LinkedHashMap;", "names", "", "getNames", "()Ljava/util/Set;", "clear", "", "get", "key", "isEmpty", "", "put", "headers", "value", "", "remove", "toJSONString", "toString", "Companion", "fly-http_release"})
public final class HttpHeaders
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, String> headersMap = new LinkedHashMap();
    @NotNull
    public static final String FORMAT_HTTP_DATA = "EEE, dd MMM y HH:mm:ss 'GMT'";
    @NotNull
    private static final TimeZone GMT_TIME_ZONE;
    @NotNull
    public static final String HEAD_KEY_RESPONSE_CODE = "ResponseCode";
    @NotNull
    public static final String HEAD_KEY_RESPONSE_MESSAGE = "ResponseMessage";
    @NotNull
    public static final String HEAD_KEY_ACCEPT = "Accept";
    @NotNull
    public static final String HEAD_KEY_ACCEPT_ENCODING = "Accept-Encoding";
    @NotNull
    public static final String HEAD_VALUE_ACCEPT_ENCODING = "gzip, deflate";
    @NotNull
    public static final String HEAD_KEY_ACCEPT_LANGUAGE = "Accept-Language";
    @NotNull
    public static final String HEAD_KEY_CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String HEAD_KEY_CONTENT_LENGTH = "Content-Length";
    @NotNull
    public static final String HEAD_KEY_CONTENT_ENCODING = "Content-Encoding";
    @NotNull
    public static final String HEAD_KEY_CONTENT_DISPOSITION = "Content-Disposition";
    @NotNull
    public static final String HEAD_KEY_CONTENT_RANGE = "Content-Range";
    @NotNull
    public static final String HEAD_KEY_RANGE = "Range";
    @NotNull
    public static final String HEAD_KEY_CACHE_CONTROL = "Cache-Control";
    @NotNull
    public static final String HEAD_KEY_CONNECTION = "Connection";
    @NotNull
    public static final String HEAD_VALUE_CONNECTION_KEEP_ALIVE = "keep-alive";
    @NotNull
    public static final String HEAD_VALUE_CONNECTION_CLOSE = "close";
    @NotNull
    public static final String HEAD_KEY_DATE = "Date";
    @NotNull
    public static final String HEAD_KEY_EXPIRES = "Expires";
    @NotNull
    public static final String HEAD_KEY_E_TAG = "ETag";
    @NotNull
    public static final String HEAD_KEY_PRAGMA = "Pragma";
    @NotNull
    public static final String HEAD_KEY_IF_MODIFIED_SINCE = "If-Modified-Since";
    @NotNull
    public static final String HEAD_KEY_IF_NONE_MATCH = "If-None-Match";
    @NotNull
    public static final String HEAD_KEY_LAST_MODIFIED = "Last-Modified";
    @NotNull
    public static final String HEAD_KEY_LOCATION = "Location";
    @NotNull
    public static final String HEAD_KEY_USER_AGENT = "User-Agent";
    @NotNull
    public static final String HEAD_KEY_COOKIE = "Cookie";
    @NotNull
    public static final String HEAD_KEY_COOKIE2 = "Cookie2";
    @NotNull
    public static final String HEAD_KEY_SET_COOKIE = "Set-Cookie";
    @NotNull
    public static final String HEAD_KEY_SET_COOKIE2 = "Set-Cookie2";
    @Nullable
    private static String acceptLanguage;
    @Nullable
    private static String userAgent;

    @NotNull
    public final LinkedHashMap<String, String> getHeadersMap() {
        return this.headersMap;
    }

    public final void put(@Nullable String key, @Nullable String value) {
        if (key != null && value != null) {
            ((Map)this.headersMap).put(key, value);
        }
    }

    public final void put(@Nullable Map<String, String> headers) {
        Map<String, String> map = headers;
        boolean bl = map != null ? !map.isEmpty() : false;
        if (bl) {
            this.headersMap.putAll(FlyHttpUtils.escapeParams(headers));
        }
    }

    public final void put(@Nullable HttpHeaders headers) {
        Serializable serializable = headers;
        boolean bl = serializable != null && (serializable = serializable.headersMap) != null ? !((Map)((Object)serializable)).isEmpty() : false;
        if (bl) {
            Set<Map.Entry<String, String>> set = headers.headersMap.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"headers.headersMap.entries");
            Set<Map.Entry<String, String>> set2 = set;
            for (Map.Entry<String, String> entry : set2) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.headersMap.remove(key);
                ((Map)this.headersMap).put(key, value);
            }
        }
    }

    public final boolean isEmpty() {
        return this.headersMap.isEmpty();
    }

    @Nullable
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.headersMap.get(key);
    }

    @Nullable
    public final String remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (String)this.headersMap.remove(key);
    }

    public final void clear() {
        this.headersMap.clear();
    }

    @NotNull
    public final Set<String> getNames() {
        Set<String> set = this.headersMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"headersMap.keys");
        return set;
    }

    @NotNull
    public final String toJSONString() {
        JSONObject jsonObject = new JSONObject();
        try {
            for (Map.Entry entry : ((Map)this.headersMap).entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                jsonObject.put(key, (Object)value);
            }
        }
        catch (JSONException e) {
            Object[] objectArray = new Object[]{e};
            LogUtils.e((Object[])objectArray);
        }
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return "HttpHeaders{headersMap=" + this.headersMap + "}";
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(\"GMT\")");
        GMT_TIME_ZONE = timeZone;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\t\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u000200J\u0018\u00101\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u00103\u001a\u00020\u0004J\u000e\u00104\u001a\u00020\u00042\u0006\u0010/\u001a\u000200J\u0010\u00104\u001a\u0002002\b\u00105\u001a\u0004\u0018\u00010\u0004J\u0010\u00106\u001a\u0002002\b\u00107\u001a\u0004\u0018\u00010\u0004J\u0010\u00108\u001a\u0002002\b\u00109\u001a\u0004\u0018\u00010\u0004J\u0010\u0010:\u001a\u0002002\b\u00105\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0004\u0018\u00010\u00048FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010+\u001a\u0004\u0018\u00010\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*\u00a8\u0006;"}, d2={"Lcom/tiamosu/fly/http/model/HttpHeaders$Companion;", "", "()V", "FORMAT_HTTP_DATA", "", "GMT_TIME_ZONE", "Ljava/util/TimeZone;", "getGMT_TIME_ZONE", "()Ljava/util/TimeZone;", "HEAD_KEY_ACCEPT", "HEAD_KEY_ACCEPT_ENCODING", "HEAD_KEY_ACCEPT_LANGUAGE", "HEAD_KEY_CACHE_CONTROL", "HEAD_KEY_CONNECTION", "HEAD_KEY_CONTENT_DISPOSITION", "HEAD_KEY_CONTENT_ENCODING", "HEAD_KEY_CONTENT_LENGTH", "HEAD_KEY_CONTENT_RANGE", "HEAD_KEY_CONTENT_TYPE", "HEAD_KEY_COOKIE", "HEAD_KEY_COOKIE2", "HEAD_KEY_DATE", "HEAD_KEY_EXPIRES", "HEAD_KEY_E_TAG", "HEAD_KEY_IF_MODIFIED_SINCE", "HEAD_KEY_IF_NONE_MATCH", "HEAD_KEY_LAST_MODIFIED", "HEAD_KEY_LOCATION", "HEAD_KEY_PRAGMA", "HEAD_KEY_RANGE", "HEAD_KEY_RESPONSE_CODE", "HEAD_KEY_RESPONSE_MESSAGE", "HEAD_KEY_SET_COOKIE", "HEAD_KEY_SET_COOKIE2", "HEAD_KEY_USER_AGENT", "HEAD_VALUE_ACCEPT_ENCODING", "HEAD_VALUE_CONNECTION_CLOSE", "HEAD_VALUE_CONNECTION_KEEP_ALIVE", "acceptLanguage", "getAcceptLanguage", "()Ljava/lang/String;", "setAcceptLanguage", "(Ljava/lang/String;)V", "userAgent", "getUserAgent", "setUserAgent", "formatMillisToGMT", "milliseconds", "", "getCacheControl", "cacheControl", "pragma", "getDate", "gmtTime", "getExpiration", "expiresTime", "getLastModified", "lastModified", "parseGMTToMillis", "fly-http_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeZone getGMT_TIME_ZONE() {
            return GMT_TIME_ZONE;
        }

        @Nullable
        public final String getAcceptLanguage() {
            if (TextUtils.isEmpty((CharSequence)acceptLanguage)) {
                Locale locale = Locale.getDefault();
                String language = locale.getLanguage();
                String country = locale.getCountry();
                StringBuilder acceptLanguageBuilder = new StringBuilder(language);
                if (!TextUtils.isEmpty((CharSequence)country)) {
                    acceptLanguageBuilder.append('-').append(country).append(',').append(language).append(";q=0.8");
                }
                acceptLanguage = acceptLanguageBuilder.toString();
                return acceptLanguage;
            }
            return acceptLanguage;
        }

        public final void setAcceptLanguage(@Nullable String string) {
            acceptLanguage = string;
        }

        @SuppressLint(value={"PrivateApi"})
        @Nullable
        public final String getUserAgent() {
            if (TextUtils.isEmpty((CharSequence)userAgent)) {
                String webUserAgent = null;
                try {
                    Class<?> sysResCls = Class.forName("com.android.internal.R$string");
                    Field webUserAgentField = sysResCls.getDeclaredField("web_user_agent");
                    Object object = webUserAgentField.get(null);
                    Integer resId = object instanceof Integer ? (Integer)object : null;
                    webUserAgent = resId != null ? Utils.getApp().getString(resId.intValue()) : "";
                }
                catch (Exception sysResCls) {
                    // empty catch block
                }
                if (TextUtils.isEmpty((CharSequence)webUserAgent)) {
                    webUserAgent = "Mozilla/5.0 (Linux; U; Android %s) AppleWebKit/533.1 (KHTML, like Gecko) Version/5.0 %sSafari/533.1";
                }
                Locale locale = Locale.getDefault();
                StringBuffer buffer = new StringBuffer();
                String version = Build.VERSION.RELEASE;
                Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
                if (((CharSequence)version).length() > 0) {
                    buffer.append(version);
                } else {
                    buffer.append("1.0");
                }
                buffer.append("; ");
                String language = locale.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"language");
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
                String string = language.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
                buffer.append(string);
                String country = locale.getCountry();
                if (!TextUtils.isEmpty((CharSequence)country)) {
                    buffer.append("-");
                    Intrinsics.checkNotNullExpressionValue((Object)country, (String)"country");
                    String string2 = country.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                    buffer.append(string2);
                }
                if (Intrinsics.areEqual((Object)"REL", (Object)Build.VERSION.CODENAME)) {
                    String model = URLEncoder.encode(DeviceUtils.getModel(), "UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
                    if (((CharSequence)model).length() > 0) {
                        buffer.append("; ");
                        buffer.append(model);
                    }
                }
                String id = Build.ID;
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                if (((CharSequence)id).length() > 0) {
                    buffer.append(" Build/");
                    buffer.append(id);
                }
                String string3 = webUserAgent;
                Intrinsics.checkNotNull((Object)string3);
                String string4 = string3;
                Object[] objectArray = new Object[]{buffer, "Mobile "};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                userAgent = string5;
                return userAgent;
            }
            return userAgent;
        }

        public final void setUserAgent(@Nullable String string) {
            userAgent = string;
        }

        public final long getDate(@Nullable String gmtTime) {
            long l;
            try {
                l = this.parseGMTToMillis(gmtTime);
            }
            catch (ParseException e) {
                l = 0L;
            }
            return l;
        }

        @NotNull
        public final String getDate(long milliseconds) {
            return this.formatMillisToGMT(milliseconds);
        }

        public final long getExpiration(@Nullable String expiresTime) {
            long l;
            try {
                l = this.parseGMTToMillis(expiresTime);
            }
            catch (ParseException e) {
                l = -1L;
            }
            return l;
        }

        public final long getLastModified(@Nullable String lastModified) {
            long l;
            try {
                l = this.parseGMTToMillis(lastModified);
            }
            catch (ParseException e) {
                l = 0L;
            }
            return l;
        }

        @NotNull
        public final String getCacheControl(@Nullable String cacheControl, @NotNull String pragma) {
            Intrinsics.checkNotNullParameter((Object)pragma, (String)"pragma");
            String string = cacheControl;
            if (string == null) {
                string = pragma;
            }
            return string;
        }

        public final long parseGMTToMillis(@Nullable String gmtTime) throws ParseException {
            Date date;
            if (TextUtils.isEmpty((CharSequence)gmtTime)) {
                return 0L;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(HttpHeaders.FORMAT_HTTP_DATA, Locale.US);
            formatter.setTimeZone(this.getGMT_TIME_ZONE());
            String string = gmtTime;
            Intrinsics.checkNotNull((Object)string);
            Date date2 = date = formatter.parse(string);
            return date2 != null ? date2.getTime() : 0L;
        }

        @NotNull
        public final String formatMillisToGMT(long milliseconds) {
            Date date = new Date(milliseconds);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HttpHeaders.FORMAT_HTTP_DATA, Locale.US);
            simpleDateFormat.setTimeZone(this.getGMT_TIME_ZONE());
            String string = simpleDateFormat.format(date);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"simpleDateFormat.format(date)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

