/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.request.base;

import com.tiamosu.fly.http.callback.Callback;
import com.tiamosu.fly.http.model.Progress;
import com.tiamosu.fly.http.utils.FlyHttpLog;
import com.tiamosu.fly.utils.Platform;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tiamosu/fly/http/request/base/ProgressRequestBody;", "Lokhttp3/RequestBody;", "requestBody", "callback", "Lcom/tiamosu/fly/http/callback/Callback;", "(Lokhttp3/RequestBody;Lcom/tiamosu/fly/http/callback/Callback;)V", "progressCallBack", "Lcom/tiamosu/fly/http/request/base/ProgressRequestBody$ProgressResponseCallBack;", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "setProgressCallback", "", "writeTo", "sink", "Lokio/BufferedSink;", "CountingSink", "ProgressResponseCallBack", "fly-http_release"})
public final class ProgressRequestBody
extends RequestBody {
    @NotNull
    private final RequestBody requestBody;
    @Nullable
    private final Callback<?> callback;
    @Nullable
    private ProgressResponseCallBack progressCallBack;

    public ProgressRequestBody(@NotNull RequestBody requestBody, @Nullable Callback<?> callback2) {
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        this.requestBody = requestBody;
        this.callback = callback2;
    }

    public final void setProgressCallback(@Nullable ProgressResponseCallBack progressCallBack) {
        this.progressCallBack = progressCallBack;
    }

    @Nullable
    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() {
        long l;
        try {
            l = this.requestBody.contentLength();
        }
        catch (IOException e) {
            FlyHttpLog.INSTANCE.eLog(e.getMessage());
            l = -1L;
        }
        return l;
    }

    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        CountingSink countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)((Sink)countingSink));
        this.requestBody.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/tiamosu/fly/http/request/base/ProgressRequestBody$CountingSink;", "Lokio/ForwardingSink;", "sink", "Lokio/Sink;", "(Lcom/tiamosu/fly/http/request/base/ProgressRequestBody;Lokio/Sink;)V", "progress", "Lcom/tiamosu/fly/http/model/Progress;", "write", "", "source", "Lokio/Buffer;", "byteCount", "", "fly-http_release"})
    private final class CountingSink
    extends ForwardingSink {
        @NotNull
        private Progress progress;

        public CountingSink(Sink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            super(sink);
            this.progress = new Progress();
            this.progress.setTotalSize(ProgressRequestBody.this.contentLength());
        }

        public void write(@NotNull Buffer source, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super.write(source, byteCount);
            Progress.Companion.changeProgress(this.progress, byteCount, arg_0 -> CountingSink.write$lambda-1(ProgressRequestBody.this, arg_0));
        }

        private static final void write$lambda-1$lambda-0(ProgressRequestBody this$0, Progress $progress) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$progress, (String)"$progress");
                ProgressResponseCallBack progressResponseCallBack = this$0.progressCallBack;
                if (progressResponseCallBack != null) {
                    progressResponseCallBack.onResponseProgress($progress);
                }
                Callback callback2 = this$0.callback;
                if (callback2 == null) break block1;
                callback2.uploadProgress($progress);
            }
        }

        private static final void write$lambda-1(ProgressRequestBody this$0, Progress progress) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            Platform.launchMain(() -> CountingSink.write$lambda-1$lambda-0(this$0, progress));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/tiamosu/fly/http/request/base/ProgressRequestBody$ProgressResponseCallBack;", "", "onResponseProgress", "", "progress", "Lcom/tiamosu/fly/http/model/Progress;", "fly-http_release"})
    public static interface ProgressResponseCallBack {
        public void onResponseProgress(@NotNull Progress var1);
    }
}

