/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFCharsetHelper;
import com.linuxense.javadbf.DBFDataType;
import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFStandardCharsets;
import com.linuxense.javadbf.DBFUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class DBFHeader {
    public static final byte SIG_DBASE_III = 3;
    private byte signature = (byte)3;
    private byte year;
    private byte month;
    private byte day;
    int numberOfRecords;
    short headerLength;
    short recordLength;
    private short reserv1;
    private byte incompleteTransaction;
    private byte encryptionFlag;
    private int freeRecordThread;
    private int reserv2;
    private int reserv3;
    private byte mdxFlag;
    private byte languageDriver;
    private short reserv4;
    DBFField[] fieldArray;
    DBFField[] userFieldArray;
    private byte terminator1 = (byte)13;
    private Charset detectedCharset;
    private Charset usedCharset;
    private boolean supportExtendedCharacterFields = true;
    private static final int DBASE_LEVEL_7 = 4;

    protected DBFHeader() {
    }

    void read(DataInput dataInput, Charset charset, boolean showDeletedRows) throws IOException {
        this.signature = dataInput.readByte();
        this.year = dataInput.readByte();
        this.month = dataInput.readByte();
        this.day = dataInput.readByte();
        this.numberOfRecords = DBFUtils.readLittleEndianInt(dataInput);
        this.headerLength = DBFUtils.readLittleEndianShort(dataInput);
        this.recordLength = DBFUtils.readLittleEndianShort(dataInput);
        this.reserv1 = DBFUtils.readLittleEndianShort(dataInput);
        this.incompleteTransaction = dataInput.readByte();
        this.encryptionFlag = dataInput.readByte();
        this.freeRecordThread = DBFUtils.readLittleEndianInt(dataInput);
        this.reserv2 = dataInput.readInt();
        this.reserv3 = dataInput.readInt();
        this.mdxFlag = dataInput.readByte();
        this.languageDriver = dataInput.readByte();
        this.reserv4 = DBFUtils.readLittleEndianShort(dataInput);
        this.detectedCharset = DBFCharsetHelper.getCharsetByByte(this.languageDriver);
        int read = 32;
        if (this.isDB7()) {
            byte[] languageName = new byte[32];
            dataInput.readFully(languageName);
            dataInput.readInt();
            read += 36;
        }
        ArrayList<DBFField> v_fields = new ArrayList<DBFField>();
        this.usedCharset = this.detectedCharset;
        if (charset != null) {
            this.usedCharset = charset;
        }
        if (this.usedCharset == null) {
            this.usedCharset = DBFStandardCharsets.ISO_8859_1;
        }
        if (this.isDB7()) {
            while (read <= this.headerLength - 48) {
                DBFField field = DBFField.createFieldDB7(dataInput, this.usedCharset, this.supportExtendedCharacterFields);
                if (field != null) {
                    v_fields.add(field);
                    read += 48;
                    continue;
                }
                ++read;
                break;
            }
        } else {
            boolean useFieldFlags = this.supportsFieldFlags();
            while (read <= this.headerLength - 32) {
                DBFField field = DBFField.createField(dataInput, this.usedCharset, useFieldFlags, this.supportExtendedCharacterFields);
                if (field != null) {
                    v_fields.add(field);
                    read += 32;
                    continue;
                }
                ++read;
                break;
            }
        }
        int skip = this.headerLength - read;
        DBFUtils.skipDataInput(dataInput, skip);
        this.fieldArray = v_fields.toArray(new DBFField[v_fields.size()]);
        ArrayList<DBFField> userFields = new ArrayList<DBFField>();
        if (showDeletedRows) {
            DBFField deletedField = new DBFField("deleted", DBFDataType.LOGICAL);
            userFields.add(deletedField);
        }
        for (DBFField field1 : this.fieldArray) {
            if (field1.isSystem() || field1.getType() == DBFDataType.NULL_FLAGS) continue;
            userFields.add(field1);
        }
        this.userFieldArray = userFields.toArray(new DBFField[userFields.size()]);
    }

    private boolean supportsFieldFlags() {
        return this.signature == 2 || this.signature == 48 || this.signature == 49 || this.signature == -11 || this.signature == -5;
    }

    int getTableHeaderSize() {
        if (this.isDB7()) {
            return 68;
        }
        return 32;
    }

    int getFieldDescriptorSize() {
        if (this.isDB7()) {
            return 48;
        }
        return 32;
    }

    private boolean isDB7() {
        return (this.signature & 7) == 4;
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.signature);
        Calendar calendar = Calendar.getInstance();
        this.year = (byte)(calendar.get(1) - 1900);
        this.month = (byte)(calendar.get(2) + 1);
        this.day = (byte)calendar.get(5);
        dataOutput.writeByte(this.year);
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
        this.numberOfRecords = DBFUtils.littleEndian(this.numberOfRecords);
        dataOutput.writeInt(this.numberOfRecords);
        short oldHeaderLength = this.headerLength;
        short newHeaderLength = this.findHeaderLength();
        if (oldHeaderLength == 0) {
            this.headerLength = newHeaderLength;
        } else if (newHeaderLength > oldHeaderLength) {
            throw new DBFException("Invalid header length");
        }
        dataOutput.writeShort(DBFUtils.littleEndian(this.headerLength));
        this.recordLength = this.sumUpLenghtOfFields();
        dataOutput.writeShort(DBFUtils.littleEndian(this.recordLength));
        dataOutput.writeShort(DBFUtils.littleEndian(this.reserv1));
        dataOutput.writeByte(this.incompleteTransaction);
        dataOutput.writeByte(this.encryptionFlag);
        dataOutput.writeInt(DBFUtils.littleEndian(this.freeRecordThread));
        dataOutput.writeInt(DBFUtils.littleEndian(this.reserv2));
        dataOutput.writeInt(DBFUtils.littleEndian(this.reserv3));
        dataOutput.writeByte(this.mdxFlag);
        if (this.languageDriver != 0) {
            dataOutput.writeByte(this.languageDriver);
        } else if (this.getUsedCharset() != null) {
            dataOutput.writeByte(DBFCharsetHelper.getDBFCodeForCharset(this.getUsedCharset()));
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(DBFUtils.littleEndian(this.reserv4));
        for (DBFField field : this.fieldArray) {
            field.write(dataOutput, this.getUsedCharset());
        }
        dataOutput.writeByte(this.terminator1);
    }

    private short findHeaderLength() {
        return (short)(32 + 32 * this.fieldArray.length + 1);
    }

    private short sumUpLenghtOfFields() {
        int sum = 0;
        for (DBFField field : this.fieldArray) {
            sum += field.getLength();
        }
        return (short)(sum + 1);
    }

    public int getYear() {
        return 1900 + this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Date getLastModificationDate() {
        if (this.year == 0 || this.month == 0 || this.day == 0) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.year, this.month, this.day, 0, 0, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Charset getDetectedCharset() {
        return this.detectedCharset;
    }

    protected Charset getUsedCharset() {
        return this.usedCharset;
    }

    protected void setUsedCharset(Charset charset) {
        this.usedCharset = charset;
    }

    public void setSupportExtendedCharacterFields(boolean supportExtendedCharacterFields) {
        this.supportExtendedCharacterFields = supportExtendedCharacterFields;
    }
}

