/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.BundleTCPMessageReader;
import com.almasb.fxgl.net.BundleUDPMessageReader;
import com.almasb.fxgl.net.ByteArrayTCPMessageReader;
import com.almasb.fxgl.net.StringTCPMessageReader;
import com.almasb.fxgl.net.TCPMessageReader;
import com.almasb.fxgl.net.TCPReaderFactory;
import com.almasb.fxgl.net.UDPMessageReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\bJ(\u0010\u0011\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000bJ(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0014\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00072\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0005\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006j\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\n\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0006j\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/net/Readers;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "tcpReaders", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lcom/almasb/fxgl/net/TCPReaderFactory;", "Lkotlin/collections/HashMap;", "udpReaders", "Lcom/almasb/fxgl/net/UDPMessageReader;", "addTCPReader", "", "T", "type", "factory", "addUDPReader", "reader", "getTCPReader", "Lcom/almasb/fxgl/net/TCPMessageReader;", "inputStream", "Ljava/io/InputStream;", "getUDPReader", "fxgl-io"})
public final class Readers {
    @NotNull
    public static final Readers INSTANCE = new Readers();
    @NotNull
    private static final Logger log = Logger.Companion.get(INSTANCE.getClass());
    @NotNull
    private static final HashMap<Class<?>, TCPReaderFactory<?>> tcpReaders;
    @NotNull
    private static final HashMap<Class<?>, UDPMessageReader<?>> udpReaders;

    private Readers() {
    }

    public final <T> void addTCPReader(@NotNull Class<T> type, @NotNull TCPReaderFactory<T> factory) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Map map = tcpReaders;
        boolean bl = false;
        map.put(type, factory);
    }

    public final <T> void addUDPReader(@NotNull Class<T> type, @NotNull UDPMessageReader<T> reader) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        Map map = udpReaders;
        boolean bl = false;
        map.put(type, reader);
    }

    @NotNull
    public final <T> TCPMessageReader<T> getTCPReader(@NotNull Class<T> type, @NotNull InputStream inputStream) {
        TCPReaderFactory<?> tCPReaderFactory;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        log.debug("Getting TCPMessageReader for " + type);
        TCPReaderFactory<?> tCPReaderFactory2 = tcpReaders.get(type);
        if (tCPReaderFactory2 == null) {
            throw new RuntimeException("No reader factory for type: " + type);
        }
        TCPReaderFactory<?> readerFactory = tCPReaderFactory = tCPReaderFactory2;
        TCPMessageReader<?> reader = readerFactory.create(inputStream);
        log.debug("Constructed MessageReader for " + type + ": " + reader.getClass().getSimpleName());
        return reader;
    }

    @NotNull
    public final <T> UDPMessageReader<T> getUDPReader(@NotNull Class<T> type) {
        UDPMessageReader<?> uDPMessageReader;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        log.debug("Getting UDPMessageReader for " + type);
        UDPMessageReader<?> uDPMessageReader2 = udpReaders.get(type);
        UDPMessageReader<?> uDPMessageReader3 = uDPMessageReader = uDPMessageReader2 instanceof UDPMessageReader ? uDPMessageReader2 : null;
        if (uDPMessageReader == null) {
            throw new RuntimeException("No UDP message reader for type: " + type);
        }
        UDPMessageReader<?> reader = uDPMessageReader;
        log.debug("Constructed UDPMessageReader for " + type + ": " + reader.getClass().getSimpleName());
        return reader;
    }

    static {
        boolean bl = false;
        tcpReaders = new HashMap();
        bl = false;
        udpReaders = new HashMap();
        INSTANCE.addTCPReader(Bundle.class, new TCPReaderFactory<Bundle>(){

            @Override
            @NotNull
            public TCPMessageReader<Bundle> create(@NotNull InputStream input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return new BundleTCPMessageReader(input);
            }
        });
        INSTANCE.addTCPReader(byte[].class, new TCPReaderFactory<byte[]>(){

            @Override
            @NotNull
            public TCPMessageReader<byte[]> create(@NotNull InputStream input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return new ByteArrayTCPMessageReader(input);
            }
        });
        INSTANCE.addTCPReader(String.class, new TCPReaderFactory<String>(){

            @Override
            @NotNull
            public TCPMessageReader<String> create(@NotNull InputStream input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return new StringTCPMessageReader(input);
            }
        });
        INSTANCE.addUDPReader(Bundle.class, new BundleUDPMessageReader());
    }
}

