/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs;

import com.github.apiggs.Apiggs;
import com.github.apiggs.Environment;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="apiggs")
public class ApiggsMojo
extends AbstractMojo {
    MavenProject project;
    @Parameter
    String id;
    @Parameter
    String title;
    @Parameter
    String description;
    @Parameter
    String out;
    @Parameter
    String production;
    String source;
    @Parameter
    String dependency;
    @Parameter
    String jar;
    @Parameter
    String ignore;
    @Parameter
    String version;
    @Parameter
    String css;

    public void execute() {
        if (this.getPluginContext().containsKey("project") && this.getPluginContext().get("project") instanceof MavenProject) {
            this.project = (MavenProject)this.getPluginContext().get("project");
            this.build();
        }
    }

    private void build() {
        Path path;
        int n;
        Environment env = new Environment();
        if (this.source != null) {
            String[] stringArray = this.source.split(",");
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String dir = stringArray[n];
                path = this.resolve(dir);
                env.source(new Path[]{path});
            }
        } else {
            env.source(new Path[]{Paths.get(this.project.getBuild().getSourceDirectory(), new String[0])});
            if (this.project.getCollectedProjects() != null) {
                for (MavenProject sub : this.project.getCollectedProjects()) {
                    env.source(new Path[]{Paths.get(sub.getBuild().getSourceDirectory(), new String[0])});
                }
            }
        }
        if (this.dependency != null) {
            String[] dirs = this.dependency.split(",");
            String[] sub = dirs;
            n = sub.length;
            for (int dir = 0; dir < n; ++dir) {
                String dir2 = sub[dir];
                Path path2 = this.resolve(dir2);
                env.dependency(new Path[]{path2});
            }
        } else if (this.project.getParent() != null && this.project.getParent().getCollectedProjects() != null) {
            for (MavenProject p : this.project.getParent().getCollectedProjects()) {
                String path3 = p.getBuild().getSourceDirectory();
                env.dependency(new Path[]{Paths.get(path3, new String[0])});
            }
        }
        if (this.jar != null) {
            for (String dir : this.jar.split(",")) {
                path = this.resolve(dir);
                env.jar(new Path[]{path});
            }
        }
        if (this.id != null) {
            env.id(this.id);
        } else {
            env.id(this.project.getName());
        }
        if (this.production != null) {
            env.production(Paths.get(this.production, new String[0]));
        }
        if (this.out != null) {
            Path path4 = this.resolve(this.out);
            env.out(path4);
        } else {
            env.out(Paths.get(this.project.getBuild().getDirectory(), new String[0]));
        }
        if (this.title != null) {
            env.title(this.title);
        } else {
            env.title(this.project.getName());
        }
        if (this.description != null) {
            env.description(this.description);
        } else if (this.project.getDescription() != null) {
            env.description(this.project.getDescription());
        }
        if (this.version != null) {
            env.version(this.version);
        } else if (this.project.getVersion() != null) {
            env.version(this.project.getVersion());
        }
        if (this.ignore != null) {
            env.ignore(this.ignore.split(","));
        }
        if (this.css != null) {
            env.css(this.css);
        }
        new Apiggs(env).lookup().build();
    }

    private Path resolve(String dir) {
        Path path = Paths.get(dir, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        return this.project.getBasedir().toPath().resolve(path);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOut() {
        return this.out;
    }

    public void setOut(String out) {
        this.out = out;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDependency() {
        return this.dependency;
    }

    public void setDependency(String dependency) {
        this.dependency = dependency;
    }

    public String getJar() {
        return this.jar;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public String getIgnore() {
        return this.ignore;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
    }

    public void setProduction(String production) {
        this.production = production;
    }

    public String getProduction() {
        return this.production;
    }
}

