/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp;

import com.bastiaanjansen.otp.HMACAlgorithm;
import com.bastiaanjansen.otp.helpers.URIHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

class OTP {
    private static final String URL_SCHEME = "otpauth";
    private static final int DEFAULT_PASSWORD_LENGTH = 6;
    private static final HMACAlgorithm DEFAULT_HMAC_ALGORITHM = HMACAlgorithm.SHA1;
    protected final int passwordLength;
    protected final HMACAlgorithm algorithm;
    protected final byte[] secret;

    protected OTP(Builder<?, ?> builder) {
        if (!this.validatePasswordLength(((Builder)builder).passwordLength)) {
            throw new IllegalArgumentException("Password length must be between 6 and 8 digits");
        }
        if (((Builder)builder).secret.length <= 0) {
            throw new IllegalArgumentException("Secret must not be empty");
        }
        this.passwordLength = ((Builder)builder).passwordLength;
        this.algorithm = ((Builder)builder).algorithm;
        this.secret = ((Builder)builder).secret;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public HMACAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public boolean verify(String code, long counter) {
        return this.verify(code, counter, 0);
    }

    public boolean verify(String code, long counter, int delayWindow) {
        if (code.length() != this.passwordLength) {
            return false;
        }
        for (int i = -delayWindow; i <= delayWindow; ++i) {
            String currentCode = this.generate(counter + (long)i);
            if (!code.equals(currentCode)) continue;
            return true;
        }
        return false;
    }

    protected String generate(long counter) throws IllegalStateException {
        byte[] hash;
        if (counter < 0L) {
            throw new IllegalArgumentException("Counter must be greater than or equal to 0");
        }
        byte[] secretBytes = this.decodeBase32(this.secret);
        byte[] counterBytes = this.longToBytes(counter);
        try {
            hash = this.generateHash(secretBytes, counterBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException();
        }
        return this.getCodeFromHash(hash);
    }

    protected URI getURI(String type, String issuer, String account, Map<String, String> query) throws URISyntaxException {
        query.put("digits", String.valueOf(this.passwordLength));
        query.put("algorithm", this.algorithm.name());
        query.put("secret", new String(this.secret, StandardCharsets.UTF_8));
        String path = account.isEmpty() ? issuer : String.format("%s:%s", issuer, account);
        return URIHelper.createURI(URL_SCHEME, type, path, query);
    }

    private byte[] decodeBase32(byte[] value) {
        Base32 codec = new Base32();
        return codec.decode(value);
    }

    private byte[] longToBytes(long value) {
        return ByteBuffer.allocate(8).putLong(value).array();
    }

    private byte[] generateHash(byte[] secret, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signKey = new SecretKeySpec(secret, "RAW");
        Mac mac = Mac.getInstance(this.algorithm.getHMACName());
        mac.init(signKey);
        return mac.doFinal(data);
    }

    private String getCodeFromHash(byte[] hash) {
        int mask = 15;
        byte lastByte = hash[hash.length - 1];
        int offset = lastByte & mask;
        byte[] truncatedHashInBytes = new byte[]{hash[offset], hash[offset + 1], hash[offset + 2], hash[offset + 3]};
        ByteBuffer byteBuffer = ByteBuffer.wrap(truncatedHashInBytes);
        long truncatedHash = byteBuffer.getInt();
        truncatedHash &= Integer.MAX_VALUE;
        truncatedHash = (long)((double)truncatedHash % Math.pow(10.0, this.passwordLength));
        return String.format("%0" + this.passwordLength + "d", truncatedHash);
    }

    private boolean validatePasswordLength(int passwordLength) {
        return passwordLength >= 6 && passwordLength <= 8;
    }

    protected static abstract class Builder<T extends OTP, B extends Builder<T, B>> {
        private int passwordLength;
        private HMACAlgorithm algorithm;
        private final byte[] secret;

        public Builder(byte[] secret) {
            this.secret = secret;
            this.passwordLength = 6;
            this.algorithm = DEFAULT_HMAC_ALGORITHM;
        }

        public B withPasswordLength(int passwordLength) {
            this.passwordLength = passwordLength;
            return this.getBuilder();
        }

        public B withAlgorithm(HMACAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this.getBuilder();
        }

        protected abstract B getBuilder();

        public abstract T build();
    }
}

