/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp;

import com.bastiaanjansen.otp.HMACAlgorithm;
import com.bastiaanjansen.otp.OTP;
import com.bastiaanjansen.otp.TOTPGenerator;
import com.bastiaanjansen.otp.TOTPVerifier;
import com.bastiaanjansen.otp.helpers.URIHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class TOTP
extends OTP
implements TOTPGenerator,
TOTPVerifier {
    private static final String OTP_TYPE = "totp";
    private static final Duration DEFAULT_PERIOD = Duration.ofSeconds(30L);
    private final Duration period;

    private TOTP(Builder builder) {
        super(builder);
        this.period = builder.period;
    }

    public static TOTP fromURI(URI uri) throws URISyntaxException {
        Map<String, String> query = URIHelper.queryItems(uri);
        byte[] secret = Optional.ofNullable(query.get("secret")).map(String::getBytes).orElseThrow(() -> new IllegalArgumentException("Secret query parameter must be set"));
        Builder builder = new Builder(secret);
        try {
            Optional.ofNullable(query.get("period")).map(Long::parseLong).map(Duration::ofSeconds).ifPresent(builder::withPeriod);
            Optional.ofNullable(query.get("digits")).map(Integer::valueOf).ifPresent(builder::withPasswordLength);
            Optional.ofNullable(query.get("algorithm")).map(String::toUpperCase).map(HMACAlgorithm::valueOf).ifPresent(builder::withAlgorithm);
        }
        catch (Exception e) {
            throw new URISyntaxException(uri.toString(), "URI could not be parsed");
        }
        return builder.build();
    }

    public static TOTP withDefaultValues(byte[] secret) {
        return new Builder(secret).build();
    }

    @Override
    public String now() throws IllegalStateException {
        long counter = this.calculateCounter(this.period);
        return super.generate(counter);
    }

    @Override
    public String at(Instant instant) throws IllegalStateException {
        return this.at(instant.getEpochSecond());
    }

    @Override
    public String at(Date date) throws IllegalStateException {
        long secondsSince1970 = TimeUnit.MILLISECONDS.toSeconds(date.getTime());
        return this.at(secondsSince1970);
    }

    @Override
    public String at(long secondsPast1970) throws IllegalArgumentException {
        if (!this.validateTime(secondsPast1970)) {
            throw new IllegalArgumentException("Time must be above zero");
        }
        long counter = this.calculateCounter(secondsPast1970, this.period);
        return super.generate(counter);
    }

    @Override
    public boolean verify(String code) {
        long counter = this.calculateCounter(this.period);
        return super.verify(code, counter);
    }

    @Override
    public boolean verify(String code, int delayWindow) {
        long counter = this.calculateCounter(this.period);
        return super.verify(code, counter, delayWindow);
    }

    public Duration getPeriod() {
        return this.period;
    }

    @Override
    public URI getURI(String issuer) throws URISyntaxException {
        return this.getURI(issuer, "");
    }

    @Override
    public URI getURI(String issuer, String account) throws URISyntaxException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("period", String.valueOf(this.period.getSeconds()));
        return this.getURI(OTP_TYPE, issuer, account, query);
    }

    private long calculateCounter(long secondsPast1970, Duration period) {
        return TimeUnit.SECONDS.toMillis(secondsPast1970) / period.toMillis();
    }

    private long calculateCounter(Duration period) {
        return System.currentTimeMillis() / period.toMillis();
    }

    private boolean validateTime(long time) {
        return time > 0L;
    }

    static /* synthetic */ Duration access$100() {
        return DEFAULT_PERIOD;
    }

    public static class Builder
    extends OTP.Builder<TOTP, Builder> {
        private Duration period = TOTP.access$100();

        public Builder(byte[] secret) {
            super(secret);
        }

        public Builder withPeriod(Duration period) {
            if (period.getSeconds() < 1L) {
                throw new IllegalArgumentException("Period must be at least 1 second");
            }
            this.period = period;
            return this;
        }

        @Override
        public TOTP build() {
            return new TOTP(this);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }
    }
}

