/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundCouponInfo;
import com.github.binarywang.wxpay.bean.result.WxPayRefundPromotionDetail;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

@XStreamAlias(value="xml")
public class WxPayRefundQueryResult
extends BaseWxPayResult
implements Serializable {
    private static final long serialVersionUID = 5392369423225328754L;
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @XStreamAlias(value="settlement_total_fee")
    private Integer settlementTotalFee;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @XStreamAlias(value="cash_fee")
    private Integer cashFee;
    @XStreamAlias(value="refund_count")
    private Integer refundCount;
    private List<RefundRecord> refundRecords;
    @XStreamAlias(value="promotion_detail")
    private String promotionDetailString;
    private List<WxPayRefundPromotionDetail> promotionDetails;

    public void composePromotionDetails() {
        if (StringUtils.isEmpty((CharSequence)this.promotionDetailString)) {
            return;
        }
        JsonObject tmpJson = GsonParser.parse((String)this.promotionDetailString);
        List promotionDetail = (List)WxGsonBuilder.create().fromJson(tmpJson.get("promotion_detail"), new TypeToken<List<WxPayRefundPromotionDetail>>(){}.getType());
        this.setPromotionDetails(promotionDetail);
    }

    public void composeRefundRecords() {
        if (this.refundCount != null && this.refundCount > 0) {
            this.refundRecords = Lists.newArrayList();
            for (int i = 0; i < this.refundCount; ++i) {
                RefundRecord refundRecord = new RefundRecord();
                this.refundRecords.add(refundRecord);
                refundRecord.setOutRefundNo(this.getXmlValue("xml/out_refund_no_" + i));
                refundRecord.setRefundId(this.getXmlValue("xml/refund_id_" + i));
                refundRecord.setRefundChannel(this.getXmlValue("xml/refund_channel_" + i));
                refundRecord.setRefundFee(this.getXmlValueAsInt("xml/refund_fee_" + i));
                refundRecord.setSettlementRefundFee(this.getXmlValueAsInt("xml/settlement_refund_fee_" + i));
                refundRecord.setCouponRefundFee(this.getXmlValueAsInt("xml/coupon_refund_fee_" + i));
                refundRecord.setCouponRefundCount(this.getXmlValueAsInt("xml/coupon_refund_count_" + i));
                refundRecord.setRefundStatus(this.getXmlValue("xml/refund_status_" + i));
                refundRecord.setRefundRecvAccount(this.getXmlValue("xml/refund_recv_accout_" + i));
                refundRecord.setRefundSuccessTime(this.getXmlValue("xml/refund_success_time_" + i));
                if (refundRecord.getCouponRefundCount() == null || refundRecord.getCouponRefundCount() == 0) continue;
                ArrayList coupons = Lists.newArrayList();
                for (int j = 0; j < refundRecord.getCouponRefundCount(); ++j) {
                    coupons.add(new WxPayRefundCouponInfo(this.getXmlValue("xml/coupon_refund_id_" + i + "_" + j), this.getXmlValueAsInt("xml/coupon_refund_fee_" + i + "_" + j), this.getXmlValue("xml/coupon_type_" + i + "_" + j)));
                }
                refundRecord.setRefundCoupons(coupons);
            }
        }
    }

    @Override
    protected void loadXml(Document d) {
        this.deviceInfo = WxPayRefundQueryResult.readXmlString(d, "device_info");
        this.transactionId = WxPayRefundQueryResult.readXmlString(d, "transaction_id");
        this.outTradeNo = WxPayRefundQueryResult.readXmlString(d, "out_trade_no");
        this.totalFee = WxPayRefundQueryResult.readXmlInteger(d, "total_fee");
        this.settlementTotalFee = WxPayRefundQueryResult.readXmlInteger(d, "settlement_total_fee");
        this.feeType = WxPayRefundQueryResult.readXmlString(d, "fee_type");
        this.cashFee = WxPayRefundQueryResult.readXmlInteger(d, "cash_fee");
        this.refundCount = WxPayRefundQueryResult.readXmlInteger(d, "refund_count");
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public Integer getSettlementTotalFee() {
        return this.settlementTotalFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public Integer getCashFee() {
        return this.cashFee;
    }

    public Integer getRefundCount() {
        return this.refundCount;
    }

    public List<RefundRecord> getRefundRecords() {
        return this.refundRecords;
    }

    public String getPromotionDetailString() {
        return this.promotionDetailString;
    }

    public List<WxPayRefundPromotionDetail> getPromotionDetails() {
        return this.promotionDetails;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public void setSettlementTotalFee(Integer settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public void setCashFee(Integer cashFee) {
        this.cashFee = cashFee;
    }

    public void setRefundCount(Integer refundCount) {
        this.refundCount = refundCount;
    }

    public void setRefundRecords(List<RefundRecord> refundRecords) {
        this.refundRecords = refundRecords;
    }

    public void setPromotionDetailString(String promotionDetailString) {
        this.promotionDetailString = promotionDetailString;
    }

    public void setPromotionDetails(List<WxPayRefundPromotionDetail> promotionDetails) {
        this.promotionDetails = promotionDetails;
    }

    @Override
    public String toString() {
        return "WxPayRefundQueryResult(deviceInfo=" + this.getDeviceInfo() + ", transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", totalFee=" + this.getTotalFee() + ", settlementTotalFee=" + this.getSettlementTotalFee() + ", feeType=" + this.getFeeType() + ", cashFee=" + this.getCashFee() + ", refundCount=" + this.getRefundCount() + ", refundRecords=" + this.getRefundRecords() + ", promotionDetailString=" + this.getPromotionDetailString() + ", promotionDetails=" + this.getPromotionDetails() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayRefundQueryResult)) {
            return false;
        }
        WxPayRefundQueryResult other = (WxPayRefundQueryResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        Integer this$settlementTotalFee = this.getSettlementTotalFee();
        Integer other$settlementTotalFee = other.getSettlementTotalFee();
        if (this$settlementTotalFee == null ? other$settlementTotalFee != null : !((Object)this$settlementTotalFee).equals(other$settlementTotalFee)) {
            return false;
        }
        Integer this$cashFee = this.getCashFee();
        Integer other$cashFee = other.getCashFee();
        if (this$cashFee == null ? other$cashFee != null : !((Object)this$cashFee).equals(other$cashFee)) {
            return false;
        }
        Integer this$refundCount = this.getRefundCount();
        Integer other$refundCount = other.getRefundCount();
        if (this$refundCount == null ? other$refundCount != null : !((Object)this$refundCount).equals(other$refundCount)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$feeType = this.getFeeType();
        String other$feeType = other.getFeeType();
        if (this$feeType == null ? other$feeType != null : !this$feeType.equals(other$feeType)) {
            return false;
        }
        List<RefundRecord> this$refundRecords = this.getRefundRecords();
        List<RefundRecord> other$refundRecords = other.getRefundRecords();
        if (this$refundRecords == null ? other$refundRecords != null : !((Object)this$refundRecords).equals(other$refundRecords)) {
            return false;
        }
        String this$promotionDetailString = this.getPromotionDetailString();
        String other$promotionDetailString = other.getPromotionDetailString();
        if (this$promotionDetailString == null ? other$promotionDetailString != null : !this$promotionDetailString.equals(other$promotionDetailString)) {
            return false;
        }
        List<WxPayRefundPromotionDetail> this$promotionDetails = this.getPromotionDetails();
        List<WxPayRefundPromotionDetail> other$promotionDetails = other.getPromotionDetails();
        return !(this$promotionDetails == null ? other$promotionDetails != null : !((Object)this$promotionDetails).equals(other$promotionDetails));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayRefundQueryResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        Integer $settlementTotalFee = this.getSettlementTotalFee();
        result = result * 59 + ($settlementTotalFee == null ? 43 : ((Object)$settlementTotalFee).hashCode());
        Integer $cashFee = this.getCashFee();
        result = result * 59 + ($cashFee == null ? 43 : ((Object)$cashFee).hashCode());
        Integer $refundCount = this.getRefundCount();
        result = result * 59 + ($refundCount == null ? 43 : ((Object)$refundCount).hashCode());
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $feeType = this.getFeeType();
        result = result * 59 + ($feeType == null ? 43 : $feeType.hashCode());
        List<RefundRecord> $refundRecords = this.getRefundRecords();
        result = result * 59 + ($refundRecords == null ? 43 : ((Object)$refundRecords).hashCode());
        String $promotionDetailString = this.getPromotionDetailString();
        result = result * 59 + ($promotionDetailString == null ? 43 : $promotionDetailString.hashCode());
        List<WxPayRefundPromotionDetail> $promotionDetails = this.getPromotionDetails();
        result = result * 59 + ($promotionDetails == null ? 43 : ((Object)$promotionDetails).hashCode());
        return result;
    }

    public static class RefundRecord {
        @XStreamAlias(value="out_refund_no")
        private String outRefundNo;
        @XStreamAlias(value="refund_id")
        private String refundId;
        @XStreamAlias(value="refund_channel")
        private String refundChannel;
        @XStreamAlias(value="refund_fee")
        private Integer refundFee;
        @XStreamAlias(value="settlement_refund_fee")
        private Integer settlementRefundFee;
        @XStreamAlias(value="refund_account")
        private String refundAccount;
        @XStreamAlias(value="coupon_refund_fee")
        private Integer couponRefundFee;
        @XStreamAlias(value="coupon_refund_count")
        private Integer couponRefundCount;
        private List<WxPayRefundCouponInfo> refundCoupons;
        @XStreamAlias(value="refund_status")
        private String refundStatus;
        @XStreamAlias(value="refund_recv_accout")
        private String refundRecvAccount;
        @XStreamAlias(value="refund_success_time")
        private String refundSuccessTime;

        public static RefundRecordBuilder newBuilder() {
            return new RefundRecordBuilder();
        }

        public String getOutRefundNo() {
            return this.outRefundNo;
        }

        public String getRefundId() {
            return this.refundId;
        }

        public String getRefundChannel() {
            return this.refundChannel;
        }

        public Integer getRefundFee() {
            return this.refundFee;
        }

        public Integer getSettlementRefundFee() {
            return this.settlementRefundFee;
        }

        public String getRefundAccount() {
            return this.refundAccount;
        }

        public Integer getCouponRefundFee() {
            return this.couponRefundFee;
        }

        public Integer getCouponRefundCount() {
            return this.couponRefundCount;
        }

        public List<WxPayRefundCouponInfo> getRefundCoupons() {
            return this.refundCoupons;
        }

        public String getRefundStatus() {
            return this.refundStatus;
        }

        public String getRefundRecvAccount() {
            return this.refundRecvAccount;
        }

        public String getRefundSuccessTime() {
            return this.refundSuccessTime;
        }

        public void setOutRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
        }

        public void setRefundId(String refundId) {
            this.refundId = refundId;
        }

        public void setRefundChannel(String refundChannel) {
            this.refundChannel = refundChannel;
        }

        public void setRefundFee(Integer refundFee) {
            this.refundFee = refundFee;
        }

        public void setSettlementRefundFee(Integer settlementRefundFee) {
            this.settlementRefundFee = settlementRefundFee;
        }

        public void setRefundAccount(String refundAccount) {
            this.refundAccount = refundAccount;
        }

        public void setCouponRefundFee(Integer couponRefundFee) {
            this.couponRefundFee = couponRefundFee;
        }

        public void setCouponRefundCount(Integer couponRefundCount) {
            this.couponRefundCount = couponRefundCount;
        }

        public void setRefundCoupons(List<WxPayRefundCouponInfo> refundCoupons) {
            this.refundCoupons = refundCoupons;
        }

        public void setRefundStatus(String refundStatus) {
            this.refundStatus = refundStatus;
        }

        public void setRefundRecvAccount(String refundRecvAccount) {
            this.refundRecvAccount = refundRecvAccount;
        }

        public void setRefundSuccessTime(String refundSuccessTime) {
            this.refundSuccessTime = refundSuccessTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefundRecord)) {
                return false;
            }
            RefundRecord other = (RefundRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$refundFee = this.getRefundFee();
            Integer other$refundFee = other.getRefundFee();
            if (this$refundFee == null ? other$refundFee != null : !((Object)this$refundFee).equals(other$refundFee)) {
                return false;
            }
            Integer this$settlementRefundFee = this.getSettlementRefundFee();
            Integer other$settlementRefundFee = other.getSettlementRefundFee();
            if (this$settlementRefundFee == null ? other$settlementRefundFee != null : !((Object)this$settlementRefundFee).equals(other$settlementRefundFee)) {
                return false;
            }
            Integer this$couponRefundFee = this.getCouponRefundFee();
            Integer other$couponRefundFee = other.getCouponRefundFee();
            if (this$couponRefundFee == null ? other$couponRefundFee != null : !((Object)this$couponRefundFee).equals(other$couponRefundFee)) {
                return false;
            }
            Integer this$couponRefundCount = this.getCouponRefundCount();
            Integer other$couponRefundCount = other.getCouponRefundCount();
            if (this$couponRefundCount == null ? other$couponRefundCount != null : !((Object)this$couponRefundCount).equals(other$couponRefundCount)) {
                return false;
            }
            String this$outRefundNo = this.getOutRefundNo();
            String other$outRefundNo = other.getOutRefundNo();
            if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
                return false;
            }
            String this$refundId = this.getRefundId();
            String other$refundId = other.getRefundId();
            if (this$refundId == null ? other$refundId != null : !this$refundId.equals(other$refundId)) {
                return false;
            }
            String this$refundChannel = this.getRefundChannel();
            String other$refundChannel = other.getRefundChannel();
            if (this$refundChannel == null ? other$refundChannel != null : !this$refundChannel.equals(other$refundChannel)) {
                return false;
            }
            String this$refundAccount = this.getRefundAccount();
            String other$refundAccount = other.getRefundAccount();
            if (this$refundAccount == null ? other$refundAccount != null : !this$refundAccount.equals(other$refundAccount)) {
                return false;
            }
            List<WxPayRefundCouponInfo> this$refundCoupons = this.getRefundCoupons();
            List<WxPayRefundCouponInfo> other$refundCoupons = other.getRefundCoupons();
            if (this$refundCoupons == null ? other$refundCoupons != null : !((Object)this$refundCoupons).equals(other$refundCoupons)) {
                return false;
            }
            String this$refundStatus = this.getRefundStatus();
            String other$refundStatus = other.getRefundStatus();
            if (this$refundStatus == null ? other$refundStatus != null : !this$refundStatus.equals(other$refundStatus)) {
                return false;
            }
            String this$refundRecvAccount = this.getRefundRecvAccount();
            String other$refundRecvAccount = other.getRefundRecvAccount();
            if (this$refundRecvAccount == null ? other$refundRecvAccount != null : !this$refundRecvAccount.equals(other$refundRecvAccount)) {
                return false;
            }
            String this$refundSuccessTime = this.getRefundSuccessTime();
            String other$refundSuccessTime = other.getRefundSuccessTime();
            return !(this$refundSuccessTime == null ? other$refundSuccessTime != null : !this$refundSuccessTime.equals(other$refundSuccessTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefundRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $refundFee = this.getRefundFee();
            result = result * 59 + ($refundFee == null ? 43 : ((Object)$refundFee).hashCode());
            Integer $settlementRefundFee = this.getSettlementRefundFee();
            result = result * 59 + ($settlementRefundFee == null ? 43 : ((Object)$settlementRefundFee).hashCode());
            Integer $couponRefundFee = this.getCouponRefundFee();
            result = result * 59 + ($couponRefundFee == null ? 43 : ((Object)$couponRefundFee).hashCode());
            Integer $couponRefundCount = this.getCouponRefundCount();
            result = result * 59 + ($couponRefundCount == null ? 43 : ((Object)$couponRefundCount).hashCode());
            String $outRefundNo = this.getOutRefundNo();
            result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
            String $refundId = this.getRefundId();
            result = result * 59 + ($refundId == null ? 43 : $refundId.hashCode());
            String $refundChannel = this.getRefundChannel();
            result = result * 59 + ($refundChannel == null ? 43 : $refundChannel.hashCode());
            String $refundAccount = this.getRefundAccount();
            result = result * 59 + ($refundAccount == null ? 43 : $refundAccount.hashCode());
            List<WxPayRefundCouponInfo> $refundCoupons = this.getRefundCoupons();
            result = result * 59 + ($refundCoupons == null ? 43 : ((Object)$refundCoupons).hashCode());
            String $refundStatus = this.getRefundStatus();
            result = result * 59 + ($refundStatus == null ? 43 : $refundStatus.hashCode());
            String $refundRecvAccount = this.getRefundRecvAccount();
            result = result * 59 + ($refundRecvAccount == null ? 43 : $refundRecvAccount.hashCode());
            String $refundSuccessTime = this.getRefundSuccessTime();
            result = result * 59 + ($refundSuccessTime == null ? 43 : $refundSuccessTime.hashCode());
            return result;
        }

        public String toString() {
            return "WxPayRefundQueryResult.RefundRecord(outRefundNo=" + this.getOutRefundNo() + ", refundId=" + this.getRefundId() + ", refundChannel=" + this.getRefundChannel() + ", refundFee=" + this.getRefundFee() + ", settlementRefundFee=" + this.getSettlementRefundFee() + ", refundAccount=" + this.getRefundAccount() + ", couponRefundFee=" + this.getCouponRefundFee() + ", couponRefundCount=" + this.getCouponRefundCount() + ", refundCoupons=" + this.getRefundCoupons() + ", refundStatus=" + this.getRefundStatus() + ", refundRecvAccount=" + this.getRefundRecvAccount() + ", refundSuccessTime=" + this.getRefundSuccessTime() + ")";
        }

        public RefundRecord() {
        }

        public RefundRecord(String outRefundNo, String refundId, String refundChannel, Integer refundFee, Integer settlementRefundFee, String refundAccount, Integer couponRefundFee, Integer couponRefundCount, List<WxPayRefundCouponInfo> refundCoupons, String refundStatus, String refundRecvAccount, String refundSuccessTime) {
            this.outRefundNo = outRefundNo;
            this.refundId = refundId;
            this.refundChannel = refundChannel;
            this.refundFee = refundFee;
            this.settlementRefundFee = settlementRefundFee;
            this.refundAccount = refundAccount;
            this.couponRefundFee = couponRefundFee;
            this.couponRefundCount = couponRefundCount;
            this.refundCoupons = refundCoupons;
            this.refundStatus = refundStatus;
            this.refundRecvAccount = refundRecvAccount;
            this.refundSuccessTime = refundSuccessTime;
        }

        public static class RefundRecordBuilder {
            private String outRefundNo;
            private String refundId;
            private String refundChannel;
            private Integer refundFee;
            private Integer settlementRefundFee;
            private String refundAccount;
            private Integer couponRefundFee;
            private Integer couponRefundCount;
            private List<WxPayRefundCouponInfo> refundCoupons;
            private String refundStatus;
            private String refundRecvAccount;
            private String refundSuccessTime;

            RefundRecordBuilder() {
            }

            public RefundRecordBuilder outRefundNo(String outRefundNo) {
                this.outRefundNo = outRefundNo;
                return this;
            }

            public RefundRecordBuilder refundId(String refundId) {
                this.refundId = refundId;
                return this;
            }

            public RefundRecordBuilder refundChannel(String refundChannel) {
                this.refundChannel = refundChannel;
                return this;
            }

            public RefundRecordBuilder refundFee(Integer refundFee) {
                this.refundFee = refundFee;
                return this;
            }

            public RefundRecordBuilder settlementRefundFee(Integer settlementRefundFee) {
                this.settlementRefundFee = settlementRefundFee;
                return this;
            }

            public RefundRecordBuilder refundAccount(String refundAccount) {
                this.refundAccount = refundAccount;
                return this;
            }

            public RefundRecordBuilder couponRefundFee(Integer couponRefundFee) {
                this.couponRefundFee = couponRefundFee;
                return this;
            }

            public RefundRecordBuilder couponRefundCount(Integer couponRefundCount) {
                this.couponRefundCount = couponRefundCount;
                return this;
            }

            public RefundRecordBuilder refundCoupons(List<WxPayRefundCouponInfo> refundCoupons) {
                this.refundCoupons = refundCoupons;
                return this;
            }

            public RefundRecordBuilder refundStatus(String refundStatus) {
                this.refundStatus = refundStatus;
                return this;
            }

            public RefundRecordBuilder refundRecvAccount(String refundRecvAccount) {
                this.refundRecvAccount = refundRecvAccount;
                return this;
            }

            public RefundRecordBuilder refundSuccessTime(String refundSuccessTime) {
                this.refundSuccessTime = refundSuccessTime;
                return this;
            }

            public RefundRecord build() {
                return new RefundRecord(this.outRefundNo, this.refundId, this.refundChannel, this.refundFee, this.settlementRefundFee, this.refundAccount, this.couponRefundFee, this.couponRefundCount, this.refundCoupons, this.refundStatus, this.refundRecvAccount, this.refundSuccessTime);
            }

            public String toString() {
                return "WxPayRefundQueryResult.RefundRecord.RefundRecordBuilder(outRefundNo=" + this.outRefundNo + ", refundId=" + this.refundId + ", refundChannel=" + this.refundChannel + ", refundFee=" + this.refundFee + ", settlementRefundFee=" + this.settlementRefundFee + ", refundAccount=" + this.refundAccount + ", couponRefundFee=" + this.couponRefundFee + ", couponRefundCount=" + this.couponRefundCount + ", refundCoupons=" + this.refundCoupons + ", refundStatus=" + this.refundStatus + ", refundRecvAccount=" + this.refundRecvAccount + ", refundSuccessTime=" + this.refundSuccessTime + ")";
            }
        }
    }
}

