/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.BytesSize;
import org.n3r.diamond.client.DiamondException;
import org.n3r.diamond.client.Duration;
import org.n3r.diamond.client.Minerable;
import org.n3r.diamond.client.impl.DiamondUtils;
import org.n3r.diamond.client.impl.PropertiesBasedMiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMiner
implements Minerable {
    Logger log = LoggerFactory.getLogger(AbstractMiner.class);

    public abstract String getDefaultGroupName();

    @Override
    public <T> T getObject(String key, Class<T> clazz) {
        return DiamondUtils.parseObject(this.getString(key), clazz);
    }

    @Override
    public <T> T getStoneObject(String group, String dataId, Class<T> clazz) {
        return DiamondUtils.parseObject(this.getStone(group, dataId), clazz);
    }

    @Override
    public <T> T getObject(String key, String defaultValue, Class<T> clazz) {
        return DiamondUtils.parseObject(this.getString(key, defaultValue), clazz);
    }

    @Override
    public <T> T getStoneObject(String group, String dataId, String defaultValue, Class<T> clazz) {
        return DiamondUtils.parseObject(this.getStone(group, dataId, defaultValue), clazz);
    }

    @Override
    public <T> List<T> getObjects(String key, Class<T> clazz) {
        return DiamondUtils.parseObjects(this.getString(key), clazz);
    }

    @Override
    public <T> List<T> getStoneObjects(String group, String dataId, Class<T> clazz) {
        return DiamondUtils.parseObjects(this.getStone(group, dataId), clazz);
    }

    @Override
    public <T> List<T> getObjects(String key, String defaultValue, Class<T> clazz) {
        return DiamondUtils.parseObjects(this.getString(key, defaultValue), clazz);
    }

    @Override
    public <T> List<T> getStoneObjects(String group, String dataId, String defaultValue, Class<T> clazz) {
        return DiamondUtils.parseObjects(this.getStone(group, dataId, defaultValue), clazz);
    }

    @Override
    public long getBytes(String key) {
        return this.getBytes(this.getDefaultGroupName(), key);
    }

    @Override
    public long getBytes(String group, String dataId) {
        String stone = this.getStone(group, dataId);
        return BytesSize.parseBytes(stone);
    }

    @Override
    public long getBytes(String key, long defaultValue) {
        return this.getBytes(this.getDefaultGroupName(), key, defaultValue);
    }

    @Override
    public long getBytes(String group, String dataId, long defaultValue) {
        String stone = this.getStone(group, dataId);
        return StringUtils.isBlank((CharSequence)stone) ? defaultValue : BytesSize.parseBytes(stone);
    }

    @Override
    public long getDuration(String key, TimeUnit timeUnit) {
        return this.getDuration(this.getDefaultGroupName(), key, timeUnit);
    }

    @Override
    public long getDuration(String group, String dataId, TimeUnit timeUnit) {
        String stone = this.getStone(group, dataId);
        return Duration.getDuration(stone, timeUnit);
    }

    @Override
    public long getDuration(String key, TimeUnit timeUnit, long defaultValue) {
        return this.getDuration(this.getDefaultGroupName(), key, timeUnit, defaultValue);
    }

    @Override
    public long getDuration(String group, String dataId, TimeUnit timeUnit, long defaultValue) {
        String stone = this.getStone(group, dataId);
        return StringUtils.isBlank((CharSequence)stone) ? defaultValue : Duration.getDuration(stone, timeUnit);
    }

    @Override
    public JSONObject getJSON(String key) {
        return this.getJSON(this.getDefaultGroupName(), key);
    }

    @Override
    public <T> T getJSON(String key, Class<T> clazz) {
        return this.getJSON(this.getDefaultGroupName(), key, clazz);
    }

    @Override
    public JSONObject getJSON(String group, String dataId) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return null;
        }
        try {
            return JSON.parseObject((String)stone);
        }
        catch (Exception e) {
            this.log.error("parse stone to JSON failed " + stone, (Throwable)e);
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public <T> T getJSON(String group, String dataId, Class<T> clazz) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return null;
        }
        try {
            return (T)JSON.parseObject((String)stone, clazz);
        }
        catch (Exception e) {
            this.log.error("parse stone to JSON failed " + stone, (Throwable)e);
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public JSONArray getJSONArray(String key) {
        return this.getJSONArray(this.getDefaultGroupName(), key);
    }

    @Override
    public <T> List<T> getJSONArray(String key, Class<T> clazz) {
        return this.getJSONArray(this.getDefaultGroupName(), key, clazz);
    }

    @Override
    public JSONArray getJSONArray(String group, String dataId) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return null;
        }
        try {
            return JSON.parseArray((String)stone);
        }
        catch (Exception e) {
            this.log.error("parse stone to JSONArray failed " + stone, (Throwable)e);
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public <T> List<T> getJSONArray(String group, String dataId, Class<T> clazz) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return null;
        }
        try {
            return JSON.parseArray((String)stone, clazz);
        }
        catch (Exception e) {
            this.log.error("parse stone to JSONArray failed " + stone, (Throwable)e);
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public Properties getProperties(String key) {
        return this.getProperties(this.getDefaultGroupName(), key);
    }

    @Override
    public Properties getProperties(String group, String dataId) {
        String stone = this.getStone(group, dataId);
        return DiamondUtils.parseStoneToProperties(stone);
    }

    @Override
    public Minerable getMiner(String key) {
        return this.getMiner(this.getDefaultGroupName(), key);
    }

    @Override
    public Minerable getMiner(String group, String dataId) {
        return new PropertiesBasedMiner(this.getProperties(group, dataId));
    }

    @Override
    public String getString(String key) {
        return this.getStone(this.getDefaultGroupName(), key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.getStone(this.getDefaultGroupName(), key, defaultValue);
    }

    @Override
    public String getStone(String group, String dataId, String defaultValue) {
        return (String)Objects.firstNonNull((Object)this.getStone(group, dataId), (Object)defaultValue);
    }

    @Override
    public boolean exists(String group, String dataId) {
        String stone = this.getStone(group, dataId);
        return StringUtils.isNotBlank((CharSequence)stone);
    }

    @Override
    public boolean exists(String key) {
        return this.exists(this.getDefaultGroupName(), key);
    }

    @Override
    public int getInt(String key) {
        return this.getInt(this.getDefaultGroupName(), key);
    }

    @Override
    public int getInt(String group, String dataId) {
        String stone = this.getStoneAndCheckMissing(group, dataId);
        try {
            return Integer.parseInt(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.getInt(this.getDefaultGroupName(), key, defaultValue);
    }

    @Override
    public int getInt(String group, String dataId, int defaultValue) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public long getLong(String key) {
        return this.getLong(this.getDefaultGroupName(), key);
    }

    @Override
    public long getLong(String group, String dataId) {
        String stone = this.getStoneAndCheckMissing(group, dataId);
        try {
            return Long.parseLong(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.getLong(this.getDefaultGroupName(), key, defaultValue);
    }

    @Override
    public long getLong(String group, String dataId, long defaultValue) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public boolean getBool(String key) {
        return this.getBool(this.getDefaultGroupName(), key);
    }

    @Override
    public boolean getBool(String group, String dataId) {
        String stone = this.getStoneAndCheckMissing(group, dataId);
        return DiamondUtils.toBool(stone);
    }

    @Override
    public boolean getBool(String key, boolean defaultValue) {
        return this.getBool(this.getDefaultGroupName(), key, defaultValue);
    }

    @Override
    public boolean getBool(String group, String dataId, boolean defaultValue) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return defaultValue;
        }
        return DiamondUtils.toBool(stone);
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(this.getDefaultGroupName(), key);
    }

    @Override
    public float getFloat(String group, String dataId) {
        String stone = this.getStoneAndCheckMissing(group, dataId);
        try {
            return Float.parseFloat(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.getFloat(this.getDefaultGroupName(), key, defaultValue);
    }

    @Override
    public float getFloat(String group, String dataId, float defaultValue) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(this.getDefaultGroupName(), key);
    }

    @Override
    public double getDouble(String group, String dataId) {
        String stone = this.getStoneAndCheckMissing(group, dataId);
        try {
            return Double.parseDouble(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.getDouble(this.getDefaultGroupName(), key, defaultValue);
    }

    @Override
    public double getDouble(String group, String dataId, double defaultValue) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(stone);
        }
        catch (NumberFormatException e) {
            throw new DiamondException.WrongType(e);
        }
    }

    private String getStoneAndCheckMissing(String group, String dataId) {
        String stone = this.getStone(group, dataId);
        if (stone == null) {
            throw new DiamondException.Missing();
        }
        return stone;
    }
}

