/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client;

import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.DiamondListener;
import org.n3r.diamond.client.impl.DiamondSubscriber;
import org.n3r.diamond.client.impl.DiamondUtils;

public class DiamondManager {
    private DiamondSubscriber diamondSubscriber = DiamondSubscriber.getInstance();
    private final DiamondAxis diamondAxis;
    private int timeoutMillis = 3000;

    public DiamondManager(String dataId) {
        this("DEFAULT_GROUP", dataId);
    }

    public DiamondManager(String group, String dataId) {
        this.diamondAxis = DiamondAxis.makeAxis(group, dataId);
        this.diamondSubscriber.getCachedMeta(this.diamondAxis);
    }

    public void addDiamondListener(DiamondListener diamondListener) {
        this.diamondSubscriber.addDiamondListener(this.diamondAxis, diamondListener);
    }

    public void removeDiamondListener(DiamondListener diamondListener) {
        this.diamondSubscriber.removeDiamondListener(this.diamondAxis, diamondListener);
    }

    public String getDiamond() {
        String original = this.diamondSubscriber.getDiamond(this.diamondAxis, this.timeoutMillis);
        return DiamondUtils.tryDecrypt(original, this.diamondAxis.getDataId());
    }

    public Object getCache() {
        return this.diamondSubscriber.getCache(this.diamondAxis, this.timeoutMillis, new Object[0]);
    }

    public Object getDynamicCache(Object ... dynamics) {
        return this.diamondSubscriber.getCache(this.diamondAxis, this.timeoutMillis, dynamics);
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }
}

