/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.cache;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Futures;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.cache.DynamicsAppliable;
import org.n3r.diamond.client.impl.DiamondSubstituter;
import org.n3r.diamond.client.impl.DiamondUtils;
import org.n3r.diamond.client.impl.SnapshotMiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiamondCache {
    private final SnapshotMiner snapshotMiner;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Logger log = LoggerFactory.getLogger(DiamondCache.class);
    private Cache<DiamondAxis, Future<Object>> cache = CacheBuilder.newBuilder().build();

    public DiamondCache(SnapshotMiner snapshotMiner) {
        this.snapshotMiner = snapshotMiner;
    }

    public Object getCache(DiamondAxis diamondAxis, String diamondContent, Object ... dynamics) {
        Future subCachedObject;
        Future cachedObject;
        int dynamicsHasCode = Arrays.deepHashCode(dynamics);
        Callable<Future<Object>> callable = this.createFirstFutureCallable(diamondAxis, diamondContent, dynamics);
        try {
            cachedObject = (Future)this.cache.get((Object)diamondAxis, callable);
        }
        catch (ExecutionException e) {
            this.log.error("get cache {} failed with error {}", (Object)diamondContent, (Object)Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
        Object object = this.futureGet(diamondAxis, diamondContent, cachedObject, dynamicsHasCode);
        if (!(object instanceof Cache)) {
            return object;
        }
        Cache subCache = (Cache)object;
        Callable<Future<Object>> dynamicCallable = this.getSecondFutureCallable(diamondAxis, diamondContent, dynamics);
        try {
            subCachedObject = (Future)subCache.get((Object)dynamicsHasCode, dynamicCallable);
        }
        catch (ExecutionException e) {
            this.log.error("get dynamic cache {} failed with {}", (Object)diamondContent, (Object)Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
        return this.futureGet(diamondAxis, diamondContent, subCachedObject, dynamicsHasCode);
    }

    private Callable<Future<Object>> getSecondFutureCallable(final DiamondAxis diamondAxis, final String diamondContent, final Object[] dynamics) {
        return new Callable<Future<Object>>(){

            @Override
            public Future<Object> call() throws Exception {
                return DiamondCache.this.executorService.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Callable updater = DiamondCache.this.createUpdater(diamondAxis, diamondContent, dynamics);
                        if (updater == null) {
                            return null;
                        }
                        Optional objectOptional = DiamondCache.this.updateCache(updater, diamondAxis, diamondContent, dynamics);
                        return objectOptional != null ? objectOptional.orNull() : null;
                    }
                });
            }
        };
    }

    private Callable<Future<Object>> createFirstFutureCallable(final DiamondAxis diamondAxis, final String diamondContent, final Object[] dynamics) {
        return new Callable<Future<Object>>(){

            @Override
            public Future<Object> call() throws Exception {
                return DiamondCache.this.executorService.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Callable updater = DiamondCache.this.createUpdater(diamondAxis, diamondContent, dynamics);
                        if (updater == null) {
                            return null;
                        }
                        if (DiamondCache.this.isDynamicApplicable(updater)) {
                            return CacheBuilder.newBuilder().build();
                        }
                        Optional objectOptional = DiamondCache.this.updateCache(updater, diamondAxis, diamondContent, dynamics);
                        return objectOptional != null ? objectOptional.orNull() : null;
                    }
                });
            }
        };
    }

    private Object futureGet(DiamondAxis diamondAxis, String diamondContent, Future<Object> future, int dynamicsHasCode) {
        try {
            return future.get(3L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.log.error("update cache {} timeout, try to use snapshot", (Object)diamondContent);
            Optional<Object> object = this.snapshotMiner.getCache(diamondAxis, dynamicsHasCode);
            if (object != null) {
                return object.orNull();
            }
        }
        catch (Exception e) {
            this.log.error("update cache {} failed with error {}", (Object)diamondContent, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.log.error("update cache {} failed with error {}", (Object)diamondContent, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return null;
    }

    private Optional<Object> updateCache(Callable<Object> updater, DiamondAxis diamondAxis, String diamondContent, Object ... dynamics) {
        Object diamondCache;
        this.log.info("start to update cache {}", (Object)diamondAxis);
        if (StringUtils.isEmpty((CharSequence)diamondContent)) {
            return null;
        }
        try {
            diamondCache = updater.call();
        }
        catch (Exception e) {
            this.log.error("{} called with exception", (Object)diamondContent, (Object)e);
            return null;
        }
        int dynamicsHasCode = Arrays.deepHashCode(dynamics);
        this.snapshotMiner.saveCache(diamondAxis, diamondCache, dynamicsHasCode);
        this.log.info("end to update cache {}", (Object)diamondAxis);
        return Optional.fromNullable((Object)diamondCache);
    }

    private Callable<Object> createUpdater(DiamondAxis diamondAxis, String diamondContent, Object ... dynamics) {
        String substitute = DiamondSubstituter.substitute(diamondContent, true, diamondAxis.group, diamondAxis.dataId, null);
        Callable object = DiamondUtils.parseObject(substitute, Callable.class);
        if (object == null) {
            this.log.error("{} cannot be parsed as Callable", (Object)diamondContent);
            return null;
        }
        if (object instanceof DynamicsAppliable) {
            ((DynamicsAppliable)((Object)object)).setDynamics(dynamics);
        }
        return object;
    }

    public void close() {
        this.executorService.shutdownNow();
    }

    public Future<Object> updateDiamondCacheOnChange(final DiamondAxis diamondAxis, final String diamondContent) {
        Future cacheOptional = (Future)this.cache.getIfPresent((Object)diamondAxis);
        if (cacheOptional == null) {
            return cacheOptional;
        }
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Callable updater = DiamondCache.this.createUpdater(diamondAxis, diamondContent, new Object[0]);
                if (updater == null) {
                    return null;
                }
                if (DiamondCache.this.isDynamicApplicable(updater)) {
                    DiamondCache.this.removeCacheSnapshot(diamondAxis);
                    return null;
                }
                Optional updated = DiamondCache.this.updateCache(updater, diamondAxis, diamondContent, new Object[0]);
                if (updated != null) {
                    DiamondCache.this.cache.put((Object)diamondAxis, (Object)Futures.immediateFuture((Object)updated.orNull()));
                }
                return updated;
            }
        };
        return this.executorService.submit(task);
    }

    private boolean isDynamicApplicable(Callable<Object> updater) {
        return updater instanceof DynamicsAppliable;
    }

    public void removeCacheSnapshot(DiamondAxis diamondAxis) {
        this.cache.invalidate((Object)diamondAxis);
        this.snapshotMiner.removeAllCache(diamondAxis);
    }
}

