/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.impl.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProperties {
    static Logger log = LoggerFactory.getLogger(ClientProperties.class);
    static Properties properties = Props.tryProperties("diamond-client.properties", ".diamond-client");

    public static HostAndPort readNameServerAddresses() {
        String nameServerAddress = properties.getProperty("NameServer.address");
        if (StringUtils.isNotEmpty((CharSequence)nameServerAddress)) {
            return HostAndPort.fromString((String)nameServerAddress).withDefaultPort(17001);
        }
        return HostAndPort.fromParts((String)"a.b.c", (int)17001);
    }

    public static Set<String> readDiamondServersAddress() {
        String diamondServersAddress = properties.getProperty("DiamondServer.address", "");
        Splitter splitter = Splitter.onPattern((String)"\\s+").omitEmptyStrings().trimResults();
        HashSet addresses = Sets.newHashSet((Iterable)splitter.splitToList((CharSequence)diamondServersAddress));
        if (addresses.size() > 0) {
            log.info("got diamond servers {} from config {}", (Object)addresses, (Object)"DiamondServer.address");
        }
        return addresses;
    }

    public static NameServerMode readNameServerMode() {
        String nameServerAddress = properties.getProperty("NameServer.address");
        if (StringUtils.isNotBlank((CharSequence)nameServerAddress)) {
            return NameServerMode.ByAddressProperty;
        }
        String serverAddress = properties.getProperty("DiamondServer.address");
        if (StringUtils.isNotBlank((CharSequence)serverAddress)) {
            return NameServerMode.Off;
        }
        return NameServerMode.ByEtcHosts;
    }

    public static String readDiamondExtenders() {
        return properties.getProperty("diamond.extenders");
    }

    public static String getBasicAuth() {
        return properties.getProperty("BasicAuth");
    }

    public static enum NameServerMode {
        Off,
        ByEtcHosts,
        ByAddressProperty;

    }
}

