/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.DiamondListener;
import org.n3r.diamond.client.DiamondStone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiamondAllListener
implements DiamondListener {
    private Logger log = LoggerFactory.getLogger(DiamondAllListener.class);
    private final ConcurrentMap<DiamondAxis, CopyOnWriteArrayList<DiamondListener>> allListeners = new ConcurrentHashMap<DiamondAxis, CopyOnWriteArrayList<DiamondListener>>();

    DiamondAllListener() {
    }

    @Override
    public void accept(DiamondStone diamondStone) {
        CopyOnWriteArrayList listeners = (CopyOnWriteArrayList)this.allListeners.get(diamondStone.getDiamondAxis());
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (DiamondListener listener : listeners) {
            try {
                this.notifyListener(diamondStone, listener);
            }
            catch (Throwable t) {
                this.log.error("call listener error, {}", (Object)diamondStone.getDiamondAxis(), (Object)t);
            }
        }
    }

    private void notifyListener(final DiamondStone diamondStone, final DiamondListener listener) {
        if (listener == null) {
            return;
        }
        this.log.info("call listener {} for {}", (Object)listener, (Object)diamondStone.getDiamondAxis());
        Runnable job = new Runnable(){

            @Override
            public void run() {
                try {
                    listener.accept(diamondStone);
                }
                catch (Throwable t) {
                    DiamondAllListener.this.log.error("listener error {}", (Object)listener, (Object)t);
                }
            }
        };
        if (null != listener.getExecutor()) {
            listener.getExecutor().execute(job);
        } else {
            job.run();
        }
    }

    public void removeManagerListeners(DiamondAxis diamondAxis) {
        this.allListeners.remove(diamondAxis);
    }

    public void addDiamondListener(DiamondAxis diamondAxis, DiamondListener addListener) {
        CopyOnWriteArrayList oldList;
        if (null == addListener) {
            return;
        }
        CopyOnWriteArrayList<DiamondListener> listenerList = (CopyOnWriteArrayList<DiamondListener>)this.allListeners.get(diamondAxis);
        if (listenerList == null && (oldList = this.allListeners.putIfAbsent(diamondAxis, listenerList = new CopyOnWriteArrayList<DiamondListener>())) != null) {
            listenerList = oldList;
        }
        listenerList.add(addListener);
    }

    public void removeDiamondListener(DiamondAxis diamondAxis, DiamondListener addListener) {
        if (null == addListener) {
            return;
        }
        CopyOnWriteArrayList listenerList = (CopyOnWriteArrayList)this.allListeners.get(diamondAxis);
        if (listenerList != null) {
            listenerList.remove(addListener);
        }
    }

    @Override
    public ExecutorService getExecutor() {
        return null;
    }
}

