/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.io.IOUtils;
import org.n3r.diamond.client.impl.ClientProperties;
import org.n3r.diamond.client.impl.DiamondManagerConf;
import org.n3r.diamond.client.impl.DiamondMeta;
import org.n3r.diamond.client.impl.DiamondUtils;
import org.n3r.diamond.client.impl.MockDiamondServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiamondHttpClient {
    private MultiThreadedHttpConnectionManager connectionManager;
    private Logger log = LoggerFactory.getLogger(DiamondHttpClient.class);
    private final DiamondManagerConf diamondManagerConf;
    private HttpClient httpClient;

    public DiamondHttpClient(DiamondManagerConf diamondManagerConf) {
        this.diamondManagerConf = diamondManagerConf;
        if (MockDiamondServer.isTestMode()) {
            return;
        }
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.connectionManager.closeIdleConnections((long)(diamondManagerConf.getPollingInterval() * 4000));
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setStaleCheckingEnabled(diamondManagerConf.isConnectionStaleCheckingEnabled());
        HostConfiguration hostConfiguration = new HostConfiguration();
        params.setMaxConnectionsPerHost(hostConfiguration, diamondManagerConf.getMaxHostConnections());
        params.setMaxTotalConnections(diamondManagerConf.getMaxTotalConnections());
        params.setConnectionTimeout(diamondManagerConf.getConnectionTimeout());
        params.setSoTimeout(60000);
        this.connectionManager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    private void setBasicAuth(String host, int port) {
        String basicAuth = ClientProperties.getBasicAuth();
        if (Strings.isNullOrEmpty((String)basicAuth)) {
            return;
        }
        List splits = Splitter.on((char)':').trimResults().splitToList((CharSequence)basicAuth);
        if (splits.size() < 2) {
            return;
        }
        String userName = (String)splits.get(0);
        String passWord = (String)splits.get(1);
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, passWord);
        AuthScope authScope = new AuthScope(host, port, AuthScope.ANY_REALM);
        this.httpClient.getState().setCredentials(authScope, (Credentials)credentials);
    }

    public void resetHostConfig(String hostPort) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)hostPort);
        int portOrDefault = hostAndPort.getPortOrDefault(17002);
        HostConfiguration hostConfiguration = this.httpClient.getHostConfiguration();
        String hostText = hostAndPort.getHostText();
        hostConfiguration.setHost(hostText, portOrDefault);
        this.log.debug("use host {}:{}", (Object)hostText, (Object)portOrDefault);
        this.setBasicAuth(hostText, portOrDefault);
    }

    private void configureHttpMethod(HttpMethod httpMethod, boolean useContentCache, DiamondMeta diamondMeta, long onceTimeOut) {
        if (!useContentCache && null != diamondMeta) {
            String lastModifiedHeader = diamondMeta.getLastModifiedHeader();
            if (null != lastModifiedHeader && "" != lastModifiedHeader) {
                httpMethod.addRequestHeader("If-Modified-Since", lastModifiedHeader);
            }
            if (null != diamondMeta.getMd5() && "" != diamondMeta.getMd5()) {
                httpMethod.addRequestHeader("Content-MD5", diamondMeta.getMd5());
            }
        }
        httpMethod.addRequestHeader("Accept-Encoding", "gzip,deflate");
        HttpMethodParams params = new HttpMethodParams();
        params.setSoTimeout((int)onceTimeOut);
        httpMethod.setParams(params);
    }

    public HttpState getState() {
        return this.httpClient.getState();
    }

    public GetDiamondResult getDiamond(String uri, boolean useContentCache, DiamondMeta diamondMeta, long onceTimeOut) throws IOException {
        GetMethod getMethod = new GetMethod(uri);
        try {
            this.configureHttpMethod((HttpMethod)getMethod, useContentCache, diamondMeta, onceTimeOut);
            int httpStatus = this.httpClient.executeMethod((HttpMethod)getMethod);
            GetDiamondResult getDiamondResult = new GetDiamondResult();
            if (!this.isDiamondServerHealth((HttpMethod)getMethod)) {
                httpStatus = 503;
            }
            getDiamondResult.setHttpStatus(httpStatus);
            if (httpStatus == 200) {
                this.setResponseContent(getMethod, getDiamondResult);
                this.setLastModified(getMethod, getDiamondResult);
            }
            if (httpStatus == 200 || httpStatus == 304) {
                this.setMd5(getMethod, getDiamondResult);
                this.setPollingInterval(getMethod, getDiamondResult);
            }
            GetDiamondResult getDiamondResult2 = getDiamondResult;
            return getDiamondResult2;
        }
        catch (ConnectException e) {
            HostConfiguration hostConfiguration = this.httpClient.getHostConfiguration();
            this.log.error("connection to {}:{} error {}", new Object[]{hostConfiguration.getHost(), hostConfiguration.getPort(), e.getMessage()});
            throw e;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    private boolean isDiamondServerHealth(HttpMethod httpMethod) {
        Header header = httpMethod.getResponseHeader("Diamond-Server");
        return header != null && "Diamond-Server".equals(header.getValue());
    }

    private void setResponseContent(GetMethod getMethod, GetDiamondResult getDiamondResult) {
        String responseContent = this.getContentFromResponse((HttpMethod)getMethod);
        if (null == responseContent) {
            throw new RuntimeException("RP_OK got bad info");
        }
        getDiamondResult.setResponseContent(responseContent);
    }

    private void setLastModified(GetMethod getMethod, GetDiamondResult getDiamondResult) {
        Header lastModifiedHeader = getMethod.getResponseHeader("Last-Modified");
        if (null == lastModifiedHeader) {
            throw new RuntimeException("RP_OK without lastModifiedHeader");
        }
        String lastModified = lastModifiedHeader.getValue();
        getDiamondResult.setLastModified(lastModified);
    }

    private void setMd5(GetMethod getMethod, GetDiamondResult getDiamondResult) {
        Header md5Header = getMethod.getResponseHeader("Content-MD5");
        if (null == md5Header) {
            throw new RuntimeException("RP_NO_CHANGE without MD5");
        }
        getDiamondResult.setMd5(md5Header.getValue());
    }

    private void setPollingInterval(GetMethod getMethod, GetDiamondResult getDiamondResult) {
        Header[] spacingIntervalHeaders = getMethod.getResponseHeaders("client-spacing-interval");
        if (spacingIntervalHeaders.length >= 1) {
            try {
                getDiamondResult.setPollingInterval(Integer.parseInt(spacingIntervalHeaders[0].getValue()));
            }
            catch (RuntimeException e) {
                this.log.error("set polling interval error", (Throwable)e);
            }
        }
    }

    public CheckResult checkUpdateDataIds(String probeUpdateString, long onceTimeOut) throws IOException {
        PostMethod postMethod = new PostMethod("/diamond-server/content");
        postMethod.addParameter("Probe-Modify-Request", probeUpdateString);
        HttpMethodParams params = new HttpMethodParams();
        params.setSoTimeout((int)onceTimeOut);
        postMethod.setParams(params);
        try {
            int httpStatus = this.httpClient.executeMethod((HttpMethod)postMethod);
            if (!this.isDiamondServerHealth((HttpMethod)postMethod)) {
                httpStatus = 503;
            }
            Set<String> updateDataIdsInBody = httpStatus == 200 ? this.getUpdateDataIdsInBody((HttpMethod)postMethod) : null;
            CheckResult checkResult = new CheckResult(httpStatus, updateDataIdsInBody);
            return checkResult;
        }
        catch (ConnectException e) {
            HostConfiguration hostConfiguration = this.httpClient.getHostConfiguration();
            this.log.error("connection to {}:{} error {}", new Object[]{hostConfiguration.getHost(), hostConfiguration.getPort(), e.getMessage()});
            throw e;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private Set<String> getUpdateDataIdsInBody(HttpMethod httpMethod) {
        try {
            String modifiedDataIdsString = httpMethod.getResponseBodyAsString();
            return DiamondUtils.convertStringToSet(modifiedDataIdsString);
        }
        catch (Exception e) {
            this.log.error("getUpdateDataIdsInBody error", (Throwable)e);
            return new HashSet<String>();
        }
    }

    public void shutdown() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentFromResponse(HttpMethod httpMethod) {
        block7: {
            if (this.isZipContent(httpMethod)) {
                String string;
                InputStream is = null;
                GZIPInputStream gzin = null;
                try {
                    is = httpMethod.getResponseBodyAsStream();
                    gzin = new GZIPInputStream(is);
                    string = IOUtils.toString((InputStream)gzin);
                }
                catch (Exception e) {
                    try {
                        this.log.error("ungzip error", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(gzin);
                        IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)gzin);
                    IOUtils.closeQuietly((InputStream)is);
                    break block7;
                }
                IOUtils.closeQuietly((InputStream)gzin);
                IOUtils.closeQuietly((InputStream)is);
                return string;
            }
            try {
                return httpMethod.getResponseBodyAsString();
            }
            catch (Exception e) {
                this.log.error("getResponseBodyAsString error", (Throwable)e);
            }
        }
        return null;
    }

    private boolean isZipContent(HttpMethod httpMethod) {
        Header responseHeader = httpMethod.getResponseHeader("Content-Encoding");
        if (null == responseHeader) {
            return false;
        }
        String acceptEncoding = responseHeader.getValue();
        return acceptEncoding.toLowerCase().indexOf("gzip") > -1;
    }

    public static class CheckResult {
        private final int httpStatus;
        private final Set<String> updateDataIdsInBody;

        public CheckResult(int httpStatus, Set<String> updateDataIdsInBody) {
            this.httpStatus = httpStatus;
            this.updateDataIdsInBody = updateDataIdsInBody;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public Set<String> getUpdateDataIdsInBody() {
            return this.updateDataIdsInBody;
        }
    }

    public static class GetDiamondResult {
        private int httpStatus;
        private String md5;
        private int pollingInterval;
        private String responseContent;
        private String lastModified;

        public void setHttpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setPollingInterval(int pollingIntervalTime) {
            this.pollingInterval = pollingIntervalTime;
        }

        public int getPollingInterval() {
            return this.pollingInterval;
        }

        public void setResponseContent(String responseContent) {
            this.responseContent = responseContent;
        }

        public String getResponseContent() {
            return this.responseContent;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public String getLastModified() {
            return this.lastModified;
        }
    }
}

