/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.n3r.diamond.client.impl.DiamondHttpClient;
import org.n3r.diamond.client.impl.MockDiamondServer;
import org.n3r.diamond.client.impl.NoNameServerAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiamondManagerConf {
    private Logger log = LoggerFactory.getLogger(DiamondManagerConf.class);
    private volatile int pollingInterval = 15;
    private volatile int onceTimeout = 3000;
    private volatile int receiveWaitTime = 15000;
    private AtomicInteger domainNamePos = new AtomicInteger(0);
    private volatile List<String> diamondServers = Lists.newArrayList();
    private int maxHostConnections = 1;
    private boolean connectionStaleCheckingEnabled = true;
    private int maxTotalConnections = 20;
    private int connectionTimeout = 3000;
    private int retrieveDataRetryTimes = 0xCCCCCCC;
    private String filePath = System.getProperty("user.home") + File.separator + ".diamond-client";

    public DiamondManagerConf() {
        File dir = new File(this.filePath);
        dir.mkdirs();
        if (!dir.exists()) {
            throw new RuntimeException("create diamond-miner dir fail " + this.filePath);
        }
    }

    public int getMaxHostConnections() {
        return this.maxHostConnections;
    }

    public void setMaxHostConnections(int maxHostConnections) {
        this.maxHostConnections = maxHostConnections;
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.connectionStaleCheckingEnabled;
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.connectionStaleCheckingEnabled = connectionStaleCheckingEnabled;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        if (pollingInterval < 15 && !MockDiamondServer.isTestMode()) {
            return;
        }
        this.pollingInterval = pollingInterval;
    }

    public List<String> getDiamondServers() {
        return this.diamondServers;
    }

    public boolean hasDiamondServers() {
        return this.diamondServers.size() > 0;
    }

    public void setDiamondServers(Set<String> diamondServers, DiamondHttpClient diamondHttpClient) {
        if (Sets.newHashSet(this.diamondServers).equals(diamondServers)) {
            return;
        }
        this.diamondServers = Lists.newArrayList(diamondServers);
        this.randomDomainNamePos();
        diamondHttpClient.resetHostConfig(this.getDomainName());
    }

    public void addDomainName(String domainName) {
        this.diamondServers.add(domainName);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getOnceTimeout() {
        return this.onceTimeout;
    }

    public void setOnceTimeout(int onceTimeout) {
        this.onceTimeout = onceTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReceiveWaitTime() {
        return this.receiveWaitTime;
    }

    public void setReceiveWaitTime(int receiveWaitTime) {
        this.receiveWaitTime = receiveWaitTime;
    }

    public int getRetrieveDataRetryTimes() {
        return this.retrieveDataRetryTimes;
    }

    public void setRetrieveDataRetryTimes(int retrieveDataRetryTimes) {
        this.retrieveDataRetryTimes = retrieveDataRetryTimes;
    }

    public String getDomainName() {
        if (this.diamondServers.size() == 0) {
            throw new NoNameServerAvailableException("no name server available!");
        }
        return this.diamondServers.get(this.domainNamePos.get());
    }

    private void randomDomainNamePos() {
        int diamondServerNum = this.diamondServers.size();
        if (diamondServerNum > 1) {
            this.domainNamePos.set(new Random().nextInt(diamondServerNum));
            this.log.info("random DiamondServer to\uff1a" + this.getDomainName());
        }
    }

    synchronized void rotateToNextDomain(DiamondHttpClient diamondHttpClient) {
        int diamondServerNum = this.diamondServers.size();
        if (diamondServerNum == 0) {
            this.log.error("diamond server list is empty, please contact administrator");
            return;
        }
        if (diamondServerNum <= 1) {
            diamondHttpClient.resetHostConfig(this.getDomainName());
            return;
        }
        int index = this.domainNamePos.incrementAndGet();
        if (index < 0) {
            index = -index;
        }
        this.domainNamePos.set(index % diamondServerNum);
        diamondHttpClient.resetHostConfig(this.getDomainName());
        this.log.warn("rotate diamond server to " + this.getDomainName());
    }
}

