/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.DiamondListener;
import org.n3r.diamond.client.DiamondStone;
import org.n3r.diamond.client.cache.DiamondCache;
import org.n3r.diamond.client.impl.Constants;
import org.n3r.diamond.client.impl.DiamondAllListener;
import org.n3r.diamond.client.impl.DiamondHttpClient;
import org.n3r.diamond.client.impl.DiamondManagerConf;
import org.n3r.diamond.client.impl.DiamondMeta;
import org.n3r.diamond.client.impl.DiamondSubscriber;
import org.n3r.diamond.client.impl.DiamondUtils;
import org.n3r.diamond.client.impl.MockDiamondServer;
import org.n3r.diamond.client.impl.NoNameServerAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiamondRemoteChecker {
    private final DiamondCache diamondCache;
    private Logger log = LoggerFactory.getLogger(DiamondRemoteChecker.class);
    private Cache<DiamondAxis, Optional<String>> contentCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).maximumSize(10000L).build();
    private volatile DiamondAllListener diamondAllListener = new DiamondAllListener();
    private DiamondHttpClient diamondHttpClient;
    private final DiamondManagerConf managerConfig;
    private final DiamondSubscriber diamondSubscriber;

    public DiamondRemoteChecker(DiamondSubscriber diamondSubscriber, DiamondManagerConf managerConfig, DiamondCache diamondCache, DiamondHttpClient diamondHttpClient) {
        this.diamondSubscriber = diamondSubscriber;
        this.managerConfig = managerConfig;
        this.diamondCache = diamondCache;
        this.diamondHttpClient = diamondHttpClient;
    }

    public void addDiamondListener(DiamondAxis diamondAxis, DiamondListener diamondListener) {
        this.diamondAllListener.addDiamondListener(diamondAxis, diamondListener);
    }

    public void removeDiamondListener(DiamondAxis diamondAxis, DiamondListener diamondListener) {
        this.diamondAllListener.removeDiamondListener(diamondAxis, diamondListener);
    }

    public void shutdown() {
        this.diamondHttpClient.shutdown();
    }

    public void checkRemote() {
        Set<String> updateDataIdGroupPairs = this.checkUpdateDataIds(this.managerConfig.getReceiveWaitTime());
        if (null == updateDataIdGroupPairs || updateDataIdGroupPairs.size() == 0) {
            return;
        }
        for (String freshDataIdGroupPair : updateDataIdGroupPairs) {
            int middleIndex = freshDataIdGroupPair.indexOf(Constants.WORD_SEPARATOR);
            if (middleIndex == -1) continue;
            String freshDataId = freshDataIdGroupPair.substring(0, middleIndex);
            String freshGroup = freshDataIdGroupPair.substring(middleIndex + 1);
            DiamondAxis diamondAxis = DiamondAxis.makeAxis(freshGroup, freshDataId);
            DiamondMeta diamondMeta = this.diamondSubscriber.getCachedMeta(diamondAxis);
            this.receiveDiamondContent(diamondMeta);
        }
    }

    private void receiveDiamondContent(DiamondMeta diamondMeta) {
        try {
            this.retrieveRemoteAndInvokeListeners(diamondMeta);
        }
        catch (Exception e) {
            this.log.error("retrieveRemoteAndInvokeListeners error", (Object)e.getMessage());
        }
    }

    private void retrieveRemoteAndInvokeListeners(DiamondMeta diamondMeta) {
        String diamondContent = this.retrieveRemote(diamondMeta.getDiamondAxis(), this.managerConfig.getReceiveWaitTime(), false);
        if (null == this.diamondAllListener) {
            this.log.warn("null == configInfoListenable");
            return;
        }
        this.onDiamondChanged(diamondMeta, diamondContent);
    }

    Future<Object> onDiamondChanged(final DiamondMeta diamondMeta, final String content) {
        final DiamondStone diamondStone = new DiamondStone();
        diamondStone.setContent(content);
        diamondStone.setDiamondAxis(diamondMeta.getDiamondAxis());
        diamondMeta.incSuccCounterAndGet();
        Callable<Object> command = new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    DiamondRemoteChecker.this.diamondSubscriber.saveSnapshot(diamondStone.getDiamondAxis(), content);
                    DiamondRemoteChecker.this.diamondAllListener.accept(diamondStone);
                    return DiamondRemoteChecker.this.diamondCache.updateDiamondCacheOnChange(diamondStone.getDiamondAxis(), content);
                }
                catch (Throwable t) {
                    DiamondRemoteChecker.this.log.error("onDiamondChanged {} with error {}", (Object)diamondMeta.getDiamondAxis(), (Object)t.getMessage());
                    return null;
                }
            }
        };
        ExecutorService executor = this.diamondAllListener.getExecutor();
        if (executor == null) {
            executor = MoreExecutors.sameThreadExecutor();
        }
        return executor.submit(command);
    }

    String retrieveRemote(DiamondAxis diamondAxis, long timeout, boolean useContentCache) {
        Optional optional;
        this.diamondSubscriber.start();
        if (useContentCache && (optional = (Optional)this.contentCache.getIfPresent((Object)diamondAxis)) != null) {
            return (String)optional.orNull();
        }
        long costTime = 0L;
        String uri = this.getUriString(diamondAxis);
        int totalRetryTimes = this.managerConfig.getRetrieveDataRetryTimes();
        int triedTimes = 0;
        Exception lastException = null;
        int lastHttpStatus = -1;
        while (0L == timeout || timeout > costTime) {
            if (triedTimes > 0) {
                this.managerConfig.rotateToNextDomain(this.diamondHttpClient);
            }
            if (triedTimes > totalRetryTimes + 1) {
                this.log.warn("reached the max retry times");
                break;
            }
            if (triedTimes > 0) {
                this.log.info("retrieve config\uff0ctry {} times with costTime {}", (Object)triedTimes, (Object)costTime);
            }
            ++triedTimes;
            long onceTimeOut = this.getOnceTimeOut(costTime, timeout);
            costTime += onceTimeOut;
            try {
                DiamondMeta diamondMeta = this.diamondSubscriber.getCachedMeta(diamondAxis);
                DiamondHttpClient.GetDiamondResult getDiamondResult = this.diamondHttpClient.getDiamond(uri, useContentCache, diamondMeta, onceTimeOut);
                int httpStatus = getDiamondResult.getHttpStatus();
                switch (httpStatus) {
                    case 200: {
                        return this.onSuccess(diamondAxis, diamondMeta, getDiamondResult);
                    }
                    case 304: {
                        return this.onNotModified(diamondAxis, diamondMeta, getDiamondResult);
                    }
                    case 404: {
                        this.log.warn("{} not found", (Object)diamondAxis);
                        diamondMeta.setMd5("");
                        this.diamondSubscriber.removeSnapshot(diamondAxis);
                        this.diamondCache.removeCacheSnapshot(diamondAxis);
                        this.contentCache.put((Object)diamondAxis, (Object)Optional.absent());
                        return null;
                    }
                }
                if (httpStatus == lastHttpStatus) continue;
                this.log.warn("{}: HTTP State: {} : {} ", new Object[]{diamondAxis, httpStatus, this.diamondHttpClient.getState()});
                lastHttpStatus = httpStatus;
            }
            catch (Exception e) {
                if (this.isMessageSameExeption(e, lastException)) continue;
                this.log.error("{}: http error\uff1a{}", (Object)diamondAxis, (Object)e.getMessage());
                lastException = e;
            }
        }
        throw new RuntimeException("get config ," + diamondAxis + ", timeout=" + timeout);
    }

    private Set<String> checkUpdateDataIds(long timeout) {
        long onceTimeOut;
        if (MockDiamondServer.isTestMode()) {
            return null;
        }
        String probeUpdateString = this.diamondSubscriber.createProbeUpdateString();
        if (StringUtils.isBlank((CharSequence)probeUpdateString)) {
            return null;
        }
        int lastHttpStatus = -1;
        Exception lastException = null;
        for (long costTime = 0L; 0L == timeout || timeout > costTime; costTime += onceTimeOut) {
            if (costTime > 0L) {
                this.managerConfig.rotateToNextDomain(this.diamondHttpClient);
            }
            onceTimeOut = this.getOnceTimeOut(costTime, timeout);
            try {
                DiamondHttpClient.CheckResult checkResult = this.diamondHttpClient.checkUpdateDataIds(probeUpdateString, onceTimeOut);
                int httpStatus = checkResult.getHttpStatus();
                switch (httpStatus) {
                    case 200: {
                        return checkResult.getUpdateDataIdsInBody();
                    }
                }
                if (httpStatus == lastHttpStatus) continue;
                this.log.warn("get changed DataID list response HTTP State: " + httpStatus);
                lastHttpStatus = httpStatus;
                continue;
            }
            catch (NoNameServerAvailableException e) {
                this.log.warn("checkUpdateDataIds error {}", (Object)e.getMessage());
                break;
            }
            catch (Exception e) {
                if (this.isMessageSameExeption(e, lastException)) continue;
                this.log.warn("checkUpdateDataIds error {}", (Object)e.getMessage());
                lastException = e;
                continue;
            }
        }
        throw new RuntimeException("get changed dataId list to " + this.managerConfig.getDomainName() + " timeout " + timeout);
    }

    private boolean isMessageSameExeption(Exception e1, Exception e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null) {
            return false;
        }
        if (e2 == null) {
            return false;
        }
        return e1.getMessage().equals(e2.getMessage());
    }

    private String onSuccess(DiamondAxis diamondAxis, DiamondMeta diamondMeta, DiamondHttpClient.GetDiamondResult httpMethod) {
        String diamondContent = httpMethod.getResponseContent();
        if (!DiamondUtils.checkMd5(diamondContent, httpMethod.getMd5())) {
            throw new RuntimeException("MD5 check error for DataID=" + diamondAxis.getDataId() + ", content=" + diamondContent + ", md5=" + httpMethod.getMd5());
        }
        String lastModified = httpMethod.getLastModified();
        diamondMeta.setMd5(httpMethod.getMd5());
        diamondMeta.setLastModifiedHeader(lastModified);
        this.changeSpacingInterval(httpMethod);
        this.contentCache.put((Object)diamondAxis, (Object)Optional.fromNullable((Object)diamondContent));
        return diamondContent;
    }

    long getOnceTimeOut(long costTime, long totalTimeout) {
        long remainTime;
        long onceTimeOut = this.managerConfig.getOnceTimeout();
        if (onceTimeOut > (remainTime = totalTimeout - costTime)) {
            onceTimeOut = remainTime;
        }
        return onceTimeOut;
    }

    private String onNotModified(DiamondAxis diamondAxis, DiamondMeta diamondMeta, DiamondHttpClient.GetDiamondResult httpMethod) {
        String md5 = httpMethod.getMd5();
        if (!diamondMeta.getMd5().equals(md5)) {
            String lastMd5 = diamondMeta.getMd5();
            diamondMeta.setMd5("");
            diamondMeta.setLastModifiedHeader("");
            throw new RuntimeException("MD5 checked error," + diamondAxis + " last md5=" + lastMd5 + ", current md5=" + md5);
        }
        diamondMeta.setMd5(md5);
        this.changeSpacingInterval(httpMethod);
        this.log.info("{} not modified", (Object)diamondAxis);
        return null;
    }

    void changeSpacingInterval(DiamondHttpClient.GetDiamondResult httpMethod) {
        int pollingIntervalTime = httpMethod.getPollingInterval();
        if (pollingIntervalTime > 0) {
            this.managerConfig.setPollingInterval(pollingIntervalTime);
        }
    }

    String getUriString(DiamondAxis diamondAxis) {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("/diamond-server/content").append("?dataId=" + diamondAxis.getDataId()).append("&group=" + diamondAxis.getGroup());
        return uriBuilder.toString();
    }
}

