/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.DiamondListener;
import org.n3r.diamond.client.cache.DiamondCache;
import org.n3r.diamond.client.impl.Constants;
import org.n3r.diamond.client.impl.DiamondExtenderManager;
import org.n3r.diamond.client.impl.DiamondHttpClient;
import org.n3r.diamond.client.impl.DiamondManagerConf;
import org.n3r.diamond.client.impl.DiamondMeta;
import org.n3r.diamond.client.impl.DiamondRemoteChecker;
import org.n3r.diamond.client.impl.LocalDiamondMiner;
import org.n3r.diamond.client.impl.MockDiamondServer;
import org.n3r.diamond.client.impl.ServerAddressesMiner;
import org.n3r.diamond.client.impl.SnapshotMiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiamondSubscriber
implements Closeable {
    private static DiamondSubscriber instance = new DiamondSubscriber();
    private Logger log = LoggerFactory.getLogger(DiamondSubscriber.class);
    private final LoadingCache<DiamondAxis, DiamondMeta> metaCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<DiamondAxis, DiamondMeta>(){

        public DiamondMeta load(DiamondAxis key) throws Exception {
            DiamondSubscriber.this.start();
            return new DiamondMeta(key);
        }
    });
    private volatile DiamondManagerConf managerConfig = new DiamondManagerConf();
    private ScheduledExecutorService scheduler;
    private LocalDiamondMiner localDiamondMiner = new LocalDiamondMiner();
    private ServerAddressesMiner serverAddressesMiner;
    private SnapshotMiner snapshotMiner;
    private DiamondCache diamondCache;
    private volatile boolean running;
    private DiamondRemoteChecker diamondRemoteChecker;

    public static DiamondSubscriber getInstance() {
        return instance;
    }

    private DiamondSubscriber() {
    }

    public void addDiamondListener(DiamondAxis diamondAxis, DiamondListener diamondListener) {
        this.diamondRemoteChecker.addDiamondListener(diamondAxis, diamondListener);
    }

    public void removeDiamondListener(DiamondAxis diamondAxis, DiamondListener diamondListener) {
        this.diamondRemoteChecker.removeDiamondListener(diamondAxis, diamondListener);
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        if (null == this.scheduler || this.scheduler.isTerminated()) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
        }
        this.localDiamondMiner.start(this.managerConfig);
        DiamondHttpClient diamondHttpClient = new DiamondHttpClient(this.managerConfig);
        this.serverAddressesMiner = new ServerAddressesMiner(this.managerConfig, this.scheduler, diamondHttpClient);
        this.serverAddressesMiner.start();
        this.snapshotMiner = new SnapshotMiner(this.managerConfig);
        this.diamondCache = new DiamondCache(this.snapshotMiner);
        this.diamondRemoteChecker = new DiamondRemoteChecker(this, this.managerConfig, this.diamondCache, diamondHttpClient);
        this.running = true;
        this.log.info("diamond servers {}", this.managerConfig.getDiamondServers());
        this.rotateCheckDiamonds();
        this.addShutdownHook();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DiamondSubscriber.this.close();
            }
        });
    }

    private void rotateCheckDiamonds() {
        int pollingInterval = this.managerConfig.getPollingInterval();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                new DiamondExtenderManager().loadDiamondExtenders();
            }
        }, 5L, TimeUnit.SECONDS);
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                DiamondSubscriber.this.rotateCheckDiamondsTask();
            }
        }, pollingInterval, pollingInterval, TimeUnit.SECONDS);
    }

    private void rotateCheckDiamondsTask() {
        try {
            this.checkLocal();
            this.diamondRemoteChecker.checkRemote();
            this.checkSnapshot();
        }
        catch (Exception e) {
            this.log.warn("rotateCheckDiamondsTask error {}", (Object)e.getMessage());
        }
    }

    @Override
    public synchronized void close() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.log.warn("start to close DiamondSubscriber");
        this.localDiamondMiner.stop();
        this.serverAddressesMiner.stop();
        this.scheduler.shutdownNow();
        this.metaCache.invalidateAll();
        this.diamondRemoteChecker.shutdown();
        this.diamondCache.close();
        this.log.warn("end to close DiamondSubscriber");
    }

    public DiamondRemoteChecker getDiamondRemoteChecker() {
        return this.diamondRemoteChecker;
    }

    public String retrieveDiamondLocalAndRemote(DiamondAxis diamondAxis, long timeout) {
        DiamondMeta diamondMeta = this.getCachedMeta(diamondAxis);
        try {
            String localConfig = this.localDiamondMiner.readLocal(diamondMeta);
            if (localConfig != null) {
                diamondMeta.incSuccCounterAndGet();
                this.saveSnapshot(diamondAxis, localConfig);
                return localConfig;
            }
        }
        catch (Exception e) {
            this.log.error("get local error", (Throwable)e);
        }
        String result = this.diamondRemoteChecker.retrieveRemote(diamondAxis, timeout, true);
        if (result != null) {
            this.saveSnapshot(diamondAxis, result);
            diamondMeta.incSuccCounterAndGet();
        }
        return result;
    }

    public void saveSnapshot(DiamondAxis diamondAxis, String diamondContent) {
        this.snapshotMiner.saveSnaptshot(diamondAxis, diamondContent);
    }

    public String getDiamond(DiamondAxis diamondAxis, long timeout) {
        if (MockDiamondServer.isTestMode()) {
            return MockDiamondServer.getDiamond(diamondAxis);
        }
        try {
            String result = this.retrieveDiamondLocalAndRemote(diamondAxis, timeout);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                return result;
            }
        }
        catch (Exception t) {
            this.log.error(t.getMessage());
        }
        if (MockDiamondServer.isTestMode()) {
            return null;
        }
        return this.getSnapshot(diamondAxis);
    }

    public String getSnapshot(DiamondAxis diamondAxis) {
        try {
            DiamondMeta diamondMeta = this.getCachedMeta(diamondAxis);
            String diamondContent = this.snapshotMiner.getSnapshot(diamondAxis);
            if (diamondContent != null && diamondMeta != null) {
                diamondMeta.incSuccCounterAndGet();
            }
            return diamondContent;
        }
        catch (Exception e) {
            this.log.error("getSnapshot diamondAxis {} error {}", (Object)diamondAxis, (Object)e.getMessage());
            return null;
        }
    }

    public void removeSnapshot(DiamondAxis diamondAxis) {
        this.snapshotMiner.removeSnapshot(diamondAxis);
    }

    public void checkSnapshot() {
        for (Map.Entry entry : this.metaCache.asMap().entrySet()) {
            String diamond;
            DiamondMeta diamondMeta = (DiamondMeta)entry.getValue();
            if (diamondMeta.isUseLocal() || diamondMeta.getFetchCount() > 0L || (diamond = this.getSnapshot(diamondMeta.getDiamondAxis())) == null) continue;
            this.diamondRemoteChecker.onDiamondChanged(diamondMeta, diamond);
        }
    }

    public DiamondMeta getCachedMeta(DiamondAxis diamondAxis) {
        return (DiamondMeta)this.metaCache.getUnchecked((Object)diamondAxis);
    }

    public void checkLocal() {
        for (Map.Entry entry : this.metaCache.asMap().entrySet()) {
            DiamondMeta diamondMeta = (DiamondMeta)entry.getValue();
            try {
                String content = this.localDiamondMiner.checkLocal(diamondMeta);
                if (null == content) continue;
                this.log.info("local config read, {}", (Object)diamondMeta.getDiamondAxis());
                this.diamondRemoteChecker.onDiamondChanged(diamondMeta, content);
            }
            catch (Exception e) {
                this.log.error("check local error", (Throwable)e);
            }
        }
    }

    public String createProbeUpdateString() {
        StringBuilder probeModifyBuilder = new StringBuilder();
        for (Map.Entry entry : this.metaCache.asMap().entrySet()) {
            DiamondMeta data = (DiamondMeta)entry.getValue();
            if (data.isUseLocal()) continue;
            DiamondAxis axis = data.getDiamondAxis();
            probeModifyBuilder.append(axis.getDataId()).append(Constants.WORD_SEPARATOR).append(axis.getGroup()).append(Constants.WORD_SEPARATOR).append(data.getMd5()).append(Constants.LINE_SEPARATOR);
        }
        return probeModifyBuilder.toString();
    }

    public Object getCache(DiamondAxis diamondAxis, int timeoutMillis, Object ... dynamics) {
        String diamondContent = this.getDiamond(diamondAxis, timeoutMillis);
        if (diamondContent == null) {
            return null;
        }
        return this.diamondCache.getCache(diamondAxis, diamondContent, dynamics);
    }
}

