/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.Miner;
import org.n3r.diamond.client.impl.DiamondUtils;

public abstract class DiamondSubstituter {
    public static final String DEF_HOLDER_PREFIX = "${";
    public static final String DEF_HOLDER_SUFFIX = "}";
    public static final int SYS_PROPS_MODE_FALLBACK = 1;
    public static final int SYS_PROPS_MODE_OVERRIDE = 2;
    private static final int DEF_HOLDER_PREFIX_LEN = "${".length();
    private static final int DEF_HOLDER_SUFFIX_LEN = "}".length();

    public static String substitute(String strVal, boolean ignoreBadHolders, String group, String dataId, Properties lastProperties) {
        if (strVal == null) {
            return null;
        }
        HashSet<String> visitedHolders = new HashSet<String>();
        return DiamondSubstituter.substitute(strVal, visitedHolders, ignoreBadHolders, group, dataId, lastProperties);
    }

    public static String substitute(String strVal, Set<String> visitedHolders, boolean ignoreBadHolders, String group, String dataId, Properties lastProperties) {
        if (strVal == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(DEF_HOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = DiamondSubstituter.findHolderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String holder = buf.substring(startIndex + DEF_HOLDER_PREFIX_LEN, endIndex);
                String defValue = null;
                int defIndex = StringUtils.lastIndexOf((CharSequence)holder, (CharSequence)":");
                if (defIndex >= 0) {
                    defValue = StringUtils.trim((String)holder.substring(defIndex + 1));
                    holder = StringUtils.trim((String)holder.substring(0, defIndex));
                }
                if (!visitedHolders.add(holder)) {
                    throw new RuntimeException("Circular PlaceHolder reference '" + holder + "' in property definitions");
                }
                String propVal = DiamondSubstituter.resolveHolder(strVal, holder = DiamondSubstituter.substitute(holder, visitedHolders, ignoreBadHolders, group, dataId, lastProperties), 1, defValue, group, dataId, lastProperties);
                if (propVal != null) {
                    propVal = DiamondSubstituter.substitute(propVal, visitedHolders, ignoreBadHolders, group, dataId, lastProperties);
                    buf.replace(startIndex, endIndex + DEF_HOLDER_SUFFIX_LEN, propVal);
                    startIndex = buf.indexOf(DEF_HOLDER_PREFIX, startIndex + propVal.length());
                } else if (ignoreBadHolders) {
                    startIndex = buf.indexOf(DEF_HOLDER_PREFIX, endIndex + DEF_HOLDER_SUFFIX_LEN);
                } else {
                    throw new RuntimeException("Could not resolve Placeholder '" + holder + "'");
                }
                visitedHolders.remove(holder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private static int findHolderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + DEF_HOLDER_PREFIX_LEN;
        int withinNestedHolder = 0;
        while (index < buf.length()) {
            if (DiamondSubstituter.substringMatch(buf, index, DEF_HOLDER_SUFFIX)) {
                if (withinNestedHolder > 0) {
                    --withinNestedHolder;
                    index += DEF_HOLDER_SUFFIX_LEN;
                    continue;
                }
                return index;
            }
            if (DiamondSubstituter.substringMatch(buf, index, DEF_HOLDER_PREFIX)) {
                ++withinNestedHolder;
                index += DEF_HOLDER_PREFIX_LEN;
                continue;
            }
            ++index;
        }
        return -1;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    private static String resolveHolder(String strVal, String holder, int sysPropsMode, String defaultValue, String group, String dataId, Properties lastProperties) {
        String propVal = null;
        if (sysPropsMode == 2) {
            propVal = DiamondSubstituter.resolveSystemProperty(holder);
        }
        if (propVal == null) {
            propVal = DiamondSubstituter.resolveHolder(strVal, holder, defaultValue, group, dataId, lastProperties);
        }
        if (propVal == null && sysPropsMode == 1) {
            propVal = DiamondSubstituter.resolveSystemProperty(holder);
        }
        return propVal;
    }

    protected static String resolveHolder(String strVal, String holder, String defaultValue, String curGroup, String curDataId, Properties lastProperties) {
        String value;
        int propKeyPos;
        int separated = holder.indexOf(94);
        if (separated < 0 && holder.startsWith("this.")) {
            String referKey = holder.substring("this.".length());
            return DiamondSubstituter.recursiveSubstitute(strVal, defaultValue, curGroup, curDataId, lastProperties, referKey);
        }
        String group = "DEFAULT_GROUP";
        String dataId = holder;
        if (separated > 0 && separated < holder.length() - 1) {
            group = holder.substring(0, separated);
            dataId = holder.substring(separated + 1);
        }
        if ((propKeyPos = dataId.indexOf(94)) > 0) {
            String subDataId = dataId.substring(0, propKeyPos);
            String propKey = dataId.substring(propKeyPos + 1);
            value = DiamondSubstituter.isSameGroupAndDataId(curGroup, curDataId, group, subDataId) ? DiamondSubstituter.recursiveSubstitute(strVal, defaultValue, curGroup, curDataId, lastProperties, propKey) : new Miner().getMiner(group, subDataId).getString(propKey);
        } else {
            if (DiamondSubstituter.isSameGroupAndDataId(curGroup, curDataId, group, dataId)) {
                throw new RuntimeException(curGroup + "^" + curDataId + "can not refer itself");
            }
            value = new Miner().getStone(group, dataId);
        }
        return value != null ? value : defaultValue;
    }

    private static String recursiveSubstitute(String strVal, String defaultValue, String curGroup, String curDataId, Properties lastProperties, String referKey) {
        Properties properties = lastProperties != null ? lastProperties : DiamondUtils.parseStoneToProperties(strVal);
        String property = properties.getProperty(referKey, defaultValue);
        String substitute = DiamondSubstituter.substitute(property, true, curGroup, curDataId, properties);
        properties.setProperty(referKey, substitute);
        return substitute;
    }

    private static boolean isSameGroupAndDataId(String curGroup, String curDataId, String group, String subDataId) {
        return StringUtils.equals((CharSequence)group, (CharSequence)curGroup) && StringUtils.equals((CharSequence)subDataId, (CharSequence)curDataId);
    }

    private static String resolveSystemProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

