/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.impl.DiamondManagerConf;
import org.n3r.diamond.client.impl.DiamondMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalDiamondMiner {
    private Logger log = LoggerFactory.getLogger(LocalDiamondMiner.class);
    private Map<String, Long> existFilesTimestamp = new HashMap<String, Long>();
    private volatile boolean running;
    private String rootPath = null;
    private FileAlterationMonitor monitor;

    LocalDiamondMiner() {
    }

    public String checkLocal(DiamondMeta diamondMeta) {
        String filePath = this.getFilePath(diamondMeta.getDiamondAxis());
        if (!this.existFilesTimestamp.containsKey(filePath)) {
            if (diamondMeta.isUseLocal()) {
                diamondMeta.clear();
            }
            return null;
        }
        diamondMeta.setUseLocal(true);
        if (!filePath.equals(diamondMeta.getLocalFile()) || this.existFilesTimestamp.get(filePath).longValue() != diamondMeta.getLocalVersion()) {
            diamondMeta.setLocalFile(filePath);
            diamondMeta.setLocalVersion(this.existFilesTimestamp.get(filePath));
            this.log.info("local changed, {}", (Object)diamondMeta.getDiamondAxis());
            return this.readFileContent(filePath);
        }
        return null;
    }

    public String readLocal(DiamondMeta diamondMeta) {
        String filePath = this.getFilePath(diamondMeta.getDiamondAxis());
        if (!this.existFilesTimestamp.containsKey(filePath)) {
            if (diamondMeta.isUseLocal()) {
                diamondMeta.clear();
            }
            return null;
        }
        return this.readFileContent(filePath);
    }

    String readFileContent(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            this.log.error("read file content fail {}", (Object)e.getMessage());
            return null;
        }
    }

    String getFilePath(DiamondAxis diamondAxis) {
        File file = new File(this.rootPath + File.separator + diamondAxis.getGroup() + File.separator + diamondAxis.getDataId() + ".diamond");
        return file.getAbsolutePath();
    }

    public synchronized void start(DiamondManagerConf managerConfig) {
        if (this.running) {
            return;
        }
        this.running = true;
        this.rootPath = managerConfig.getFilePath() + File.separator + "config-data";
        this.initDataDir();
        this.startCheckLocalDir();
    }

    private void watchRoot() {
        FileAlterationObserver observer = new FileAlterationObserver(this.rootPath);
        observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onFileCreate(File file) {
                String realPath = file.getAbsolutePath();
                String grandpaDir = LocalDiamondMiner.this.getGrandpaDir(realPath);
                if (!LocalDiamondMiner.this.rootPath.equals(grandpaDir) || !".diamond".equals("." + FilenameUtils.getExtension((String)realPath))) {
                    return;
                }
                LocalDiamondMiner.this.existFilesTimestamp.put(realPath, System.currentTimeMillis());
                LocalDiamondMiner.this.log.debug("File {} Created", (Object)realPath);
            }

            public void onFileDelete(File file) {
                String realPath = file.getAbsolutePath();
                String grandpaDir = LocalDiamondMiner.this.getGrandpaDir(realPath);
                if (LocalDiamondMiner.this.rootPath.equals(grandpaDir) && ".diamond".equals("." + FilenameUtils.getExtension((String)realPath))) {
                    LocalDiamondMiner.this.existFilesTimestamp.remove(realPath);
                    LocalDiamondMiner.this.log.debug("File {} Delete", (Object)realPath);
                }
            }

            public void onFileChange(File file) {
                String realPath = file.getAbsolutePath();
                String grandpaDir = LocalDiamondMiner.this.getGrandpaDir(realPath);
                if (!LocalDiamondMiner.this.rootPath.equals(grandpaDir) || !".diamond".equals("." + FilenameUtils.getExtension((String)realPath))) {
                    return;
                }
                LocalDiamondMiner.this.existFilesTimestamp.put(realPath, System.currentTimeMillis());
                LocalDiamondMiner.this.log.debug("File {} Created", (Object)realPath);
            }
        });
        this.monitor = new FileAlterationMonitor(5000L);
        this.monitor.addObserver(observer);
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            this.log.error("start monitor fail", (Throwable)e);
        }
    }

    private void initDataDir() {
        try {
            new File(this.rootPath).mkdir();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.monitor != null) {
            try {
                this.monitor.stop();
            }
            catch (Exception e) {
                this.log.error("stop monitor fail", (Throwable)e);
            }
        }
    }

    private void index(File file) {
        File[] subFiles;
        if (!file.isDirectory()) {
            return;
        }
        for (File subFile : subFiles = file.listFiles()) {
            if (subFile.isDirectory()) {
                this.index(subFile);
                continue;
            }
            String realPath = subFile.getAbsolutePath();
            String grandpaDir = this.getGrandpaDir(realPath);
            if (!this.rootPath.equals(grandpaDir) || !".diamond".equals("." + FilenameUtils.getExtension((String)realPath))) continue;
            this.existFilesTimestamp.put(realPath, System.currentTimeMillis());
            this.log.debug("{} file was added", (Object)realPath);
        }
    }

    private void startCheckLocalDir() {
        this.index(new File(this.rootPath));
        this.watchRoot();
    }

    public String getGrandpaDir(String path) {
        File grandpa;
        File file = new File(path);
        if (file.isDirectory()) {
            this.log.error("{} is not a directory", (Object)path);
            return null;
        }
        File parent = file.getParentFile();
        if (parent != null && (grandpa = parent.getParentFile()) != null) {
            return grandpa.getAbsolutePath();
        }
        this.log.error("fail to get grandpa of {}", (Object)path);
        return null;
    }
}

