/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.impl.ClientProperties;
import org.n3r.diamond.client.impl.DiamondHttpClient;
import org.n3r.diamond.client.impl.DiamondManagerConf;
import org.n3r.diamond.client.impl.MockDiamondServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerAddressesMiner {
    private Logger log = LoggerFactory.getLogger(ServerAddressesMiner.class);
    private volatile boolean running;
    private volatile DiamondManagerConf diamondManagerConf;
    private HttpClient httpClient;
    private final DiamondHttpClient diamondHttpClient;
    private SimpleHttpConnectionManager connectionManager;
    private ScheduledExecutorService scheduledExecutor;
    private int asyncAcquireIntervalInSec = 300;

    public ServerAddressesMiner(DiamondManagerConf diamondManagerConf, ScheduledExecutorService scheduledExecutor, DiamondHttpClient diamondHttpClient) {
        this.diamondManagerConf = diamondManagerConf;
        this.scheduledExecutor = scheduledExecutor;
        this.diamondHttpClient = diamondHttpClient;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        if (MockDiamondServer.isTestMode()) {
            this.diamondManagerConf.addDomainName("Testing mode");
            return;
        }
        this.initHttpClient();
        this.syncAcquireServerAddresses();
        this.asyncAcquireServerAddresses();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    private void initHttpClient() {
        if (ClientProperties.readNameServerMode() == ClientProperties.NameServerMode.Off) {
            return;
        }
        this.connectionManager = new SimpleHttpConnectionManager();
        this.connectionManager.closeIdleConnections(5000L);
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setStaleCheckingEnabled(this.diamondManagerConf.isConnectionStaleCheckingEnabled());
        params.setConnectionTimeout(this.diamondManagerConf.getConnectionTimeout());
        this.connectionManager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.httpClient.setHostConfiguration(new HostConfiguration());
        DefaultHttpMethodRetryHandler retryHandler = new DefaultHttpMethodRetryHandler(0, false);
        this.httpClient.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
    }

    protected void syncAcquireServerAddresses() {
        if (ClientProperties.readNameServerMode() != ClientProperties.NameServerMode.Off && this.acquireServerAddresses()) {
            return;
        }
        if (this.readClientServerAddress()) {
            return;
        }
        if (this.reloadServerAddresses()) {
            return;
        }
        this.log.warn("no diamond servers available");
    }

    private boolean readClientServerAddress() {
        Set<String> serverAddress = ClientProperties.readDiamondServersAddress();
        if (serverAddress.size() > 0) {
            this.diamondManagerConf.setDiamondServers(serverAddress, this.diamondHttpClient);
            return true;
        }
        return false;
    }

    protected void asyncAcquireServerAddresses() {
        if (ClientProperties.readNameServerMode() == ClientProperties.NameServerMode.Off) {
            return;
        }
        this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ServerAddressesMiner.this.acquireServerAddresses();
            }
        }, this.asyncAcquireIntervalInSec, this.asyncAcquireIntervalInSec, TimeUnit.SECONDS);
    }

    void saveServerAddressesToLocal() {
        ArrayList<String> domainNameList = new ArrayList<String>(this.diamondManagerConf.getDiamondServers());
        try {
            FileUtils.writeLines((File)this.getLocalServerAddressFile(), domainNameList);
        }
        catch (Exception e) {
            this.log.error("save diamond servers to local failed ", (Object)e.getMessage());
        }
    }

    private boolean reloadServerAddresses() {
        this.log.info("read diamond server addresses from local");
        try {
            File serverAddressFile = this.getLocalServerAddressFile();
            if (!serverAddressFile.exists()) {
                return false;
            }
            List addresses = FileUtils.readLines((File)serverAddressFile);
            for (String address : addresses) {
                List<String> diamondServers;
                if (!StringUtils.isNotEmpty((CharSequence)(address = address.trim())) || (diamondServers = this.diamondManagerConf.getDiamondServers()).contains(address)) continue;
                diamondServers.add(address);
            }
            if (this.diamondManagerConf.getDiamondServers().size() > 0) {
                this.log.info("successfully to read diamond server addresses {} from local", (Object)addresses);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("failed to read diamond server addresses from local", (Throwable)e);
        }
        return false;
    }

    private File getLocalServerAddressFile() {
        String directory = this.diamondManagerConf.getFilePath();
        return new File(FilenameUtils.concat((String)directory, (String)"DiamondServer.address"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireServerAddresses() {
        HostAndPort hostAndPort = ClientProperties.readNameServerAddresses();
        this.httpClient.getHostConfiguration().setHost(hostAndPort.getHostText(), hostAndPort.getPort());
        GetMethod httpMethod = new GetMethod("/diamond-server/nameserver");
        HttpMethodParams params = new HttpMethodParams();
        params.setSoTimeout(this.diamondManagerConf.getOnceTimeout());
        httpMethod.setParams(params);
        try {
            if (200 != this.httpClient.executeMethod((HttpMethod)httpMethod)) {
                this.log.warn("no diamond servers available from {}.", (Object)this.httpClient.getHostConfiguration().getHost());
                boolean bl = false;
                return bl;
            }
            List newDomainNameList = IOUtils.readLines((InputStream)httpMethod.getResponseBodyAsStream());
            if (newDomainNameList.size() > 0) {
                HashSet diamondServers = Sets.newHashSet((Iterable)newDomainNameList);
                this.log.info("got diamond servers {} from NameServer {}", (Object)diamondServers, (Object)this.httpClient.getHostConfiguration().getHost());
                this.diamondManagerConf.setDiamondServers(diamondServers, this.diamondHttpClient);
                this.saveServerAddressesToLocal();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            this.log.error("failed to get diamond servers from {} with error {}", (Object)this.httpClient.getHostConfiguration().getHost(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            httpMethod.releaseConnection();
        }
        return false;
    }
}

