/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.base.Optional;
import com.google.common.primitives.UnsignedLongs;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.impl.DiamondManagerConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotMiner {
    private Logger log = LoggerFactory.getLogger(SnapshotMiner.class);
    private final String dir;

    public SnapshotMiner(DiamondManagerConf managerConfig) {
        this.dir = managerConfig.getFilePath() + File.separator + "snapshot";
        File file = new File(this.dir);
        file.mkdirs();
    }

    public String getSnapshot(DiamondAxis diamondAxis) throws IOException {
        return this.getFileContent(diamondAxis, ".diamond");
    }

    private String getFileContent(DiamondAxis diamondAxis, String extension) throws IOException {
        File file = new File(this.dir + File.separator + diamondAxis.getGroup() + File.separator + diamondAxis.getDataId() + extension);
        if (!file.exists()) {
            return null;
        }
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    public void saveSnaptshot(DiamondAxis diamondAxis, String content) {
        if (content == null) {
            return;
        }
        try {
            File file = this.getOrCreateDiamondFile(diamondAxis, ".diamond");
            FileUtils.writeStringToFile((File)file, (String)((String)StringUtils.defaultIfEmpty((CharSequence)content, (CharSequence)"")), (String)"UTF-8");
        }
        catch (IOException e) {
            this.log.error("save snapshot error {} by {}", new Object[]{diamondAxis, content, e});
        }
    }

    public void removeSnapshot(DiamondAxis diamondAxis) {
        this.removeSnapshot(diamondAxis, ".diamond");
    }

    private void removeSnapshot(DiamondAxis diamondAxis, String extension) {
        String path = this.dir + File.separator + diamondAxis.getGroup();
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        File file = new File(path + File.separator + diamondAxis.getDataId() + extension);
        if (!file.exists()) {
            return;
        }
        file.delete();
        if (dir.list().length == 0) {
            dir.delete();
        }
    }

    private void removeAllSnapshot(DiamondAxis diamondAxis, String extension) {
        File[] files;
        String path = this.dir + File.separator + diamondAxis.getGroup();
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        final String prefix = diamondAxis.getDataId() + extension;
        for (File file : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        })) {
            file.delete();
        }
        if (dir.list().length == 0) {
            dir.delete();
        }
    }

    private File getOrCreateDiamondFile(DiamondAxis diamondAxis, String extension) throws IOException {
        File file;
        String path = this.dir + File.separator + diamondAxis.getGroup();
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(file = new File(path + File.separator + diamondAxis.getDataId() + extension)).exists()) {
            file.createNewFile();
        }
        return file;
    }

    public void saveCache(DiamondAxis diamondAxis, Object diamondCache, int dynamicsHasCode) {
        String json = JSON.toJSONString((Object)diamondCache, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        try {
            File file = this.getOrCreateDiamondFile(diamondAxis, this.getDynamicCacheExtension(dynamicsHasCode));
            FileUtils.writeStringToFile((File)file, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            this.log.error("save {} cache snaptshot error", (Object)diamondAxis, (Object)e);
        }
    }

    public Optional<Object> getCache(DiamondAxis diamondAxis, int dynamicsHasCode) {
        try {
            String fileContent = this.getFileContent(diamondAxis, this.getDynamicCacheExtension(dynamicsHasCode));
            if (fileContent == null) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)JSON.parse((String)fileContent));
        }
        catch (IOException e) {
            this.log.error("read cache snapshot {} failed {}", (Object)e.getMessage());
            return null;
        }
    }

    public void removeCache(DiamondAxis diamondAxis, int dynamicsHasCode) {
        this.removeSnapshot(diamondAxis, this.getDynamicCacheExtension(dynamicsHasCode));
    }

    public void removeAllCache(DiamondAxis diamondAxis) {
        this.removeAllSnapshot(diamondAxis, ".cache.");
    }

    private String getDynamicCacheExtension(int dynamicsHasCode) {
        return ".cache." + UnsignedLongs.toString((long)dynamicsHasCode);
    }
}

