/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.loglevel;

import java.util.Enumeration;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.n3r.diamond.client.loglevel.LoggerLevel;
import org.n3r.diamond.client.loglevel.LoggerLevelChangable;

public class Log4jLevelChanger
implements LoggerLevelChangable {
    private Level transToLog4j(LoggerLevel loggerLevel) {
        switch (loggerLevel) {
            case OFF: {
                return Level.OFF;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case ALL: {
                return Level.ALL;
            }
        }
        throw new RuntimeException("should not reach here");
    }

    @Override
    public void changeAll(LoggerLevel loggerLevel) {
        Level newLevel = this.transToLog4j(loggerLevel);
        Enumeration currentLoggers = LogManager.getCurrentLoggers();
        while (currentLoggers.hasMoreElements()) {
            this.changeToNewLevel(newLevel, (Logger)currentLoggers.nextElement());
        }
        this.changeToNewLevel(newLevel, LogManager.getRootLogger());
    }

    @Override
    public void change(String loggerName, LoggerLevel loggerLevel) {
        Level newLevel = this.transToLog4j(loggerLevel);
        Logger logger = Logger.getLogger((String)loggerName);
        this.changeToNewLevel(newLevel, logger);
    }

    @Override
    public void changeSome(String loggerWildcard, LoggerLevel loggerLevel) {
        Logger logger;
        Level newLevel = this.transToLog4j(loggerLevel);
        Enumeration currentLoggers = LogManager.getCurrentLoggers();
        while (currentLoggers.hasMoreElements()) {
            logger = (Logger)currentLoggers.nextElement();
            if (!FilenameUtils.wildcardMatch((String)logger.getName(), (String)loggerWildcard)) continue;
            this.changeToNewLevel(newLevel, logger);
        }
        logger = LogManager.getRootLogger();
        if (FilenameUtils.wildcardMatch((String)logger.getName(), (String)loggerWildcard)) {
            this.changeToNewLevel(newLevel, logger);
        }
    }

    private void changeToNewLevel(Level newLevel, Logger logger) {
        if (logger.getLevel() == newLevel) {
            return;
        }
        logger.setLevel(newLevel);
    }
}

