/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.loglevel;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.joor.Reflect;
import org.n3r.diamond.client.loglevel.LoggerLevel;
import org.n3r.diamond.client.loglevel.LoggerLevelChangable;

public class LoggerLevelChanger
implements LoggerLevelChangable {
    private List<LoggerLevelChangable> impls = Lists.newArrayList();

    public LoggerLevelChanger() {
        LoggerLevelChangable changer;
        String changerClassName;
        try {
            ClassUtils.getClass((String)"org.apache.log4j.Logger", (boolean)false);
            changerClassName = "org.n3r.diamond.client.loglevel.Log4jLevelChanger";
            changer = (LoggerLevelChangable)Reflect.on((String)changerClassName).create().get();
            this.impls.add(changer);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            ClassUtils.getClass((String)"ch.qos.logback.classic.Logger", (boolean)false);
            changerClassName = "org.n3r.diamond.client.loglevel.LogbackLevelChanger";
            changer = (LoggerLevelChangable)Reflect.on((String)changerClassName).create().get();
            this.impls.add(changer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void changeAll(LoggerLevel loggerLevel) {
        for (LoggerLevelChangable impl : this.impls) {
            impl.changeAll(loggerLevel);
        }
    }

    @Override
    public void change(String loggerName, LoggerLevel loggerLevel) {
        for (LoggerLevelChangable impl : this.impls) {
            impl.change(loggerName, loggerLevel);
        }
    }

    @Override
    public void changeSome(String loggerWildcard, LoggerLevel loggerLevel) {
        for (LoggerLevelChangable impl : this.impls) {
            impl.changeSome(loggerWildcard, loggerLevel);
        }
    }
}

