/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.diamond.client.loglevel;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.DiamondAxis;
import org.n3r.diamond.client.DiamondExtender;
import org.n3r.diamond.client.DiamondListenerAdapter;
import org.n3r.diamond.client.DiamondStone;
import org.n3r.diamond.client.impl.DiamondUtils;
import org.n3r.diamond.client.loglevel.LoggerLevel;
import org.n3r.diamond.client.loglevel.LoggerLevelChanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerLevelChangerExtender
extends DiamondListenerAdapter
implements DiamondExtender {
    LoggerLevelChanger loggerLevelChanger = new LoggerLevelChanger();
    Logger logger = LoggerFactory.getLogger(LoggerLevelChangerExtender.class);

    @Override
    public DiamondAxis diamondAxis() {
        return DiamondAxis.makeAxis("diamond.extender", "logger.levels");
    }

    @Override
    public void accept(DiamondStone diamondStone) {
        Properties nameAndLevels = DiamondUtils.parseStoneToProperties(diamondStone.getContent());
        for (String loggerName : nameAndLevels.stringPropertyNames()) {
            String level = nameAndLevels.getProperty(loggerName);
            LoggerLevel loggerLevel = this.parseLoggerLevel(level);
            if (loggerLevel == null) continue;
            if ("_all_".equals(loggerName)) {
                this.loggerLevelChanger.changeAll(loggerLevel);
                continue;
            }
            if (loggerName.indexOf(42) >= 0 || loggerName.indexOf(63) >= 0) {
                String loggerWildcard = loggerName.substring(0, loggerName.length() - 1);
                this.loggerLevelChanger.changeSome(loggerWildcard, loggerLevel);
                continue;
            }
            this.loggerLevelChanger.change(loggerName, loggerLevel);
        }
    }

    private LoggerLevel parseLoggerLevel(String level) {
        if (StringUtils.isBlank((CharSequence)level)) {
            return null;
        }
        try {
            return LoggerLevel.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("log level {} is invalid", (Object)level);
            return null;
        }
    }
}

