/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.cache;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.DiamondMiner;
import org.n3r.eql.EqlPage;
import org.n3r.eql.cache.EqlCacheKey;
import org.n3r.eql.cache.EqlCacheProvider;
import org.n3r.eql.impl.EqlUniqueSqlId;

public class DiamondGuavaCacheProvider
implements EqlCacheProvider {
    public static final String EQL_CACHE = "EQL.CACHE";
    Cache<EqlUniqueSqlId, Cache<EqlCacheSubKey, Optional<Object>>> cache = CacheBuilder.newBuilder().build();
    Cache<EqlUniqueSqlId, Optional<String>> cacheDiamond = CacheBuilder.newBuilder().build();

    @Override
    public Optional<Object> getCache(EqlCacheKey cacheKey) {
        EqlUniqueSqlId uniqueSqlId = cacheKey.getUniqueSqlId();
        Optional cachedSqlIdVersion = (Optional)this.cacheDiamond.getIfPresent((Object)uniqueSqlId);
        if (cachedSqlIdVersion == null) {
            return null;
        }
        String sqlIdVersion = this.getSqlIdCacheVersion(uniqueSqlId);
        if (!StringUtils.equals((CharSequence)sqlIdVersion, (CharSequence)((CharSequence)cachedSqlIdVersion.orNull()))) {
            this.cache.invalidate((Object)uniqueSqlId);
            this.cacheDiamond.put((Object)uniqueSqlId, (Object)Optional.fromNullable((Object)sqlIdVersion));
            return null;
        }
        Cache subCache = (Cache)this.cache.getIfPresent((Object)uniqueSqlId);
        if (subCache == null) {
            return null;
        }
        return (Optional)subCache.getIfPresent((Object)new EqlCacheSubKey(cacheKey));
    }

    @Override
    public void setCache(EqlCacheKey cacheKey, Object result) {
        final EqlUniqueSqlId uniqueSqlId = cacheKey.getUniqueSqlId();
        try {
            Cache subCache = (Cache)this.cache.get((Object)uniqueSqlId, (Callable)new Callable<Cache<EqlCacheSubKey, Optional<Object>>>(){

                @Override
                public Cache<EqlCacheSubKey, Optional<Object>> call() throws Exception {
                    String sqlIdVersion = DiamondGuavaCacheProvider.this.getSqlIdCacheVersion(uniqueSqlId);
                    DiamondGuavaCacheProvider.this.cacheDiamond.put((Object)uniqueSqlId, (Object)Optional.fromNullable((Object)sqlIdVersion));
                    Cache subCache = CacheBuilder.newBuilder().build();
                    return subCache;
                }
            });
            subCache.put((Object)new EqlCacheSubKey(cacheKey), (Object)Optional.fromNullable((Object)result));
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    private String getSqlIdCacheVersion(EqlUniqueSqlId uniqueSqlId) {
        String dataId = uniqueSqlId.getSqlClassPath().replaceAll("/", ".");
        Properties sqlFileProperties = DiamondMiner.getProperties((String)EQL_CACHE, (String)dataId);
        String key = uniqueSqlId.getSqlId() + ".cacheVersion";
        String property = sqlFileProperties.getProperty(key);
        return property;
    }

    static class EqlCacheSubKey {
        private Object[] params;
        private Object[] dynamics;
        private EqlPage page;

        EqlCacheSubKey(EqlCacheKey cacheKey) {
            this.params = cacheKey.getParams();
            this.dynamics = cacheKey.getDynamics();
            this.page = cacheKey.getPage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqlCacheSubKey that = (EqlCacheSubKey)o;
            if (!Arrays.equals(this.dynamics, that.dynamics)) {
                return false;
            }
            if (this.page != null ? !this.page.equals(that.page) : that.page != null) {
                return false;
            }
            return Arrays.equals(this.params, that.params);
        }

        public int hashCode() {
            int result = this.params != null ? Arrays.hashCode(this.params) : 0;
            result = 31 * result + (this.dynamics != null ? Arrays.hashCode(this.dynamics) : 0);
            result = 31 * result + (this.page != null ? this.page.hashCode() : 0);
            return result;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }

        public Object[] getDynamics() {
            return this.dynamics;
        }

        public void setDynamics(Object[] dynamics) {
            this.dynamics = dynamics;
        }

        public EqlPage getPage() {
            return this.page;
        }

        public void setPage(EqlPage page) {
            this.page = page;
        }
    }
}

