/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMergeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSensitiveFieldsParser
implements SensitiveFieldsParser {
    private final Logger log = LoggerFactory.getLogger(OracleSensitiveFieldsParser.class);
    private final Map<String, Object> aliasTablesMap = Maps.newHashMap();
    private final Set<Integer> securetBindIndice = Sets.newHashSet();
    private final Set<Integer> securetResultIndice = Sets.newHashSet();
    private final Set<String> securetResultLabels = Sets.newHashSet();
    private final List<BindVariant> subQueryBindAndVariantOfFrom = Lists.newArrayList();
    private final Set<String> securetFields;
    private int variantIndex = 0;
    private final String sql;
    private OracleASTVisitorAdapter adapter = new OracleASTVisitorAdapter(){

        public boolean visit(SQLVariantRefExpr x) {
            ++OracleSensitiveFieldsParser.this.variantIndex;
            return true;
        }

        public boolean visit(SQLBinaryOpExpr x) {
            if (this.hasSecuretField(x.getLeft())) {
                OracleSensitiveFieldsParser.this.checkOnlyOneAsk(x.getRight());
            } else if (this.hasSecuretField(x.getRight())) {
                OracleSensitiveFieldsParser.this.checkOnlyOneAsk(x.getLeft());
            }
            return true;
        }

        private boolean hasSecuretField(SQLExpr field) {
            return field instanceof SQLIdentifierExpr && OracleSensitiveFieldsParser.this.isSecuretField((SQLIdentifierExpr)field) || field instanceof SQLPropertyExpr && OracleSensitiveFieldsParser.this.isSecuretField((SQLPropertyExpr)field);
        }
    };
    private static Pattern encryptHint = Pattern.compile("\\s*/\\*{3}\\s*(.*?)\\s*\\*{3}/");
    private static Pattern bindPattern = Pattern.compile("bind\\s*\\((.*?)\\)");
    private static Pattern resultPattern = Pattern.compile("result\\s*\\((.*?)\\)");
    private static Splitter indexSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();

    private static OracleSensitiveFieldsParser tryParseHint(String sql, Set<String> securetFields) {
        OracleSensitiveFieldsParser fieldsParser = null;
        Matcher matcher = encryptHint.matcher(sql);
        if (matcher.find() && matcher.start() == 0) {
            String convertedSql = sql.substring(matcher.end());
            String hint = matcher.group(1);
            fieldsParser = new OracleSensitiveFieldsParser(securetFields, convertedSql);
            fieldsParser.parseHint(hint);
        }
        return fieldsParser;
    }

    public static OracleSensitiveFieldsParser parseOracleSql(String sql, Set<String> securetFields) {
        OracleSensitiveFieldsParser fieldsParser = OracleSensitiveFieldsParser.tryParseHint(sql, securetFields);
        if (fieldsParser == null) {
            SQLStatement sqlStatement = OracleSensitiveFieldsParser.parseSql(sql);
            fieldsParser = new OracleSensitiveFieldsParser(securetFields, sql);
            fieldsParser = OracleSensitiveFieldsParser.parseStatement(fieldsParser, sqlStatement);
        }
        if (fieldsParser == null) {
            return null;
        }
        if (fieldsParser.haveNotSecureFields()) {
            return null;
        }
        return fieldsParser;
    }

    private static OracleSensitiveFieldsParser parseStatement(OracleSensitiveFieldsParser parser, SQLStatement sqlStatement) {
        if (sqlStatement instanceof SQLSelectStatement) {
            parser.parseSelectQuery(((SQLSelectStatement)sqlStatement).getSelect().getQuery());
        } else if (sqlStatement instanceof OracleDeleteStatement) {
            parser.parseDelete((OracleDeleteStatement)sqlStatement);
        } else if (sqlStatement instanceof OracleInsertStatement) {
            parser.parseInsert((SQLInsertInto)((OracleInsertStatement)sqlStatement));
        } else if (sqlStatement instanceof OracleUpdateStatement) {
            parser.parseUpdate((OracleUpdateStatement)sqlStatement);
        } else if (sqlStatement instanceof OracleMergeStatement) {
            parser.parseMerge((OracleMergeStatement)sqlStatement);
        } else if (sqlStatement instanceof SQLCallStatement) {
            parser.parseCall((SQLCallStatement)sqlStatement);
        } else if (sqlStatement instanceof OracleMultiInsertStatement) {
            parser.parseMultiInsert((OracleMultiInsertStatement)sqlStatement);
        }
        return parser;
    }

    private void parseSelectQuery(SQLSelectQuery query) {
        if (query instanceof SQLSelectQueryBlock) {
            this.parseQuery((SQLSelectQueryBlock)query);
        } else if (query instanceof SQLUnionQuery) {
            this.parseUnionQuery((SQLUnionQuery)query);
        }
    }

    private static SQLStatement parseSql(String sql) {
        List stmtList;
        OracleStatementParser parser = new OracleStatementParser(sql);
        try {
            stmtList = parser.parseStatementList();
        }
        catch (ParserException exception) {
            exception.printStackTrace();
            throw new RuntimeException(sql + " is invalid, detail " + exception.getMessage());
        }
        return (SQLStatement)stmtList.get(0);
    }

    private OracleSensitiveFieldsParser(Set<String> securetFields, String sql) {
        this.securetFields = securetFields;
        this.sql = sql;
    }

    private void parseHint(String hint) {
        Matcher matcher = bindPattern.matcher(hint);
        if (matcher.find()) {
            Iterable bindIndices = indexSplitter.split((CharSequence)matcher.group(1));
            for (String bindIndex : bindIndices) {
                this.securetBindIndice.add(Integer.parseInt(bindIndex));
            }
        }
        if ((matcher = resultPattern.matcher(hint)).find()) {
            Iterable resultIndices = indexSplitter.split((CharSequence)matcher.group(1));
            for (String resultIndex : resultIndices) {
                this.securetResultIndice.add(Integer.parseInt(resultIndex));
            }
        }
    }

    private void parseUnionQuery(SQLUnionQuery sqlUnionQuery) {
        SQLSelectQuery left = sqlUnionQuery.getLeft();
        this.parseQuery((SQLSelectQueryBlock)left);
        SQLSelectQuery right = sqlUnionQuery.getRight();
        if (right instanceof SQLUnionQuery) {
            this.parseUnionQuery((SQLUnionQuery)right);
        } else {
            this.parseQuery((SQLSelectQueryBlock)right);
        }
    }

    private void parseQuery(SQLSelectQueryBlock queryBlock) {
        this.parseTable(queryBlock.getFrom());
        this.parseSelectItems(queryBlock.getSelectList());
        this.adjustSubQeuryBindIndiceOfFrom();
        if (queryBlock.getWhere() != null) {
            queryBlock.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void adjustSubQeuryBindIndiceOfFrom() {
        for (BindVariant bindVariant : this.subQueryBindAndVariantOfFrom) {
            for (Integer index : bindVariant.getBindIndice()) {
                this.securetBindIndice.add(this.variantIndex + index);
            }
            this.variantIndex += bindVariant.getVariantIndex().intValue();
        }
    }

    private void parseDelete(OracleDeleteStatement deleteStatement) {
        SQLExprTableSource tableSource = (SQLExprTableSource)deleteStatement.getTableSource();
        if (tableSource.getExpr() instanceof SQLIdentifierExpr) {
            this.addTableAlias((SQLTableSource)tableSource, (SQLIdentifierExpr)tableSource.getExpr());
        }
        if (deleteStatement.getWhere() != null) {
            deleteStatement.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void parseCall(SQLCallStatement callStatement) {
        boolean isOraFunc;
        this.addTableAlias("", callStatement.getProcedureName().toString());
        boolean bl = isOraFunc = callStatement.getOutParameter() != null;
        if (isOraFunc && this.isSecuretField(1)) {
            this.securetBindIndice.add(1);
        }
        List parameters = callStatement.getParameters();
        int ii = parameters.size();
        for (int i = 0; i < ii; ++i) {
            SQLExpr parameter = (SQLExpr)parameters.get(i);
            parameter.accept((SQLASTVisitor)this.adapter);
            int paramIndex = i + 1 + (isOraFunc ? 1 : 0);
            if (!this.isSecuretField(paramIndex)) continue;
            if (parameter instanceof SQLVariantRefExpr) {
                this.securetBindIndice.add(this.variantIndex + (isOraFunc ? 1 : 0));
                continue;
            }
            this.log.warn("securet field is not passed as a single value in sql [" + this.sql + "]");
        }
    }

    private void parseMerge(OracleMergeStatement mergeStatement) {
        OracleMergeStatement.MergeInsertClause insertClause;
        if (mergeStatement.getInto() instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr expr = (SQLIdentifierExpr)mergeStatement.getInto();
            this.addTableAlias(mergeStatement.getAlias(), expr);
        }
        mergeStatement.getOn().accept((SQLASTVisitor)this.adapter);
        OracleMergeStatement.MergeUpdateClause updateClause = mergeStatement.getUpdateClause();
        if (updateClause != null) {
            List items = updateClause.getItems();
            this.walkUpdateItems(items);
        }
        if ((insertClause = mergeStatement.getInsertClause()) != null) {
            List<Integer> securetFieldsIndice = this.walkInsertColumns(insertClause.getColumns());
            this.walkInsertValues(securetFieldsIndice, insertClause.getValues());
        }
    }

    private void parseUpdate(OracleUpdateStatement updateStatement) {
        OracleSelectTableReference tableSource = (OracleSelectTableReference)updateStatement.getTableSource();
        if (tableSource.getExpr() instanceof SQLIdentifierExpr) {
            this.addTableAlias((SQLTableSource)tableSource, (SQLIdentifierExpr)tableSource.getExpr());
        }
        List items = updateStatement.getItems();
        SQLUpdateSetItem item0 = (SQLUpdateSetItem)items.get(0);
        if (items.size() == 1 && item0.getColumn() instanceof SQLListExpr && item0.getValue() instanceof SQLQueryExpr) {
            this.walkUpdateSelect(item0);
        } else {
            this.walkUpdateItems(items);
        }
        if (updateStatement.getWhere() != null) {
            updateStatement.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void walkUpdateSelect(SQLUpdateSetItem item) {
        SQLListExpr sqlListExpr = (SQLListExpr)item.getColumn();
        List items = sqlListExpr.getItems();
        HashSet securiteFieldIndice = Sets.newHashSet();
        int ii = items.size();
        for (int i = 0; i < ii; ++i) {
            SQLExpr expr = (SQLExpr)items.get(i);
            if (!(expr instanceof SQLPropertyExpr) || !this.isSecuretField((SQLPropertyExpr)expr)) continue;
            securiteFieldIndice.add(i);
        }
        SQLQueryExpr value = (SQLQueryExpr)item.getValue();
        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)value.getSubQuery().getQuery();
        this.parseTable(queryBlock.getFrom());
        this.parseSelectItemsInUpdate(securiteFieldIndice, queryBlock.getSelectList());
        if (queryBlock.getWhere() != null) {
            queryBlock.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void parseSelectItemsInUpdate(Set<Integer> securetFieldIndice, List<SQLSelectItem> selectList) {
        int ii = selectList.size();
        for (int i = 0; i < ii; ++i) {
            SQLSelectItem item = selectList.get(i);
            item.accept((SQLASTVisitor)this.adapter);
            if (!securetFieldIndice.contains(i) || !(item.getExpr() instanceof SQLVariantRefExpr)) continue;
            this.securetBindIndice.add(this.variantIndex);
        }
    }

    private void walkUpdateItems(List<SQLUpdateSetItem> items) {
        int ii = items.size();
        for (int i = 0; i < ii; ++i) {
            SQLUpdateSetItem item = items.get(i);
            item.accept((SQLASTVisitor)this.adapter);
            boolean isSecuretField = false;
            if (item.getColumn() instanceof SQLPropertyExpr) {
                SQLPropertyExpr expr = (SQLPropertyExpr)item.getColumn();
                isSecuretField = this.isSecuretField(expr);
            } else if (item.getColumn() instanceof SQLIdentifierExpr) {
                isSecuretField = this.isSecuretField((SQLIdentifierExpr)item.getColumn());
            }
            if (!isSecuretField) continue;
            if (item.getValue() instanceof SQLVariantRefExpr) {
                this.securetBindIndice.add(this.variantIndex);
                continue;
            }
            this.log.warn("securet field is not updated as a single value in sql [" + this.sql + "]");
        }
    }

    private void checkOnlyOneAsk(SQLExpr right) {
        final AtomicInteger rightVariantIndex = new AtomicInteger(0);
        right.accept((SQLASTVisitor)new OracleASTVisitorAdapter(){

            public boolean visit(SQLVariantRefExpr x) {
                rightVariantIndex.incrementAndGet();
                return true;
            }
        });
        if (rightVariantIndex.get() == 1) {
            this.securetBindIndice.add(this.variantIndex + 1);
        }
    }

    private boolean isSecuretField(SQLAllColumnExpr field) {
        Object oneTableName = this.getOneTableName();
        return oneTableName != null && this.containsInSecuretFields(oneTableName, "*");
    }

    private boolean isSecuretField(SQLIdentifierExpr field) {
        Object oneTableName = this.getOneTableName();
        return oneTableName != null && this.containsInSecuretFields(oneTableName, field.getName());
    }

    private boolean isSecuretField(SQLPropertyExpr expr) {
        Object tableName = this.aliasTablesMap.get(expr.getOwner().toString());
        String fieldName = expr.getName();
        return this.containsInSecuretFields(tableName, fieldName);
    }

    private boolean containsInSecuretFields(Object tableName, String fieldName) {
        if (tableName instanceof String) {
            return this.containsInSecuretFields((String)tableName, fieldName);
        }
        if (tableName instanceof OracleSensitiveFieldsParser) {
            return this.containsInSecuretFields((OracleSensitiveFieldsParser)tableName, fieldName);
        }
        return false;
    }

    private boolean containsInSecuretFields(OracleSensitiveFieldsParser parser, String fieldName) {
        return "*".equals(fieldName) ? !parser.getSecuretResultIndice().isEmpty() : parser.inResultLables(fieldName);
    }

    private boolean containsInSecuretFields(String tableName, String fieldName) {
        String secretField = tableName + "." + fieldName;
        return this.securetFields.contains(secretField.toUpperCase());
    }

    private boolean isSecuretField(int procedureParameterIndex) {
        Object oneTableName = this.getOneTableName();
        return oneTableName != null && this.containsInSecuretFields(oneTableName, "" + procedureParameterIndex);
    }

    private Object getOneTableName() {
        Iterator<Map.Entry<String, Object>> i$;
        if (this.aliasTablesMap.size() == 1 && (i$ = this.aliasTablesMap.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Object> entry = i$.next();
            return entry.getValue();
        }
        return null;
    }

    private void parseTable(SQLTableSource from) {
        if (from instanceof OracleSelectTableReference) {
            SQLExprTableSource source = (SQLExprTableSource)from;
            if (source.getExpr() instanceof SQLIdentifierExpr) {
                this.addTableAlias(from, (SQLIdentifierExpr)source.getExpr());
            }
        } else if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource = (SQLJoinTableSource)from;
            this.parseTable(joinTableSource.getLeft());
            this.parseTable(joinTableSource.getRight());
            SQLExpr conditionOn = joinTableSource.getCondition();
            if (conditionOn != null) {
                conditionOn.accept((SQLASTVisitor)this.adapter);
            }
        } else if (from instanceof OracleSelectSubqueryTableSource) {
            OracleSelectSubqueryTableSource tableSource = (OracleSelectSubqueryTableSource)from;
            SQLSelectQuery query = tableSource.getSelect().getQuery();
            OracleSensitiveFieldsParser subParser = this.createSubQueryParser(query, QueryBelongs.FROM);
            this.addTableAlias(from, subParser);
        }
    }

    private void addTableAlias(SQLTableSource from, OracleSensitiveFieldsParser subParser) {
        this.addTableAlias(from.getAlias(), subParser);
    }

    private void addTableAlias(SQLTableSource from, SQLIdentifierExpr expr) {
        this.addTableAlias(from.getAlias(), expr);
    }

    private void addTableAlias(String alias, SQLIdentifierExpr expr) {
        this.addTableAlias(alias, expr.getName());
    }

    private void addTableAlias(String alias, String tableName) {
        this.aliasTablesMap.put((String)Objects.firstNonNull((Object)alias, (Object)tableName), tableName);
    }

    private void addTableAlias(String alias, OracleSensitiveFieldsParser subParser) {
        this.aliasTablesMap.put(alias, subParser);
    }

    private String cleanQuotes(String str) {
        if (str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"' || str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private void parseSelectItems(List<SQLSelectItem> sqlSelectItems) {
        int ii = sqlSelectItems.size();
        for (int itemIndex = 0; itemIndex < ii; ++itemIndex) {
            SQLSelectQuery subQuery;
            OracleSensitiveFieldsParser subParser;
            SQLIdentifierExpr expr;
            SQLSelectItem item = sqlSelectItems.get(itemIndex);
            String alias = item.getAlias();
            if (item.getExpr() instanceof SQLIdentifierExpr) {
                expr = (SQLIdentifierExpr)item.getExpr();
                if (!this.isSecuretField(expr)) continue;
                this.securetResultIndice.add(itemIndex + 1);
                this.securetResultLabels.add(this.cleanQuotes(alias == null ? expr.getName() : alias));
                continue;
            }
            if (item.getExpr() instanceof SQLPropertyExpr) {
                expr = (SQLPropertyExpr)item.getExpr();
                if (!this.isSecuretField((SQLPropertyExpr)expr)) continue;
                if ("*".equals(expr.getName())) {
                    Object tableName = this.aliasTablesMap.get(expr.getOwner().toString());
                    this.copyResultIndiceAndLables(itemIndex, tableName);
                    continue;
                }
                this.securetResultIndice.add(itemIndex + 1);
                this.securetResultLabels.add(this.cleanQuotes(alias == null ? expr.getName() : alias));
                continue;
            }
            if (item.getExpr() instanceof SQLAllColumnExpr) {
                if (!this.isSecuretField((SQLAllColumnExpr)item.getExpr())) continue;
                Object tableName = this.getOneTableName();
                this.copyResultIndiceAndLables(itemIndex, tableName);
                continue;
            }
            if (!(item.getExpr() instanceof SQLQueryExpr) || !(subParser = this.createSubQueryParser(subQuery = (expr = (SQLQueryExpr)item.getExpr()).getSubQuery().getQuery(), QueryBelongs.SELECT)).inResultIndice(1)) continue;
            this.securetResultIndice.add(itemIndex + 1);
            Set<String> labels = subParser.getSecuretResultLabels();
            this.securetResultLabels.add(this.cleanQuotes(alias == null ? labels.iterator().next() : alias));
        }
    }

    private void copyResultIndiceAndLables(int itemIndex, Object tableName) {
        if (tableName instanceof OracleSensitiveFieldsParser) {
            OracleSensitiveFieldsParser parser = (OracleSensitiveFieldsParser)tableName;
            for (Integer resultIndex : parser.getSecuretResultIndice()) {
                this.securetResultIndice.add(resultIndex + itemIndex);
            }
            this.securetResultLabels.addAll(parser.getSecuretResultLabels());
        }
    }

    private OracleSensitiveFieldsParser createSubQueryParser(SQLSelectQuery subQuery, QueryBelongs mode) {
        OracleSensitiveFieldsParser subParser = new OracleSensitiveFieldsParser(this.securetFields, this.sql);
        subParser.parseSelectQuery(subQuery);
        switch (mode) {
            case FROM: {
                BindVariant bindAndVariant = new BindVariant(subParser.getVariantIndex(), subParser.getSecuretBindIndice());
                this.subQueryBindAndVariantOfFrom.add(bindAndVariant);
                break;
            }
            case SELECT: {
                for (Integer index : subParser.getSecuretBindIndice()) {
                    this.securetBindIndice.add(this.variantIndex + index);
                }
                this.variantIndex += subParser.getVariantIndex();
            }
        }
        return subParser;
    }

    private void parseMultiInsert(OracleMultiInsertStatement multiInsertStatement) {
        List entries = multiInsertStatement.getEntries();
        for (OracleMultiInsertStatement.Entry entry : entries) {
            this.parseInsert((SQLInsertInto)((OracleMultiInsertStatement.InsertIntoClause)entry));
        }
    }

    private void parseInsert(SQLInsertInto x) {
        SQLExprTableSource tableSource = x.getTableSource();
        if (tableSource.getExpr() instanceof SQLIdentifierExpr) {
            this.addTableAlias((SQLTableSource)tableSource, (SQLIdentifierExpr)tableSource.getExpr());
        }
        List columns = x.getColumns();
        List<Integer> securetFieldsIndice = this.walkInsertColumns(columns);
        SQLInsertStatement.ValuesClause valuesClause = x.getValues();
        if (valuesClause != null) {
            List values = valuesClause.getValues();
            this.walkInsertValues(securetFieldsIndice, values);
        } else if (x.getQuery() != null) {
            SQLSelect query = x.getQuery();
            this.parseQuery4Insert(securetFieldsIndice, (SQLSelectQueryBlock)query.getQuery());
        }
    }

    private void parseQuery4Insert(List<Integer> securetFieldsIndice, SQLSelectQueryBlock queryBlock) {
        List selectList = queryBlock.getSelectList();
        int ii = selectList.size();
        for (int itemIndex = 0; itemIndex < ii; ++itemIndex) {
            SQLSelectItem item = (SQLSelectItem)selectList.get(itemIndex);
            item.accept((SQLASTVisitor)this.adapter);
            if (!securetFieldsIndice.contains(itemIndex) || !(item.getExpr() instanceof SQLVariantRefExpr)) continue;
            this.securetBindIndice.add(this.variantIndex);
        }
        queryBlock.getFrom().accept((SQLASTVisitor)this.adapter);
        this.parseTable(queryBlock.getFrom());
        if (queryBlock.getWhere() != null) {
            queryBlock.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void walkInsertValues(List<Integer> securetFieldsIndice, List<SQLExpr> values) {
        int ii = values.size();
        for (int i = 0; i < ii; ++i) {
            SQLExpr expr = values.get(i);
            expr.accept((SQLASTVisitor)this.adapter);
            if (!securetFieldsIndice.contains(i)) continue;
            if (expr instanceof SQLVariantRefExpr) {
                this.securetBindIndice.add(this.variantIndex);
                continue;
            }
            this.log.warn("securet field is not inserted as a single value in sql [" + this.sql + "]");
        }
    }

    private List<Integer> walkInsertColumns(List<SQLExpr> columns) {
        ArrayList securetFieldsIndice = Lists.newArrayList();
        int ii = columns.size();
        for (int i = 0; i < ii; ++i) {
            SQLIdentifierExpr expr;
            SQLExpr column = columns.get(i);
            if (!(column instanceof SQLIdentifierExpr) || !this.isSecuretField(expr = (SQLIdentifierExpr)column)) continue;
            securetFieldsIndice.add(i);
        }
        return securetFieldsIndice;
    }

    @Override
    public Set<Integer> getSecuretBindIndice() {
        return this.securetBindIndice;
    }

    @Override
    public Set<Integer> getSecuretResultIndice() {
        return this.securetResultIndice;
    }

    @Override
    public Set<String> getSecuretResultLabels() {
        return this.securetResultLabels;
    }

    @Override
    public boolean inBindIndice(int index) {
        return this.getSecuretBindIndice().contains(index);
    }

    @Override
    public boolean inResultIndice(int index) {
        return this.getSecuretResultIndice().contains(index);
    }

    @Override
    public boolean inResultLables(String label) {
        return this.getSecuretResultLabels().contains(label);
    }

    @Override
    public boolean inResultIndiceOrLabel(Object indexOrLabel) {
        return this.getSecuretResultIndice().contains(indexOrLabel) || this.getSecuretResultLabels().contains(indexOrLabel);
    }

    @Override
    public boolean haveNotSecureFields() {
        return this.securetResultLabels.isEmpty() && this.securetResultIndice.isEmpty() && this.securetBindIndice.isEmpty();
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public int getVariantIndex() {
        return this.variantIndex;
    }

    static class BindVariant {
        private Integer variantIndex;
        private Set<Integer> bindIndice;

        public BindVariant(Integer variantIndex, Set<Integer> bindIndice) {
            this.variantIndex = variantIndex;
            this.bindIndice = bindIndice;
        }

        public Integer getVariantIndex() {
            return this.variantIndex;
        }

        public Set<Integer> getBindIndice() {
            return this.bindIndice;
        }
    }

    static enum QueryBelongs {
        FROM,
        SELECT;

    }
}

