/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.refer.aes;

import com.google.common.base.Throwables;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.n3r.eql.dbfieldcryptor.refer.aes.BaseCryptor;
import org.n3r.eql.util.S;

public class AesCryptor
extends BaseCryptor {
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    public AesCryptor() {
        this.initCipher();
    }

    public AesCryptor(String key) {
        super(key);
        this.initCipher();
    }

    private void initCipher() {
        try {
            byte[] rawkey = S.alignRight(this.getKey(), 16, 'L').getBytes("UTF-8");
            SecretKeySpec key1 = new SecretKeySpec(rawkey, "AES");
            this.encryptCipher = Cipher.getInstance("AES");
            this.encryptCipher.init(1, key1);
            this.decryptCipher = Cipher.getInstance("AES");
            this.decryptCipher.init(2, key1);
        }
        catch (Throwable e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected Cipher getCipher(boolean isEncrypt) {
        return isEncrypt ? this.encryptCipher : this.decryptCipher;
    }
}

