/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.n3r.eql.Eql;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.util.Closes;

public class EqlBatch {
    private Eql eql;
    private int maxBatches;
    private int currentBatches;
    private int totalBatches;
    private List<PreparedStatement> batchedPs;
    private Map<String, PreparedStatement> batchedMap;

    public EqlBatch(Eql eql) {
        this.eql = eql;
    }

    public void startBatch(int maxBatches) {
        this.maxBatches = maxBatches;
        this.batchedPs = Lists.newArrayList();
        this.batchedMap = Maps.newHashMap();
    }

    public int addBatch(EqlRun eqlRun) throws SQLException {
        PreparedStatement ps = this.batchedMap.get(eqlRun.getRunSql());
        if (ps == null) {
            ps = this.eql.prepareSql(eqlRun);
            this.batchedMap.put(eqlRun.getRunSql(), ps);
            this.batchedPs.add(ps);
        }
        eqlRun.bindParams(ps);
        ps.addBatch();
        ++this.currentBatches;
        return this.maxBatches > 0 && this.currentBatches >= this.maxBatches ? this.executeBatch(false) : 0;
    }

    public int executeBatch() throws SQLException {
        return this.executeBatch(true);
    }

    public int executeBatch(boolean cleanup) throws SQLException {
        try {
            int totalRowCount = 0;
            for (PreparedStatement ps : this.batchedPs) {
                int[] rowCounts = ps.executeBatch();
                for (int j = 0; j < rowCounts.length; ++j) {
                    if (rowCounts[j] == -2) continue;
                    if (rowCounts[j] == -3) {
                        throw new EqlExecuteException("The batched statement at index " + j + " failed to execute.");
                    }
                    totalRowCount += rowCounts[j];
                }
            }
            this.totalBatches += totalRowCount;
            this.currentBatches = 0;
            int n = this.totalBatches;
            return n;
        }
        catch (SQLException ex) {
            this.cleanupBatch();
            throw ex;
        }
        finally {
            if (cleanup) {
                this.cleanupBatch();
            }
        }
    }

    public void cleanupBatch() {
        for (PreparedStatement ps : this.batchedPs) {
            Closes.closeQuietly(ps);
        }
        this.batchedPs.clear();
    }
}

