/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import org.n3r.diamond.client.DiamondMiner;
import org.n3r.eql.Eql;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.config.EqlConfigCache;
import org.n3r.eql.config.EqlPropertiesConfig;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.matrix.sqlparser.MatrixSqlParserUtils;
import org.n3r.eql.param.EqlParamsBinder;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.C;

public class Mql
extends Eql {
    public Mql() {
        super(Mql.autoDetect("config"), 4);
    }

    public Mql(String key) {
        super(Mql.autoDetect(key), 4);
    }

    public Mql(EqlConfig config) {
        super(config, 4);
    }

    private static EqlConfig autoDetect(String connName) {
        String classPath = "eql/eql-matrix.properties";
        if (C.classResourceExists(classPath)) {
            return EqlConfigCache.getEqlConfig("matrix");
        }
        Properties eqlConfig = DiamondMiner.getProperties((String)"eql.matrix", (String)connName);
        return new EqlPropertiesConfig(eqlConfig);
    }

    @Override
    public <T> T execute(String ... directSqls) {
        if (this.batch != null) {
            throw new EqlExecuteException("batch is not supported");
        }
        this.checkPreconditions(directSqls);
        this.newExecutionContext();
        Object ret = null;
        try {
            if (directSqls.length > 0) {
                this.eqlBlock = new EqlBlock();
            }
            this.eqlRuns = this.eqlBlock.createEqlRuns(this.eqlConfig, this.executionContext, this.params, this.dynamics, directSqls);
            if (this.eqlRuns.size() > 1) {
                throw new EqlExecuteException("multiple sqls are not supported");
            }
            Iterator i$ = this.eqlRuns.iterator();
            while (i$.hasNext()) {
                EqlRun eqlRun;
                this.currRun = eqlRun = (EqlRun)i$.next();
                new EqlParamsBinder().preparBindParams(this.currRun);
                MatrixSqlParserUtils.parse(this.eqlConfig, eqlRun);
                this.tranStart();
                Connection conn = this.getConn();
                this.currRun.setConnection(conn);
                ret = this.runEql();
                this.currRun.setConnection(null);
                this.updateLastResultToExecutionContext(ret);
                this.currRun.setResult(ret);
            }
            this.tranCommit();
        }
        catch (SQLException e) {
            logger.error("sql exception", (Throwable)e);
            throw new EqlExecuteException("exec sql failed[" + this.currRun.getPrintSql() + "]" + e.getMessage());
        }
        finally {
            this.resetState();
            this.close();
        }
        return (T)ret;
    }
}

