/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix.mapper;

import com.google.common.collect.Lists;
import java.util.List;
import org.n3r.eql.matrix.RealPartition;
import org.n3r.eql.matrix.impl.GotoRealPartition;
import org.n3r.eql.matrix.impl.MatrixMapper;
import org.n3r.eql.util.S;

public class DefaultMatrixMapper
implements MatrixMapper {
    private String defaultValue;
    private List<MapCase> mapCases = Lists.newArrayList();
    private int gotoAnotherRule = -1;

    @Override
    public RealPartition map(String value) {
        for (MapCase mapCase : this.mapCases) {
            if (!mapCase.left.equals(value)) continue;
            return RealPartition.parse(mapCase.right);
        }
        if (this.gotoAnotherRule >= 0) {
            return new GotoRealPartition(this.gotoAnotherRule);
        }
        return RealPartition.parse(this.defaultValue.replaceAll("\\$", value));
    }

    @Override
    public void config(List<String> mapperParams) {
        int size = mapperParams.size();
        if (size == 0) {
            throw new RuntimeException("mapper is invalid");
        }
        int ii = size;
        for (int i = 0; i < ii; ++i) {
            String mapCase = mapperParams.get(i);
            int colonPos = mapCase.indexOf(58);
            if (colonPos < 0) {
                if (i == ii - 1) {
                    if (mapCase.startsWith("rule->")) {
                        this.gotoAnotherRule = Integer.parseInt(mapCase.substring("rule->".length()));
                        break;
                    }
                    this.defaultValue = mapCase;
                    break;
                }
                throw new RuntimeException("mapper is invalid");
            }
            if (colonPos == 0 || colonPos == mapCase.length() - 1) {
                throw new RuntimeException("mapper is invalid");
            }
            String left = mapCase.substring(0, colonPos);
            String right = S.trimLeft(mapCase.substring(colonPos + 1));
            this.mapCases.add(new MapCase(left, right));
        }
    }

    private static class MapCase {
        public final String left;
        public final String right;

        public MapCase(String left, String right) {
            this.left = left;
            this.right = right;
        }
    }
}

