/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.param;

import com.google.common.base.Objects;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.util.Names;
import org.n3r.eql.util.S;

public class EqlParamsBinder {
    private EqlRun eqlRun;
    private StringBuilder boundParams;

    public void preparBindParams(EqlRun eqlRun) {
        this.eqlRun = eqlRun;
        this.boundParams = new StringBuilder();
        switch (eqlRun.getPlaceHolderType()) {
            case AUTO_SEQ: {
                for (int i = 0; i < eqlRun.getPlaceholderNum(); ++i) {
                    this.setParam(i, this.getParamByIndex(i), ParamExtra.Normal);
                }
                break;
            }
            case MANU_SEQ: {
                for (int i = 0; i < eqlRun.getPlaceholderNum(); ++i) {
                    this.setParam(i, this.findParamBySeq(i + 1), ParamExtra.Normal);
                }
                break;
            }
            case VAR_NAME: {
                for (int i = 0; i < eqlRun.getPlaceholderNum(); ++i) {
                    this.setParam(i, this.findParamByName(i), ParamExtra.Normal);
                }
                break;
            }
        }
        this.bindExtraParams();
        eqlRun.setBoundParams(this.boundParams.toString());
    }

    private void bindExtraParams() {
        Object[] extraBindParams = this.eqlRun.getExtraBindParams();
        if (extraBindParams == null) {
            return;
        }
        for (int i = this.eqlRun.getPlaceholderNum(); i < this.eqlRun.getPlaceholderNum() + extraBindParams.length; ++i) {
            this.setParam(i, extraBindParams[i - this.eqlRun.getPlaceholderNum()], ParamExtra.Extra);
        }
    }

    private void setParam(int index, Object value, ParamExtra extra) {
        EqlParamPlaceholder placeHolder = this.eqlRun.getPlaceHolder(index);
        try {
            switch (extra) {
                case Extra: {
                    this.setParamExtra(placeHolder, index, value);
                    break;
                }
                default: {
                    this.setParamEx(placeHolder, index, value);
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new EqlExecuteException("set parameters fail", e);
        }
    }

    private void setParamExtra(EqlParamPlaceholder placeHolder, int index, Object value) throws SQLException {
        if (value instanceof Date) {
            Timestamp date = new Timestamp(((Date)value).getTime());
            this.boundParams.append('[').append(S.toDateTimeStr(date)).append(']');
            this.eqlRun.addRealParam(index + 1, date);
        } else {
            Object paramValue = value;
            if (placeHolder != null && value instanceof String) {
                String strValue = (String)value;
                if (placeHolder.isLob()) {
                    paramValue = S.toBytes(strValue);
                } else if (placeHolder.getLike() == EqlParamPlaceholder.Like.Like) {
                    paramValue = this.tryAddLeftAndRightPercent(strValue);
                } else if (placeHolder.getLike() == EqlParamPlaceholder.Like.RightLike) {
                    paramValue = this.tryAddRightPercent(strValue);
                } else if (placeHolder.getLike() == EqlParamPlaceholder.Like.LeftLike) {
                    paramValue = this.tryAddLeftPercent(strValue);
                }
            }
            this.boundParams.append('[').append(paramValue).append(']');
            this.eqlRun.addRealParam(index + 1, paramValue);
        }
    }

    private String tryAddLeftPercent(String strValue) {
        return (strValue.startsWith("%") ? "" : "%") + strValue;
    }

    private String tryAddRightPercent(String strValue) {
        return strValue + (strValue.endsWith("%") ? "" : "%");
    }

    private String tryAddLeftAndRightPercent(String strValue) {
        return (strValue.startsWith("%") ? "" : "%") + strValue + (strValue.endsWith("%") ? "" : "%");
    }

    private void setParamEx(EqlParamPlaceholder placeHolder, int index, Object value) throws SQLException {
        if (this.regiesterOut(index)) {
            return;
        }
        this.setParamExtra(placeHolder, index, value);
    }

    private boolean regiesterOut(int index) throws SQLException {
        EqlParamPlaceholder.InOut inOut = this.eqlRun.getPlaceHolders()[index].getInOut();
        if (this.eqlRun.getSqlType().isProcedure() && inOut != EqlParamPlaceholder.InOut.IN) {
            this.eqlRun.registerOutParameter(index + 1, 12);
        }
        return inOut == EqlParamPlaceholder.InOut.OUT;
    }

    private Object findParamByName(int index) {
        String varName = this.eqlRun.getPlaceHolders()[index].getPlaceholder();
        ExpressionEvaluator evaluator = this.eqlRun.getEqlConfig().getExpressionEvaluator();
        Object property = evaluator.eval(varName, this.eqlRun);
        if (property != null) {
            return property;
        }
        String propertyName = Names.underscoreNameToPropertyName(varName);
        return Objects.equal((Object)propertyName, (Object)varName) ? property : evaluator.eval(propertyName, this.eqlRun);
    }

    private Object getParamByIndex(int index) {
        EqlParamPlaceholder[] placeHolders = this.eqlRun.getPlaceHolders();
        if (index < placeHolders.length && this.eqlRun.getSqlType().isProcedure() && placeHolders[index].getInOut() == EqlParamPlaceholder.InOut.OUT) {
            return null;
        }
        Object[] params = this.eqlRun.getParams();
        if (params != null && index < params.length) {
            return params[index];
        }
        throw new EqlExecuteException("[" + this.eqlRun.getSqlId() + "] lack parameters at runtime");
    }

    private Object findParamBySeq(int index) {
        return this.getParamByIndex(this.eqlRun.getPlaceHolders()[index - 1].getSeq() - 1);
    }

    private static enum ParamExtra {
        Extra,
        Normal;

    }
}

