/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Objects;
import java.util.List;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlDynamic;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.DynamicParser;
import org.n3r.eql.util.Names;

public class DynamicReplacer {
    private EqlDynamic eqlDynamic;
    private Object[] dynamics;
    private EqlRun eqlRun;

    public void replaceDynamics(EqlRun eqlRun) {
        this.eqlRun = eqlRun;
        this.dynamics = eqlRun.getDynamics();
        if (this.dynamics != null && this.dynamics.length > 0 && eqlRun.getEqlDynamic() == null) {
            eqlRun.setEqlDynamic(new DynamicParser().parseRawSql(eqlRun.getRunSql()));
        }
        this.eqlDynamic = eqlRun.getEqlDynamic();
        if (this.eqlDynamic == null) {
            return;
        }
        List<String> sqlPieces = this.eqlDynamic.getSqlPieces();
        StringBuilder runSql = new StringBuilder(sqlPieces.get(0));
        int ii = sqlPieces.size();
        switch (this.eqlDynamic.getPlaceholdertype()) {
            case AUTO_SEQ: {
                for (int i = 1; i < ii; ++i) {
                    runSql.append(this.findDynamicByIdx(i - 1)).append(sqlPieces.get(i));
                }
                break;
            }
            case MANU_SEQ: {
                for (int i = 1; i < ii; ++i) {
                    runSql.append(this.findDynamicBySeq(i - 1)).append(sqlPieces.get(i));
                }
                break;
            }
            case VAR_NAME: {
                for (int i = 1; i < ii; ++i) {
                    runSql.append(this.findDynamicByName(i - 1)).append(sqlPieces.get(i));
                }
                break;
            }
        }
        eqlRun.setRunSql(runSql.toString());
    }

    private Object findDynamicByIdx(int index) {
        if (index < this.dynamics.length) {
            return this.dynamics[index];
        }
        throw new EqlExecuteException("[" + this.eqlRun.getSqlId() + "] lack dynamic params");
    }

    private Object findDynamicBySeq(int index) {
        return this.findDynamicByIdx(this.eqlDynamic.getPlaceholders()[index].getSeq() - 1);
    }

    private Object findDynamicByName(int index) {
        String varName = this.eqlDynamic.getPlaceholders()[index].getPlaceholder();
        ExpressionEvaluator evaluator = this.eqlRun.getEqlConfig().getExpressionEvaluator();
        Object property = evaluator.evalDynamic(varName, this.eqlRun);
        if (property != null) {
            return property;
        }
        String propertyName = Names.underscoreNameToPropertyName(varName);
        if (!Objects.equal((Object)propertyName, (Object)varName)) {
            property = evaluator.evalDynamic(propertyName, this.eqlRun);
        }
        return property;
    }
}

