/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.ForPart;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;
import org.n3r.eql.util.PairsParser;

public class ForParser
implements PartParser {
    private String item = "item";
    private String index = "index";
    private String collection;
    private String open = "";
    private String separator = "";
    private String close = "";
    private MultiPart part = new MultiPart();

    public ForParser(String options) {
        Map<String, String> optionsMap = new PairsParser().parse(options.trim());
        if (optionsMap.containsKey("item")) {
            this.item = optionsMap.get("item");
        }
        if (optionsMap.containsKey("index")) {
            this.index = optionsMap.get("index");
        }
        if (optionsMap.containsKey("collection")) {
            this.collection = optionsMap.get("collection");
        }
        if (optionsMap.containsKey("open")) {
            this.open = optionsMap.get("open");
        }
        if (optionsMap.containsKey("separator")) {
            this.separator = optionsMap.get("separator");
        }
        if (optionsMap.containsKey("close")) {
            this.close = optionsMap.get("close");
        }
        if (ParserUtils.isBlank(this.collection)) {
            throw new RuntimeException("for clause required collection");
        }
    }

    @Override
    public EqlPart createPart() {
        return new ForPart(this.part, this.item, this.index, this.collection, this.open, this.separator, this.close);
    }

    @Override
    public int parse(List<String> mergedLines, int index) {
        int i;
        int ii = mergedLines.size();
        for (i = index; i < ii; ++i) {
            String clearLine;
            String line = mergedLines.get(i);
            if (line.startsWith("--")) {
                clearLine = ParserUtils.substr(line, "--".length());
            } else {
                Matcher matcher = ParserUtils.inlineComment.matcher(line);
                if (matcher.matches()) {
                    clearLine = matcher.group(1).trim();
                } else {
                    this.part.addPart(new LiteralPart(line));
                    continue;
                }
            }
            if ("end".equalsIgnoreCase(clearLine)) {
                return i + 1;
            }
            PartParser partParser = PartParserFactory.tryParse(clearLine);
            if (partParser == null) continue;
            i = partParser.parse(mergedLines, i + 1) - 1;
            this.part.addPart(partParser.createPart());
        }
        return i;
    }
}

