/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.collect.Lists;
import java.util.List;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlPart;

public class MultiPart
implements EqlPart {
    private List<EqlPart> parts = Lists.newArrayList();

    @Override
    public String evalSql(EqlRun eqlRun) {
        StringBuilder sql = new StringBuilder();
        for (EqlPart eqlPart : this.parts) {
            this.appendSpace(sql);
            sql.append(eqlPart.evalSql(eqlRun));
        }
        return sql.toString();
    }

    private void appendSpace(StringBuilder sql) {
        if (sql.length() == 0) {
            return;
        }
        char c = sql.charAt(sql.length() - 1);
        if (!Character.isWhitespace(c)) {
            sql.append(' ');
        }
    }

    public void addPart(EqlPart part) {
        this.parts.add(part);
    }

    public int size() {
        return this.parts.size();
    }

    public EqlPart part(int index) {
        return this.parts.get(index);
    }
}

