/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.pojo;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.n3r.eql.Eql;
import org.n3r.eql.EqlPage;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.impl.DefaultDynamicLanguageDriver;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.EqlBlockParser;
import org.n3r.eql.pojo.impl.PojoParser;
import org.n3r.eql.util.P;

public class Pql
extends Eql {
    private Object pojo;
    private String sql;

    public Pql() {
    }

    public Pql(EqlConfig eqlConfig) {
        super(eqlConfig);
    }

    public Pql(String connectionName) {
        super(connectionName);
    }

    public <T> void create(T pojo) {
        this.pojo = pojo;
        this.sql = PojoParser.parseCreateSql(pojo.getClass());
        super.id("create").params(pojo).execute(new String[0]);
    }

    public <T> int update(T pojo, String ... includeProperties) {
        this.pojo = pojo;
        int includePropertiesSize = includeProperties.length;
        if (includePropertiesSize == 0) {
            this.sql = PojoParser.parseUpdateSql(pojo.getClass());
            String sqlid = Hashing.murmur3_32().hashString((CharSequence)this.sql, Charsets.UTF_8).toString();
            return (Integer)super.id(sqlid).params(pojo).execute(new String[0]);
        }
        this.sql = PojoParser.parseUpdateSql2(pojo.getClass());
        String input = this.sql + Arrays.toString(includeProperties);
        String sqlid = Hashing.murmur3_32().hashString((CharSequence)input, Charsets.UTF_8).toString();
        HashMap params = Maps.newHashMap();
        for (String includeProperty : includeProperties) {
            params.put(PojoParser.PREFIX_FLAG + includeProperty, "TAG");
        }
        Map<String, Object> mergeProperties = P.mergeProperties(params, pojo);
        return (Integer)super.id(sqlid).params(mergeProperties).execute(new String[0]);
    }

    public <T> T read(Object pojo) {
        this.pojo = pojo;
        this.sql = PojoParser.parseReadSql(pojo.getClass());
        return super.id("read").params(pojo).returnType(pojo.getClass()).execute(new String[0]);
    }

    public <T> int delete(T pojo) {
        this.pojo = pojo;
        this.sql = PojoParser.parseDeleteSql(pojo.getClass());
        return (Integer)super.id("delete").params(pojo).execute(new String[0]);
    }

    @Override
    public Pql limit(EqlPage page) {
        return (Pql)super.limit(page);
    }

    @Override
    public Pql limit(int maxRows) {
        return (Pql)super.limit(maxRows);
    }

    @Override
    protected void initSqlId(String sqlId, int level) {
        String sqlClassPath = this.pojo.getClass().getName();
        this.eqlBlock = new EqlBlock(sqlClassPath, sqlId, "", 0);
        EqlBlockParser blockParser = new EqlBlockParser(new DefaultDynamicLanguageDriver(), false);
        List sqlLines = Splitter.on((String)"\r\n").splitToList((CharSequence)this.sql);
        blockParser.parse(this.eqlBlock, sqlLines);
        this.rsRetriever.setEqlBlock(this.eqlBlock);
    }
}

