/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.pojo.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.n3r.eql.pojo.annotations.EqlColumn;
import org.n3r.eql.pojo.annotations.EqlId;
import org.n3r.eql.pojo.annotations.EqlSkip;
import org.n3r.eql.pojo.annotations.EqlTable;
import org.n3r.eql.util.Names;

public class PojoParser {
    static LoadingCache<Class<?>, String> createSqlCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, String>(){

        public String load(Class<?> pojoClass) throws Exception {
            return PojoParser.parseCreateSqlWoCache(pojoClass);
        }
    });
    static LoadingCache<Class<?>, String> readSqlCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, String>(){

        public String load(Class<?> pojoClass) throws Exception {
            return PojoParser.parseReadSqlWoCache(pojoClass);
        }
    });
    static LoadingCache<Class<?>, String> updateSqlCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, String>(){

        public String load(Class<?> pojoClass) throws Exception {
            return PojoParser.parseUpdateSqlWoCache(pojoClass, "");
        }
    });
    public static String PREFIX_FLAG = "_flag_";
    static LoadingCache<Class<?>, String> updateSqlCache2 = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, String>(){

        public String load(Class<?> pojoClass) throws Exception {
            return PojoParser.parseUpdateSqlWoCache(pojoClass, PREFIX_FLAG);
        }
    });
    static LoadingCache<Class<?>, String> deleteSqlCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, String>(){

        public String load(Class<?> pojoClass) throws Exception {
            return PojoParser.parseDeleteSqlWoCache(pojoClass);
        }
    });

    public static String parseCreateSql(Class<?> pojoClass) {
        return (String)createSqlCache.getUnchecked(pojoClass);
    }

    private static Field[] parsePropertiesName(Class<?> pojoClass) {
        Field[] declaredFields = pojoClass.getDeclaredFields();
        ArrayList properties = Lists.newArrayList();
        for (Field field : declaredFields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(EqlSkip.class) != null) continue;
            properties.add(field);
        }
        return properties.toArray(new Field[properties.size()]);
    }

    static String parseCreateSqlWoCache(Class<?> pojoClass) {
        String tableName = PojoParser.parseTableName(pojoClass);
        StringBuilder createSql = new StringBuilder("insert into ").append(tableName).append("(");
        StringBuilder valueSql = new StringBuilder(") values(");
        for (Field field : PojoParser.parsePropertiesName(pojoClass)) {
            String columnName = PojoParser.parseColumnName(field);
            createSql.append(columnName).append(',');
            valueSql.append('#').append(field.getName()).append("#,");
        }
        char c = createSql.charAt(createSql.length() - 1);
        if (c != ',') {
            throw new RuntimeException("there is no property to save for class " + pojoClass);
        }
        createSql.delete(createSql.length() - 1, createSql.length());
        valueSql.delete(valueSql.length() - 1, valueSql.length());
        createSql.append((CharSequence)valueSql).append(')');
        return createSql.toString();
    }

    public static String parseReadSql(Class<?> pojoClass) {
        return (String)readSqlCache.getUnchecked(pojoClass);
    }

    static String parseReadSqlWoCache(Class<?> pojoClass) {
        StringBuilder selectSql = new StringBuilder("select ");
        StringBuilder whereSql = new StringBuilder();
        int initialLen = selectSql.length();
        for (Field field : PojoParser.parsePropertiesName(pojoClass)) {
            String columnName = PojoParser.parseColumnName(field);
            if (selectSql.length() > initialLen) {
                selectSql.append(',');
            }
            selectSql.append(columnName).append(" as ").append(field.getName());
            whereSql.append("-- isNotEmpty ").append(field.getName()).append("\r\n");
            whereSql.append(" and ").append(columnName).append("=#").append(field.getName()).append("#\r\n");
            whereSql.append("-- end\r\n");
        }
        String tableName = PojoParser.parseTableName(pojoClass);
        return selectSql.append(" from ").append(tableName).append("\r\n-- trim prefix=where prefixOverrides=and\r\n").append((CharSequence)whereSql).append("-- end\r\n").toString();
    }

    public static String parseUpdateSql(Class<?> pojoClass) {
        return (String)updateSqlCache.getUnchecked(pojoClass);
    }

    public static String parseUpdateSql2(Class<?> pojoClass) {
        return (String)updateSqlCache2.getUnchecked(pojoClass);
    }

    public static String parseUpdateSqlWoCache(Class<?> pojoClass, String fieldFlagPrefix) {
        StringBuilder setSql = new StringBuilder();
        StringBuilder whereSql = new StringBuilder();
        for (Field field : PojoParser.parsePropertiesName(pojoClass)) {
            String columnName = PojoParser.parseColumnName(field);
            boolean isIdColumn = PojoParser.isIdColumn(field, columnName);
            if (isIdColumn) {
                if (whereSql.length() > 0) {
                    whereSql.append(" and ");
                }
                whereSql.append(columnName).append("=#").append(field.getName()).append("#");
                continue;
            }
            setSql.append("-- isNotEmpty ").append(fieldFlagPrefix + field.getName()).append("\r\n");
            setSql.append(columnName).append("=#").append(field.getName()).append("#,\r\n");
            setSql.append("-- end\r\n");
        }
        String tableName = PojoParser.parseTableName(pojoClass);
        StringBuilder sql = new StringBuilder("update ").append(tableName).append("\r\n").append("-- trim prefix=set suffixOverrides=,   \r\n").append((CharSequence)setSql).append("-- end \r\n").append("where ").append((CharSequence)whereSql);
        return sql.toString();
    }

    private static boolean isIdColumn(Field field, String columnName) {
        EqlId idAnnotation = field.getAnnotation(EqlId.class);
        return idAnnotation != null || "id".equals(columnName);
    }

    public static String parseDeleteSql(Class<?> pojoClass) {
        return (String)deleteSqlCache.getUnchecked(pojoClass);
    }

    static String parseDeleteSqlWoCache(Class<?> pojoClass) {
        String tableName = PojoParser.parseTableName(pojoClass);
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        int initialLen = sql.length();
        for (Field field : PojoParser.parsePropertiesName(pojoClass)) {
            String columnName = PojoParser.parseColumnName(field);
            boolean isIdColumn = PojoParser.isIdColumn(field, columnName);
            if (!isIdColumn) continue;
            if (sql.length() > initialLen) {
                sql.append(" and ");
            }
            sql.append(columnName).append("=#").append(field.getName()).append("#");
        }
        return sql.toString();
    }

    private static String parseTableName(Class<?> pojoClass) {
        EqlTable pojoClassAnnotation = pojoClass.getAnnotation(EqlTable.class);
        return pojoClassAnnotation == null ? Names.convertCamelToUnderscore(pojoClass.getSimpleName()) : pojoClassAnnotation.name();
    }

    private static String parseColumnName(Field field) {
        EqlColumn column = field.getAnnotation(EqlColumn.class);
        return column != null ? column.name() : Names.convertCamelToUnderscore(field.getName());
    }
}

