/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.trans.EqlConnection;

public class EqlDruidConnection
implements EqlConnection {
    DruidDataSource dataSource;

    @Override
    public void initialize(EqlConfig eqlConfig) {
        int myMinEvictableIdleTimeMillis;
        int myTimeBetweenEvictionRunsMillis;
        int myMaxWait;
        int myMaxActive;
        int myMinIdle;
        String url = eqlConfig.getStr("url");
        String username = eqlConfig.getStr("username");
        String password = eqlConfig.getStr("password");
        String initialSize = eqlConfig.getStr("initialSize");
        String minIdle = eqlConfig.getStr("minIdle");
        String maxActive = eqlConfig.getStr("maxActive");
        String maxWait = eqlConfig.getStr("maxWait");
        String timeBetweenEvictionRunsMillis = eqlConfig.getStr("timeBetweenEvictionRunsMillis");
        String minEvictableIdleTimeMillis = eqlConfig.getStr("minEvictableIdleTimeMillis");
        String validationQuery = eqlConfig.getStr("validationQuery");
        this.dataSource = new DruidDataSource();
        this.dataSource.setUrl(url);
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        int myInitialSize = this.parseIntParameter(initialSize);
        if (myInitialSize > 0) {
            this.dataSource.setInitialSize(myInitialSize);
        }
        if ((myMinIdle = this.parseIntParameter(minIdle)) > 0) {
            this.dataSource.setMinIdle(myMinIdle);
        }
        if ((myMaxActive = this.parseIntParameter(maxActive)) > 0) {
            this.dataSource.setMaxActive(myMaxActive);
        }
        if ((myMaxWait = this.parseIntParameter(maxWait)) > 0) {
            this.dataSource.setMaxWait((long)myMaxWait);
        }
        if ((myTimeBetweenEvictionRunsMillis = this.parseIntParameter(timeBetweenEvictionRunsMillis)) > 0) {
            this.dataSource.setTimeBetweenEvictionRunsMillis((long)myTimeBetweenEvictionRunsMillis);
        }
        if ((myMinEvictableIdleTimeMillis = this.parseIntParameter(minEvictableIdleTimeMillis)) > 0) {
            this.dataSource.setMinEvictableIdleTimeMillis((long)myMinEvictableIdleTimeMillis);
        }
        if (StringUtils.isNotBlank((CharSequence)validationQuery)) {
            this.dataSource.setValidationQuery(validationQuery);
        }
    }

    private int parseIntParameter(String param) {
        return param.matches("\\d+") ? Integer.parseInt(param) : 0;
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new EqlExecuteException(e);
        }
    }

    @Override
    public void destroy() {
        this.dataSource.close();
    }
}

