/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.n3r.eql.Eql;
import org.n3r.eql.EqlTran;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.trans.EqlConnection;
import org.n3r.eql.util.Closes;

public class EqlJdbcTran
implements EqlTran {
    private final Eql eql;
    private EqlConnection eqlConnection;
    private Connection connection;

    public EqlJdbcTran(Eql eql, EqlConnection connection) {
        this.eql = eql;
        this.eqlConnection = connection;
    }

    @Override
    public void start() {
    }

    @Override
    public void commit() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new EqlExecuteException(e);
        }
    }

    @Override
    public void rollback() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new EqlExecuteException(e);
        }
    }

    @Override
    public Connection getConn() {
        return this.getConnection();
    }

    protected Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.eqlConnection.getConnection();
        }
        if (this.connection == null) {
            throw new EqlExecuteException("EqlJdbcTran could not start transaction.  Cause: The DataSource returned a null connection.");
        }
        try {
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new EqlExecuteException(e);
        }
        return this.connection;
    }

    @Override
    public void close() throws IOException {
        Closes.closeQuietly(this.connection);
        this.eql.resetTran();
    }
}

