/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.n3r.eql.util.Closes;
import org.n3r.eql.util.O;

public class P {
    public static Map<String, Object> mergeProperties(Map<String, Object> context, Object bean) {
        HashMap map = Maps.newHashMap(context);
        if (bean == null) {
            return map;
        }
        if (bean instanceof Map) {
            map.putAll((Map)bean);
            return map;
        }
        P.mergeDelcaredProeprties(bean, map);
        P.mergeReadProperties(bean, map);
        return map;
    }

    private static void mergeDelcaredProeprties(Object bean, Map<String, Object> map) {
        for (Field field : bean.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                map.put(field.getName(), field.get(bean));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void mergeReadProperties(Object bean, Map<String, Object> map) {
        BeanInfo info = O.getBeanInfo(bean.getClass());
        for (PropertyDescriptor pDesc : info.getPropertyDescriptors()) {
            Method method = pDesc.getReadMethod();
            if (method == null) continue;
            String name = pDesc.getName();
            Optional<Object> value = O.invokeMethod(bean, method);
            if (!value.isPresent()) continue;
            map.put(name, value.get());
        }
    }

    public static Properties toProperties(String properties) {
        Properties result = new Properties();
        try {
            result.load(new ByteArrayInputStream(properties.getBytes(Charsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Properties toProperties(File file) {
        Properties result = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            result.load(fis);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closes.closeQuietly(fis);
                throw throwable;
            }
        }
        Closes.closeQuietly(fis);
        return result;
    }

    public static Properties toProperties(InputStream is) {
        Properties result = new Properties();
        try {
            result.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

