/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.n3r.eql.map.ResultSetRs;
import org.n3r.eql.map.RsAware;
import org.n3r.eql.util.S;

public class Rs {
    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    public static Object getResultSetValue(RsAware rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj instanceof Date) {
            if ("java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
                obj = rs.getTimestamp(index);
            }
        } else if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        return obj;
    }

    public static Object getResultSetValue(RsAware rs, int index, Class<?> requiredType) throws SQLException {
        Object value;
        if (requiredType == null) {
            return Rs.getResultSetValue(rs, index);
        }
        boolean wasNullCheck = false;
        if (String.class.equals(requiredType)) {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnType = metaData != null ? metaData.getColumnType(index) : 12;
            switch (columnType) {
                case 2004: {
                    value = S.bytesToStr(rs.getBytes(index));
                    break;
                }
                default: {
                    value = S.trim(rs.getString(index));
                    break;
                }
            }
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals(requiredType)) {
            value = rs.getBoolean(index);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals(requiredType)) {
            value = rs.getByte(index);
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals(requiredType)) {
            value = rs.getShort(index);
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals(requiredType)) {
            value = rs.getInt(index);
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals(requiredType)) {
            value = rs.getLong(index);
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals(requiredType)) {
            value = Float.valueOf(rs.getFloat(index));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
            value = rs.getDouble(index);
            wasNullCheck = true;
        } else if (byte[].class.equals(requiredType)) {
            value = rs.getBytes(index);
        } else if (java.util.Date.class.equals(requiredType)) {
            value = rs.getTimestamp(index);
            if (value != null && !rs.wasNull()) {
                value = new java.util.Date(((Timestamp)value).getTime());
            }
        } else if (Date.class.equals(requiredType)) {
            value = rs.getTimestamp(index);
            if (value != null && !rs.wasNull()) {
                value = new Date(((Timestamp)value).getTime());
            }
        } else {
            value = Time.class.equals(requiredType) ? rs.getTime(index) : (Timestamp.class.equals(requiredType) || java.util.Date.class.equals(requiredType) ? rs.getTimestamp(index) : (BigDecimal.class.equals(requiredType) ? rs.getBigDecimal(index) : (Blob.class.equals(requiredType) ? rs.getBlob(index) : (Clob.class.equals(requiredType) ? rs.getClob(index) : Rs.getResultSetValue(rs, index)))));
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        return Rs.getResultSetValue(new ResultSetRs(rs), index);
    }
}

