/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.convert.todb;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import org.n3r.eql.convert.EqlConvertAnn;
import org.n3r.eql.convert.EqlConverts;
import org.n3r.eql.convert.todb.EqlerToDbConverter;
import org.n3r.eql.convert.todb.ToDbConvert;

public class EqlToDbConverts {
    static LoadingCache<AccessibleObject, Optional<EqlerToDbConverter>> toDbConverterCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<AccessibleObject, Optional<EqlerToDbConverter>>(){

        public Optional<EqlerToDbConverter> load(AccessibleObject accessibleObject) throws Exception {
            ArrayList ecas = Lists.newArrayList();
            EqlConverts.searchEqlConvertAnns(accessibleObject, ecas, ToDbConvert.class);
            if (ecas.isEmpty()) {
                return Optional.absent();
            }
            EqlerToDbConverter eqlerToDbConverter = new EqlerToDbConverter();
            for (EqlConvertAnn eca : ecas) {
                eqlerToDbConverter.addConvertAnn(eca);
            }
            return Optional.of((Object)eqlerToDbConverter);
        }
    });

    public static Optional<EqlerToDbConverter> getConverter(AccessibleObject accessibleObject) {
        return (Optional)toDbConverterCache.getUnchecked((Object)accessibleObject);
    }
}

