/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSensitiveFieldsParser
implements SensitiveFieldsParser {
    private static final Logger log = LoggerFactory.getLogger(MySqlSensitiveFieldsParser.class);
    private final Map<String, Object> aliasTablesMap = Maps.newHashMap();
    private final Set<Integer> secureBindIndices = Sets.newHashSet();
    private final Set<Integer> secureResultIndices = Sets.newHashSet();
    private final Set<String> secureResultLabels = Sets.newHashSet();
    private final List<BindVariant> subQueryBindAndVariantOfFrom = Lists.newArrayList();
    private final Set<String> secureFields;
    private int variantIndex = 0;
    private final String sql;
    private MySqlASTVisitorAdapter adapter = new MySqlASTVisitorAdapter(){

        public boolean visit(SQLVariantRefExpr x) {
            ++MySqlSensitiveFieldsParser.this.variantIndex;
            return true;
        }

        public boolean visit(SQLBinaryOpExpr x) {
            if (this.hasSecureField(x.getLeft())) {
                MySqlSensitiveFieldsParser.this.checkOnlyOneAsk(x.getRight());
            } else if (this.hasSecureField(x.getRight())) {
                MySqlSensitiveFieldsParser.this.checkOnlyOneAsk(x.getLeft());
            }
            return true;
        }

        private boolean hasSecureField(SQLExpr field) {
            return field instanceof SQLIdentifierExpr && MySqlSensitiveFieldsParser.this.isSecureField((SQLIdentifierExpr)field) || field instanceof SQLPropertyExpr && MySqlSensitiveFieldsParser.this.isSecureField((SQLPropertyExpr)field);
        }
    };
    private static Pattern encryptHint = Pattern.compile("\\s*/\\*{3}\\s*(.*?)\\s*\\*{3}/");
    private static Pattern bindPattern = Pattern.compile("bind\\s*\\((.*?)\\)");
    private static Pattern resultPattern = Pattern.compile("result\\s*\\((.*?)\\)");
    private static Splitter indexSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();

    private static MySqlSensitiveFieldsParser tryParseHint(String sql, Set<String> secureFields) {
        MySqlSensitiveFieldsParser fieldsParser = null;
        Matcher matcher = encryptHint.matcher(sql);
        if (matcher.find() && matcher.start() == 0) {
            String convertedSql = sql.substring(matcher.end());
            String hint = matcher.group(1);
            fieldsParser = new MySqlSensitiveFieldsParser(secureFields, convertedSql);
            fieldsParser.parseHint(hint);
        }
        return fieldsParser;
    }

    public static MySqlSensitiveFieldsParser parseSql(String sql, Set<String> secureFields) {
        MySqlSensitiveFieldsParser fieldsParser = MySqlSensitiveFieldsParser.tryParseHint(sql, secureFields);
        if (fieldsParser == null) {
            SQLStatement sqlStatement = MySqlSensitiveFieldsParser.parseSql(sql);
            fieldsParser = new MySqlSensitiveFieldsParser(secureFields, sql);
            fieldsParser = MySqlSensitiveFieldsParser.parseStatement(fieldsParser, sqlStatement);
        }
        if (fieldsParser == null) {
            return null;
        }
        if (fieldsParser.haveNonSecureFields()) {
            return null;
        }
        return fieldsParser;
    }

    private static MySqlSensitiveFieldsParser parseStatement(MySqlSensitiveFieldsParser parser, SQLStatement sqlStatement) {
        if (sqlStatement instanceof SQLSelectStatement) {
            parser.parseSelectQuery(((SQLSelectStatement)sqlStatement).getSelect().getQuery());
        } else if (sqlStatement instanceof MySqlDeleteStatement) {
            parser.parseDelete((MySqlDeleteStatement)sqlStatement);
        } else if (sqlStatement instanceof MySqlInsertStatement) {
            parser.parseInsert((SQLInsertInto)((MySqlInsertStatement)sqlStatement));
        } else if (sqlStatement instanceof MySqlReplaceStatement) {
            parser.parseReplace((MySqlReplaceStatement)sqlStatement);
        } else if (sqlStatement instanceof MySqlUpdateStatement) {
            parser.parseUpdate((MySqlUpdateStatement)sqlStatement);
        } else if (sqlStatement instanceof SQLCallStatement) {
            parser.parseCall((SQLCallStatement)sqlStatement);
        }
        return parser;
    }

    private void parseSelectQuery(SQLSelectQuery query) {
        if (query instanceof SQLSelectQueryBlock) {
            this.parseQuery((SQLSelectQueryBlock)query);
        } else if (query instanceof SQLUnionQuery) {
            this.parseUnionQuery((SQLUnionQuery)query);
        }
    }

    private static SQLStatement parseSql(String sql) {
        List stmtList;
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        try {
            stmtList = parser.parseStatementList();
        }
        catch (ParserException exception) {
            exception.printStackTrace();
            throw new RuntimeException(sql + " is invalid, detail " + exception.getMessage());
        }
        return (SQLStatement)stmtList.get(0);
    }

    private MySqlSensitiveFieldsParser(Set<String> secureFields, String sql) {
        this.secureFields = secureFields;
        this.sql = sql;
    }

    private void parseHint(String hint) {
        Matcher matcher = bindPattern.matcher(hint);
        if (matcher.find()) {
            Iterable bindIndices = indexSplitter.split((CharSequence)matcher.group(1));
            for (String bindIndex : bindIndices) {
                this.secureBindIndices.add(Integer.parseInt(bindIndex));
            }
        }
        if ((matcher = resultPattern.matcher(hint)).find()) {
            Iterable resultIndices = indexSplitter.split((CharSequence)matcher.group(1));
            for (String resultIndex : resultIndices) {
                this.secureResultIndices.add(Integer.parseInt(resultIndex));
            }
        }
    }

    private void parseUnionQuery(SQLUnionQuery sqlUnionQuery) {
        SQLSelectQuery left = sqlUnionQuery.getLeft();
        this.parseQuery((SQLSelectQueryBlock)left);
        SQLSelectQuery right = sqlUnionQuery.getRight();
        if (right instanceof SQLUnionQuery) {
            this.parseUnionQuery((SQLUnionQuery)right);
        } else {
            this.parseQuery((SQLSelectQueryBlock)right);
        }
    }

    private void parseQuery(SQLSelectQueryBlock queryBlock) {
        this.parseTable(queryBlock.getFrom());
        this.parseSelectItems(queryBlock.getSelectList());
        this.adjustSubQueryBindIndicesOfFrom();
        if (queryBlock.getWhere() != null) {
            queryBlock.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void adjustSubQueryBindIndicesOfFrom() {
        for (BindVariant bindVariant : this.subQueryBindAndVariantOfFrom) {
            for (Integer index : bindVariant.getBindIndices()) {
                this.secureBindIndices.add(this.variantIndex + index);
            }
            this.variantIndex += bindVariant.getVariantIndex().intValue();
        }
    }

    private void parseDelete(MySqlDeleteStatement deleteStatement) {
        SQLExprTableSource tableSource = (SQLExprTableSource)deleteStatement.getTableSource();
        if (tableSource.getExpr() instanceof SQLIdentifierExpr) {
            this.addTableAlias((SQLTableSource)tableSource, (SQLIdentifierExpr)tableSource.getExpr());
        }
        if (deleteStatement.getWhere() != null) {
            deleteStatement.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void parseCall(SQLCallStatement callStatement) {
        boolean isOraFunc;
        this.addTableAlias("", callStatement.getProcedureName().toString());
        boolean bl = isOraFunc = callStatement.getOutParameter() != null;
        if (isOraFunc && this.isSecureField(1)) {
            this.secureBindIndices.add(1);
        }
        List parameters = callStatement.getParameters();
        int ii = parameters.size();
        for (int i = 0; i < ii; ++i) {
            SQLExpr parameter = (SQLExpr)parameters.get(i);
            parameter.accept((SQLASTVisitor)this.adapter);
            int paramIndex = i + 1 + (isOraFunc ? 1 : 0);
            if (!this.isSecureField(paramIndex)) continue;
            if (parameter instanceof SQLVariantRefExpr) {
                this.secureBindIndices.add(this.variantIndex + (isOraFunc ? 1 : 0));
                continue;
            }
            log.warn("secure field is not passed as a single value in sql [{}", (Object)this.sql);
        }
    }

    private void parseUpdate(MySqlUpdateStatement updateStatement) {
        SQLTableSource tableSource = updateStatement.getTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            SQLExprTableSource ets = (SQLExprTableSource)tableSource;
            this.addTableAlias(ets.getAlias(), (SQLIdentifierExpr)ets.getExpr());
        }
        List items = updateStatement.getItems();
        SQLUpdateSetItem item0 = (SQLUpdateSetItem)items.get(0);
        if (items.size() == 1 && item0.getColumn() instanceof SQLListExpr && item0.getValue() instanceof SQLQueryExpr) {
            this.walkUpdateSelect(item0);
        } else {
            this.walkUpdateItems(items);
        }
        if (updateStatement.getWhere() != null) {
            updateStatement.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void walkUpdateSelect(SQLUpdateSetItem item) {
        SQLListExpr sqlListExpr = (SQLListExpr)item.getColumn();
        List items = sqlListExpr.getItems();
        HashSet secureFieldIndices = Sets.newHashSet();
        int ii = items.size();
        for (int i = 0; i < ii; ++i) {
            SQLExpr expr = (SQLExpr)items.get(i);
            if (!(expr instanceof SQLPropertyExpr) || !this.isSecureField((SQLPropertyExpr)expr)) continue;
            secureFieldIndices.add(i);
        }
        SQLQueryExpr value = (SQLQueryExpr)item.getValue();
        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)value.getSubQuery().getQuery();
        this.parseTable(queryBlock.getFrom());
        this.parseSelectItemsInUpdate(secureFieldIndices, queryBlock.getSelectList());
        if (queryBlock.getWhere() != null) {
            queryBlock.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void parseSelectItemsInUpdate(Set<Integer> secureFieldIndices, List<SQLSelectItem> selectList) {
        int ii = selectList.size();
        for (int i = 0; i < ii; ++i) {
            SQLSelectItem item = selectList.get(i);
            item.accept((SQLASTVisitor)this.adapter);
            if (!secureFieldIndices.contains(i) || !(item.getExpr() instanceof SQLVariantRefExpr)) continue;
            this.secureBindIndices.add(this.variantIndex);
        }
    }

    private void walkUpdateItems(List<SQLUpdateSetItem> items) {
        int ii = items.size();
        for (int i = 0; i < ii; ++i) {
            SQLUpdateSetItem item = items.get(i);
            item.accept((SQLASTVisitor)this.adapter);
            boolean isSecureField = false;
            if (item.getColumn() instanceof SQLPropertyExpr) {
                SQLPropertyExpr expr = (SQLPropertyExpr)item.getColumn();
                isSecureField = this.isSecureField(expr);
            } else if (item.getColumn() instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr column = (SQLIdentifierExpr)item.getColumn();
                isSecureField = this.isSecureField(column);
            }
            if (!isSecureField) continue;
            if (item.getValue() instanceof SQLVariantRefExpr) {
                this.secureBindIndices.add(this.variantIndex);
                continue;
            }
            log.warn("secure field is not updated as a single value in sql [{}]", (Object)this.sql);
        }
    }

    private void checkOnlyOneAsk(SQLExpr right) {
        final AtomicInteger rightVariantIndex = new AtomicInteger(0);
        right.accept((SQLASTVisitor)new MySqlASTVisitorAdapter(){

            public boolean visit(SQLVariantRefExpr x) {
                rightVariantIndex.incrementAndGet();
                return true;
            }
        });
        if (rightVariantIndex.get() == 1) {
            this.secureBindIndices.add(this.variantIndex + 1);
        }
    }

    private boolean isSecureField(SQLAllColumnExpr field) {
        Object oneTableName = this.getOneTableName();
        return oneTableName != null && this.containsInSecureFields(oneTableName, "*");
    }

    private boolean isSecureField(SQLIdentifierExpr field) {
        Object oneTableName = this.getOneTableName();
        return oneTableName != null && this.containsInSecureFields(oneTableName, field.getName());
    }

    private boolean isSecureField(SQLPropertyExpr expr) {
        Object tableName = this.aliasTablesMap.get(expr.getOwner().toString());
        String fieldName = expr.getName();
        return this.containsInSecureFields(tableName, fieldName);
    }

    private boolean containsInSecureFields(Object tableName, String fieldName) {
        if (tableName instanceof String) {
            return this.containsInSecureFields((String)tableName, fieldName);
        }
        if (tableName instanceof MySqlSensitiveFieldsParser) {
            return this.containsInSecureFields((MySqlSensitiveFieldsParser)tableName, fieldName);
        }
        return false;
    }

    private boolean containsInSecureFields(MySqlSensitiveFieldsParser parser, String fieldName) {
        return "*".equals(fieldName) ? !parser.getSecureResultIndices().isEmpty() : parser.inResultLabels(fieldName);
    }

    private boolean containsInSecureFields(String tableName, String fieldName) {
        String secretField = tableName + "." + fieldName;
        return this.secureFields.contains(secretField.toUpperCase());
    }

    private boolean isSecureField(int procedureParameterIndex) {
        Object oneTableName = this.getOneTableName();
        return oneTableName != null && this.containsInSecureFields(oneTableName, "" + procedureParameterIndex);
    }

    private Object getOneTableName() {
        Iterator<Map.Entry<String, Object>> iterator;
        if (this.aliasTablesMap.size() == 1 && (iterator = this.aliasTablesMap.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            return entry.getValue();
        }
        return null;
    }

    private void parseTable(SQLTableSource from) {
        if (from instanceof SQLExprTableSource) {
            SQLExprTableSource source = (SQLExprTableSource)from;
            if (source.getExpr() instanceof SQLIdentifierExpr) {
                this.addTableAlias(from, (SQLIdentifierExpr)source.getExpr());
            }
        } else if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource = (SQLJoinTableSource)from;
            this.parseTable(joinTableSource.getLeft());
            this.parseTable(joinTableSource.getRight());
            SQLExpr conditionOn = joinTableSource.getCondition();
            if (conditionOn != null) {
                conditionOn.accept((SQLASTVisitor)this.adapter);
            }
        } else if (from instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource tableSource = (SQLSubqueryTableSource)from;
            SQLSelectQuery query = tableSource.getSelect().getQuery();
            MySqlSensitiveFieldsParser subParser = this.createSubQueryParser(query, QueryBelongs.FROM);
            this.addTableAlias(from, subParser);
        }
    }

    private void addTableAlias(SQLTableSource from, MySqlSensitiveFieldsParser subParser) {
        this.addTableAlias(from.getAlias(), subParser);
    }

    private void addTableAlias(SQLTableSource from, SQLIdentifierExpr expr) {
        this.addTableAlias(from.getAlias(), expr);
    }

    private void addTableAlias(String alias, SQLIdentifierExpr expr) {
        this.addTableAlias(alias, expr.getName());
    }

    private void addTableAlias(String alias, String tableName) {
        this.aliasTablesMap.put((String)MoreObjects.firstNonNull((Object)alias, (Object)tableName), tableName);
    }

    private void addTableAlias(String alias, MySqlSensitiveFieldsParser subParser) {
        this.aliasTablesMap.put(alias, subParser);
    }

    private String cleanQuotesAndToUpper(String str) {
        String cleanString = str;
        if (str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"' || str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
            cleanString = str.substring(1, str.length() - 1);
        }
        return cleanString.toUpperCase();
    }

    private void parseSelectItems(List<SQLSelectItem> sqlSelectItems) {
        int ii = sqlSelectItems.size();
        for (int itemIndex = 0; itemIndex < ii; ++itemIndex) {
            SQLSelectQuery subQuery;
            MySqlSensitiveFieldsParser subParser;
            SQLIdentifierExpr expr;
            SQLSelectItem item = sqlSelectItems.get(itemIndex);
            String alias = item.getAlias();
            if (item.getExpr() instanceof SQLIdentifierExpr) {
                expr = (SQLIdentifierExpr)item.getExpr();
                if (!this.isSecureField(expr)) continue;
                this.secureResultIndices.add(itemIndex + 1);
                this.secureResultLabels.add(this.cleanQuotesAndToUpper(alias == null ? expr.getName() : alias));
                continue;
            }
            if (item.getExpr() instanceof SQLPropertyExpr) {
                expr = (SQLPropertyExpr)item.getExpr();
                if (!this.isSecureField((SQLPropertyExpr)expr)) continue;
                if ("*".equals(expr.getName())) {
                    Object tableName = this.aliasTablesMap.get(expr.getOwner().toString());
                    this.copyResultIndicesAndLabels(itemIndex, tableName);
                    continue;
                }
                this.secureResultIndices.add(itemIndex + 1);
                this.secureResultLabels.add(this.cleanQuotesAndToUpper(alias == null ? expr.getName() : alias));
                continue;
            }
            if (item.getExpr() instanceof SQLAllColumnExpr) {
                if (!this.isSecureField((SQLAllColumnExpr)item.getExpr())) continue;
                Object tableName = this.getOneTableName();
                this.copyResultIndicesAndLabels(itemIndex, tableName);
                continue;
            }
            if (!(item.getExpr() instanceof SQLQueryExpr) || !(subParser = this.createSubQueryParser(subQuery = (expr = (SQLQueryExpr)item.getExpr()).getSubQuery().getQuery(), QueryBelongs.SELECT)).inResultIndices(1)) continue;
            this.secureResultIndices.add(itemIndex + 1);
            Set<String> labels = subParser.getSecureResultLabels();
            this.secureResultLabels.add(this.cleanQuotesAndToUpper(alias == null ? labels.iterator().next() : alias));
        }
    }

    private void copyResultIndicesAndLabels(int itemIndex, Object tableName) {
        if (tableName instanceof MySqlSensitiveFieldsParser) {
            MySqlSensitiveFieldsParser parser = (MySqlSensitiveFieldsParser)tableName;
            for (Integer resultIndex : parser.getSecureResultIndices()) {
                this.secureResultIndices.add(resultIndex + itemIndex);
            }
            this.secureResultLabels.addAll(parser.getSecureResultLabels());
        }
    }

    private MySqlSensitiveFieldsParser createSubQueryParser(SQLSelectQuery subQuery, QueryBelongs mode) {
        MySqlSensitiveFieldsParser subParser = new MySqlSensitiveFieldsParser(this.secureFields, this.sql);
        subParser.parseSelectQuery(subQuery);
        switch (mode) {
            case FROM: {
                BindVariant bindAndVariant = new BindVariant(subParser.getVariantIndex(), subParser.getSecureBindIndices());
                this.subQueryBindAndVariantOfFrom.add(bindAndVariant);
                break;
            }
            case SELECT: {
                for (Integer index : subParser.getSecureBindIndices()) {
                    this.secureBindIndices.add(this.variantIndex + index);
                }
                this.variantIndex += subParser.getVariantIndex();
            }
        }
        return subParser;
    }

    private void parseReplace(MySqlReplaceStatement x) {
        SQLExprTableSource tableSource = x.getTableSource();
        if (tableSource.getExpr() instanceof SQLIdentifierExpr) {
            this.addTableAlias((SQLTableSource)tableSource, (SQLIdentifierExpr)tableSource.getExpr());
        }
        List columns = x.getColumns();
        List<Integer> secureFieldsIndices = this.walkInsertColumns(columns);
        List valuesList = x.getValuesList();
        if (valuesList != null) {
            for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
                this.walkInsertValues(secureFieldsIndices, valuesClause.getValues());
            }
        } else if (x.getQuery() != null) {
            SQLQueryExpr sQLQueryExpr = x.getQuery();
        }
    }

    private void parseInsert(SQLInsertInto x) {
        SQLExprTableSource tableSource = x.getTableSource();
        if (tableSource.getExpr() instanceof SQLIdentifierExpr) {
            this.addTableAlias((SQLTableSource)tableSource, (SQLIdentifierExpr)tableSource.getExpr());
        }
        List columns = x.getColumns();
        List<Integer> secureFieldsIndices = this.walkInsertColumns(columns);
        SQLInsertStatement.ValuesClause valuesClause = x.getValues();
        if (valuesClause != null) {
            List values = valuesClause.getValues();
            this.walkInsertValues(secureFieldsIndices, values);
        } else if (x.getQuery() != null) {
            SQLSelect query = x.getQuery();
            this.parseQuery4Insert(secureFieldsIndices, (SQLSelectQueryBlock)query.getQuery());
        }
    }

    private void parseQuery4Insert(List<Integer> secureFieldsIndices, SQLSelectQueryBlock queryBlock) {
        List selectList = queryBlock.getSelectList();
        int ii = selectList.size();
        for (int itemIndex = 0; itemIndex < ii; ++itemIndex) {
            SQLSelectItem item = (SQLSelectItem)selectList.get(itemIndex);
            item.accept((SQLASTVisitor)this.adapter);
            if (!secureFieldsIndices.contains(itemIndex) || !(item.getExpr() instanceof SQLVariantRefExpr)) continue;
            this.secureBindIndices.add(this.variantIndex);
        }
        queryBlock.getFrom().accept((SQLASTVisitor)this.adapter);
        this.parseTable(queryBlock.getFrom());
        if (queryBlock.getWhere() != null) {
            queryBlock.getWhere().accept((SQLASTVisitor)this.adapter);
        }
    }

    private void walkInsertValues(List<Integer> secureFieldsIndices, List<SQLExpr> values) {
        int ii = values.size();
        for (int i = 0; i < ii; ++i) {
            SQLExpr expr = values.get(i);
            expr.accept((SQLASTVisitor)this.adapter);
            if (!secureFieldsIndices.contains(i)) continue;
            if (expr instanceof SQLVariantRefExpr) {
                this.secureBindIndices.add(this.variantIndex);
                continue;
            }
            log.warn("secure field is not inserted as a single value in sql [" + this.sql + "]");
        }
    }

    private List<Integer> walkInsertColumns(List<SQLExpr> columns) {
        ArrayList secureFieldsIndices = Lists.newArrayList();
        int ii = columns.size();
        for (int i = 0; i < ii; ++i) {
            SQLIdentifierExpr expr;
            SQLExpr column = columns.get(i);
            if (!(column instanceof SQLIdentifierExpr) || !this.isSecureField(expr = (SQLIdentifierExpr)column)) continue;
            secureFieldsIndices.add(i);
        }
        return secureFieldsIndices;
    }

    @Override
    public Set<Integer> getSecureBindIndices() {
        return this.secureBindIndices;
    }

    @Override
    public Set<Integer> getSecureResultIndices() {
        return this.secureResultIndices;
    }

    @Override
    public Set<String> getSecureResultLabels() {
        return this.secureResultLabels;
    }

    @Override
    public boolean inBindIndices(int index) {
        return this.getSecureBindIndices().contains(index);
    }

    @Override
    public boolean inResultIndices(int index) {
        return this.getSecureResultIndices().contains(index);
    }

    @Override
    public boolean inResultLabels(String label) {
        return this.getSecureResultLabels().contains(label);
    }

    @Override
    public boolean inResultIndicesOrLabel(Object indexOrLabel) {
        if (indexOrLabel instanceof Number) {
            return this.getSecureResultIndices().contains(indexOrLabel);
        }
        if (indexOrLabel instanceof String) {
            String upper = ((String)indexOrLabel).toUpperCase();
            return this.getSecureResultLabels().contains(upper);
        }
        return false;
    }

    @Override
    public boolean haveNonSecureFields() {
        return this.secureResultLabels.isEmpty() && this.secureResultIndices.isEmpty() && this.secureBindIndices.isEmpty();
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public int getVariantIndex() {
        return this.variantIndex;
    }

    static class BindVariant {
        private Integer variantIndex;
        private Set<Integer> bindIndices;

        @ConstructorProperties(value={"variantIndex", "bindIndices"})
        public BindVariant(Integer variantIndex, Set<Integer> bindIndices) {
            this.variantIndex = variantIndex;
            this.bindIndices = bindIndices;
        }

        public Integer getVariantIndex() {
            return this.variantIndex;
        }

        public Set<Integer> getBindIndices() {
            return this.bindIndices;
        }
    }

    static enum QueryBelongs {
        FROM,
        SELECT;

    }
}

