/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.refer;

import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.dbfieldcryptor.EqlSecretFieldsConnectionProxy;
import org.n3r.eql.dbfieldcryptor.SensitiveCryptor;
import org.n3r.eql.dbfieldcryptor.refer.aes.AesCryptor;
import org.n3r.eql.util.S;

public class ReferSensitiveCryptor
implements SensitiveCryptor {
    private AesCryptor aesCryptor;

    public ReferSensitiveCryptor() {
        EqlConfig eqlConfig = EqlSecretFieldsConnectionProxy.threadLocal.get();
        if (eqlConfig == null) {
            return;
        }
        String password = eqlConfig.getStr("securetDatabaseFields.password");
        if (S.isBlank(password)) {
            return;
        }
        this.aesCryptor = new AesCryptor(password);
    }

    @Override
    public String encrypt(String data) {
        return this.aesCryptor == null ? data : this.aesCryptor.encrypt(data);
    }

    @Override
    public String decrypt(String data) {
        return this.aesCryptor == null ? data : this.aesCryptor.decrypt(data);
    }
}

